/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.meta.managers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.meta.MetaDriver;
import org.apache.hugegraph.meta.managers.AbstractMetaManager;
import org.apache.hugegraph.space.GraphSpace;
import org.apache.hugegraph.type.define.CollectionType;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.hugegraph.util.collection.CollectionFactory;

public class SpaceMetaManager
extends AbstractMetaManager {
    public SpaceMetaManager(MetaDriver metaDriver, String cluster) {
        super(metaDriver, cluster);
    }

    public List<String> listGraphSpace() {
        ArrayList<String> result = new ArrayList<String>();
        Map<String, String> graphSpaceMap = this.metaDriver.scanWithPrefix(this.graphSpaceListKey());
        for (Map.Entry<String, String> item : graphSpaceMap.entrySet()) {
            result.add(item.getValue());
        }
        return result;
    }

    public Map<String, GraphSpace> graphSpaceConfigs() {
        Map<String, String> keyValues = this.metaDriver.scanWithPrefix(this.graphSpaceConfPrefix());
        Map<String, GraphSpace> configs = CollectionFactory.newMap(CollectionType.EC);
        for (Map.Entry<String, String> entry : keyValues.entrySet()) {
            String key = entry.getKey();
            String[] parts = key.split("/");
            configs.put(parts[parts.length - 1], JsonUtil.fromJson(entry.getValue(), GraphSpace.class));
        }
        return configs;
    }

    public GraphSpace graphSpace(String name) {
        String space = this.metaDriver.get(this.graphSpaceConfKey(name));
        if (StringUtils.isEmpty((CharSequence)space)) {
            return null;
        }
        return JsonUtil.fromJson(space, GraphSpace.class);
    }

    public GraphSpace getGraphSpaceConfig(String graphSpace) {
        String gs = this.metaDriver.get(this.graphSpaceConfKey(graphSpace));
        if (StringUtils.isEmpty((CharSequence)gs)) {
            return null;
        }
        return JsonUtil.fromJson(gs, GraphSpace.class);
    }

    public void addGraphSpaceConfig(String name, GraphSpace space) {
        this.metaDriver.put(this.graphSpaceConfKey(name), JsonUtil.toJson(space));
    }

    public void removeGraphSpaceConfig(String name) {
        this.metaDriver.delete(this.graphSpaceConfKey(name));
    }

    public void updateGraphSpaceConfig(String name, GraphSpace space) {
        this.metaDriver.put(this.graphSpaceConfKey(name), JsonUtil.toJson(space));
    }

    public void appendGraphSpaceList(String name) {
        String key = this.graphSpaceListKey(name);
        this.metaDriver.put(key, name);
    }

    public void clearGraphSpaceList(String name) {
        String key = this.graphSpaceListKey(name);
        this.metaDriver.delete(key);
    }

    public <T> void listenGraphSpaceAdd(Consumer<T> consumer) {
        this.listen(this.graphSpaceAddKey(), consumer);
    }

    public <T> void listenGraphSpaceRemove(Consumer<T> consumer) {
        this.listen(this.graphSpaceRemoveKey(), consumer);
    }

    public <T> void listenGraphSpaceUpdate(Consumer<T> consumer) {
        this.listen(this.graphSpaceUpdateKey(), consumer);
    }

    public void notifyGraphSpaceAdd(String graphSpace) {
        this.metaDriver.put(this.graphSpaceAddKey(), graphSpace);
    }

    public void notifyGraphSpaceRemove(String graphSpace) {
        this.metaDriver.put(this.graphSpaceRemoveKey(), graphSpace);
    }

    public void notifyGraphSpaceUpdate(String graphSpace) {
        this.metaDriver.put(this.graphSpaceUpdateKey(), graphSpace);
    }

    private String graphSpaceConfPrefix() {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", "CONF");
    }

    private String graphSpaceAddKey() {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "EVENT", "GRAPHSPACE", "ADD");
    }

    private String graphSpaceRemoveKey() {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "EVENT", "GRAPHSPACE", "REMOVE");
    }

    private String graphSpaceUpdateKey() {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "EVENT", "GRAPHSPACE", "UPDATE");
    }

    private String graphSpaceConfKey(String name) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", "CONF", name);
    }

    private String graphSpaceListKey(String name) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE_LIST", name);
    }

    private String graphSpaceListKey() {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE_LIST");
    }
}

