/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure;

import java.util.Iterator;
import org.apache.hugegraph.exception.NotSupportException;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.structure.HugeElement;
import org.apache.hugegraph.structure.HugeProperty;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;

public class HugeVertexProperty<V>
extends HugeProperty<V>
implements VertexProperty<V> {
    public HugeVertexProperty(HugeElement owner, PropertyKey key, V value) {
        super(owner, key, value);
    }

    @Override
    public HugeType type() {
        return this.pkey.aggregateType().isNone() ? HugeType.PROPERTY : HugeType.AGGR_PROPERTY_V;
    }

    public <U> Property<U> property(String key, U value) {
        throw new NotSupportException("nested property");
    }

    @Override
    public HugeVertex element() {
        assert (this.owner instanceof HugeVertex);
        return (HugeVertex)this.owner;
    }

    public void remove() {
        assert (this.owner instanceof HugeVertex);
        VertexLabel vertexLabel = ((HugeVertex)this.owner).schemaLabel();
        E.checkArgument((boolean)vertexLabel.nullableKeys().contains(this.propertyKey().id()), (String)"Can't remove non-null vertex property '%s'", (Object[])new Object[]{this});
        this.owner.graph().removeVertexProperty(this);
    }

    public <U> Iterator<Property<U>> properties(String ... propertyKeys) {
        throw new NotSupportException("nested property");
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof VertexProperty)) {
            return false;
        }
        VertexProperty other = (VertexProperty)obj;
        return this.id().equals(other.id());
    }

    @Override
    public int hashCode() {
        return ElementHelper.hashCode((Element)this);
    }
}

