/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.task;

import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.QueryResults;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.exception.ConnectionException;
import org.apache.hugegraph.exception.NotFoundException;
import org.apache.hugegraph.meta.MetaManager;
import org.apache.hugegraph.meta.lock.LockResult;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.task.HugeTask;
import org.apache.hugegraph.task.TaskAndResultScheduler;
import org.apache.hugegraph.task.TaskCallable;
import org.apache.hugegraph.task.TaskManager;
import org.apache.hugegraph.task.TaskStatus;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.LockUtil;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;

public class DistributedTaskScheduler
extends TaskAndResultScheduler {
    private final long schedulePeriod;
    private static final Logger LOG = Log.logger(DistributedTaskScheduler.class);
    private final ExecutorService taskDbExecutor;
    private final ExecutorService schemaTaskExecutor;
    private final ExecutorService olapTaskExecutor;
    private final ExecutorService ephemeralTaskExecutor;
    private final ExecutorService gremlinTaskExecutor;
    private final ScheduledThreadPoolExecutor schedulerExecutor;
    private final ScheduledFuture<?> cronFuture;
    private final AtomicBoolean closed = new AtomicBoolean(true);
    private final ConcurrentHashMap<Id, HugeTask<?>> runningTasks = new ConcurrentHashMap();

    public DistributedTaskScheduler(HugeGraphParams graph, ScheduledThreadPoolExecutor schedulerExecutor, ExecutorService taskDbExecutor, ExecutorService schemaTaskExecutor, ExecutorService olapTaskExecutor, ExecutorService gremlinTaskExecutor, ExecutorService ephemeralTaskExecutor, ExecutorService serverInfoDbExecutor) {
        super(graph, serverInfoDbExecutor);
        this.taskDbExecutor = taskDbExecutor;
        this.schemaTaskExecutor = schemaTaskExecutor;
        this.olapTaskExecutor = olapTaskExecutor;
        this.gremlinTaskExecutor = gremlinTaskExecutor;
        this.ephemeralTaskExecutor = ephemeralTaskExecutor;
        this.schedulerExecutor = schedulerExecutor;
        this.closed.set(false);
        this.schedulePeriod = (Long)this.graph.configuration().get(CoreOptions.TASK_SCHEDULE_PERIOD);
        this.cronFuture = this.schedulerExecutor.scheduleWithFixedDelay(() -> {
            LockUtil.lock("", "graph_lock");
            try {
                this.cronSchedule();
            }
            catch (Throwable t) {
                LOG.info("cronScheduler exception graph: {}", (Object)this.graphName(), (Object)t);
            }
            finally {
                LockUtil.unlock("", "graph_lock");
            }
        }, 10L, this.schedulePeriod, TimeUnit.SECONDS);
    }

    private static boolean sleep(long ms) {
        try {
            Thread.sleep(ms);
            return true;
        }
        catch (InterruptedException ignored) {
            return false;
        }
    }

    public void cronSchedule() {
        if (!this.graph.started() || this.graph.closed()) {
            return;
        }
        Iterator news = this.queryTaskWithoutResultByStatus(TaskStatus.NEW);
        while (!this.closed.get() && news.hasNext()) {
            HugeTask newTask = news.next();
            LOG.info("Try to start task({})@({}/{})", new Object[]{newTask.id(), this.graphSpace, this.graphName});
            if (this.tryStartHugeTask(newTask)) continue;
            break;
        }
        Iterator runnings = this.queryTaskWithoutResultByStatus(TaskStatus.RUNNING);
        while (!this.closed.get() && runnings.hasNext()) {
            HugeTask running = runnings.next();
            this.initTaskParams(running);
            if (this.isLockedTask(running.id().toString())) continue;
            LOG.info("Try to update task({})@({}/{}) status(RUNNING->FAILED)", new Object[]{running.id(), this.graphSpace, this.graphName});
            if (this.updateStatusWithLock(running.id(), TaskStatus.RUNNING, TaskStatus.FAILED)) {
                this.runningTasks.remove(running.id());
                continue;
            }
            LOG.warn("Update task({})@({}/{}) status(RUNNING->FAILED) failed", new Object[]{running.id(), this.graphSpace, this.graphName});
        }
        Iterator faileds = this.queryTaskWithoutResultByStatus(TaskStatus.FAILED);
        while (!this.closed.get() && faileds.hasNext()) {
            HugeTask failed = faileds.next();
            this.initTaskParams(failed);
            if (failed.retries() >= (Integer)this.graph().option(CoreOptions.TASK_RETRY)) continue;
            LOG.info("Try to update task({})@({}/{}) status(FAILED->NEW)", new Object[]{failed.id(), this.graphSpace, this.graphName});
            this.updateStatusWithLock(failed.id(), TaskStatus.FAILED, TaskStatus.NEW);
        }
        Iterator cancellings = this.queryTaskWithoutResultByStatus(TaskStatus.CANCELLING);
        while (!this.closed.get() && cancellings.hasNext()) {
            Id cancellingId = cancellings.next().id();
            if (this.runningTasks.containsKey(cancellingId)) {
                HugeTask<?> cancelling = this.runningTasks.get(cancellingId);
                this.initTaskParams(cancelling);
                LOG.info("Try to cancel task({})@({}/{})", new Object[]{cancelling.id(), this.graphSpace, this.graphName});
                cancelling.cancel(true);
                this.runningTasks.remove(cancellingId);
                continue;
            }
            if (this.isLockedTask(cancellingId.toString())) continue;
            this.updateStatusWithLock(cancellingId, TaskStatus.CANCELLING, TaskStatus.CANCELLED);
        }
        Iterator deletings = this.queryTaskWithoutResultByStatus(TaskStatus.DELETING);
        while (!this.closed.get() && deletings.hasNext()) {
            Id deletingId = deletings.next().id();
            if (this.runningTasks.containsKey(deletingId)) {
                HugeTask<?> deleting = this.runningTasks.get(deletingId);
                this.initTaskParams(deleting);
                deleting.cancel(true);
                this.deleteFromDB(deletingId);
                this.runningTasks.remove(deletingId);
                continue;
            }
            if (this.isLockedTask(deletingId.toString())) continue;
            this.deleteFromDB(deletingId);
        }
    }

    protected <V> Iterator<HugeTask<V>> queryTaskWithoutResultByStatus(TaskStatus status) {
        if (this.closed.get()) {
            return QueryResults.emptyIterator();
        }
        return this.queryTaskWithoutResult("~task_status", status.code(), -1L, null);
    }

    @Override
    public HugeGraph graph() {
        return this.graph.graph();
    }

    @Override
    public int pendingTasks() {
        return this.runningTasks.size();
    }

    @Override
    public <V> void restoreTasks() {
    }

    @Override
    public <V> Future<?> schedule(HugeTask<V> task) {
        E.checkArgumentNotNull(task, (String)"Task can't be null", (Object[])new Object[0]);
        this.initTaskParams(task);
        if (task.ephemeralTask()) {
            return this.ephemeralTaskExecutor.submit(task);
        }
        this.save(task);
        if (!this.closed.get()) {
            LOG.info("Try to start task({})@({}/{}) immediately", new Object[]{task.id(), this.graphSpace, this.graphName});
            this.tryStartHugeTask(task);
        } else {
            LOG.info("TaskScheduler has closed");
        }
        return null;
    }

    protected <V> void initTaskParams(HugeTask<V> task) {
        task.scheduler(this);
        TaskCallable<V> callable = task.callable();
        callable.task(task);
        callable.graph(this.graph());
        if (callable instanceof TaskCallable.SysTaskCallable) {
            ((TaskCallable.SysTaskCallable)callable).params(this.graph);
        }
    }

    @Override
    public <V> void cancel(HugeTask<V> task) {
        if (!task.completed()) {
            this.updateStatus(task.id(), null, TaskStatus.CANCELLING);
        } else {
            LOG.info("cancel task({}) error, task has completed", (Object)task.id());
        }
    }

    @Override
    public void init() {
        this.call(() -> this.tx().initSchema());
    }

    protected <V> HugeTask<V> deleteFromDB(Id id) {
        return this.call(() -> {
            Iterator<Vertex> vertices = this.tx().queryTaskInfos(id);
            HugeVertex vertex = (HugeVertex)QueryResults.one(vertices);
            if (vertex == null) {
                return null;
            }
            HugeTask result = HugeTask.fromVertex(vertex);
            this.tx().removeVertex(vertex);
            return result;
        });
    }

    @Override
    public <V> HugeTask<V> delete(Id id, boolean force) {
        if (!force) {
            this.updateStatus(id, null, TaskStatus.DELETING);
            return null;
        }
        return this.deleteFromDB(id);
    }

    @Override
    public boolean close() {
        if (this.closed.get()) {
            return true;
        }
        this.closed.set(true);
        for (HugeTask<?> task : this.runningTasks.values()) {
            LOG.info("cancel task({}) @({}/{}) when closing scheduler", new Object[]{task.id(), this.graphSpace, this.graphName});
            this.cancel(task);
        }
        try {
            this.waitUntilAllTasksCompleted(10L);
        }
        catch (TimeoutException e) {
            LOG.warn("Tasks not completed when close distributed task scheduler", (Throwable)e);
        }
        if (!this.cronFuture.isDone() && !this.cronFuture.isCancelled()) {
            this.cronFuture.cancel(false);
        }
        if (!this.taskDbExecutor.isShutdown()) {
            this.call(() -> {
                try {
                    this.tx().close();
                }
                catch (ConnectionException connectionException) {
                    // empty catch block
                }
                this.graph.closeTx();
            });
        }
        return true;
    }

    @Override
    public <V> HugeTask<V> waitUntilTaskCompleted(Id id, long seconds) throws TimeoutException {
        return this.waitUntilTaskCompleted(id, seconds, 100L);
    }

    @Override
    public <V> HugeTask<V> waitUntilTaskCompleted(Id id) throws TimeoutException {
        long timeout = (Long)this.graph.configuration().get(CoreOptions.TASK_WAIT_TIMEOUT);
        return this.waitUntilTaskCompleted(id, timeout, 1L);
    }

    private <V> HugeTask<V> waitUntilTaskCompleted(Id id, long seconds, long intervalMs) throws TimeoutException {
        long passes = seconds * 1000L / intervalMs;
        HugeTask task = null;
        long pass = 0L;
        while (true) {
            try {
                task = this.taskWithoutResult(id);
            }
            catch (NotFoundException e) {
                if (task != null && task.completed()) {
                    assert (task.id().asLong() < 0L) : task.id();
                    DistributedTaskScheduler.sleep(intervalMs);
                    return task;
                }
                throw e;
            }
            if (task.completed()) {
                DistributedTaskScheduler.sleep(intervalMs);
                task = this.task(id);
                return task;
            }
            if (pass >= passes) break;
            DistributedTaskScheduler.sleep(intervalMs);
            ++pass;
        }
        throw new TimeoutException(String.format("Task '%s' was not completed in %s seconds", id, seconds));
    }

    @Override
    public void waitUntilAllTasksCompleted(long seconds) throws TimeoutException {
        long passes = seconds * 1000L / 100L;
        int taskSize = 0;
        long pass = 0L;
        while (true) {
            if ((taskSize = this.pendingTasks()) == 0) {
                DistributedTaskScheduler.sleep(100L);
                return;
            }
            if (pass >= passes) break;
            DistributedTaskScheduler.sleep(100L);
            ++pass;
        }
        throw new TimeoutException(String.format("There are still %s incomplete tasks after %s seconds", taskSize, seconds));
    }

    @Override
    public void checkRequirement(String op) {
        if (!this.serverManager().selfIsMaster()) {
            throw new HugeException("Can't %s task on non-master server", op);
        }
    }

    @Override
    public <V> V call(Callable<V> callable) {
        return this.call(callable, this.taskDbExecutor);
    }

    @Override
    public <V> V call(Runnable runnable) {
        return this.call(Executors.callable(runnable, null));
    }

    private <V> V call(Callable<V> callable, ExecutorService executor) {
        try {
            callable = new TaskManager.ContextCallable<V>(callable);
            return executor.submit(callable).get();
        }
        catch (Exception e) {
            throw new HugeException("Failed to update/query TaskStore for graph(%s/%s): %s", (Throwable)e, this.graphSpace, this.graph.name(), e.toString());
        }
    }

    protected boolean updateStatus(Id id, TaskStatus prestatus, TaskStatus status) {
        HugeTask task = this.taskWithoutResult(id);
        this.initTaskParams(task);
        if (prestatus == null || task.status() == prestatus) {
            task.overwriteStatus(status);
            if (prestatus == TaskStatus.FAILED && status == TaskStatus.NEW) {
                task.retry();
            }
            this.save(task);
            LOG.info("Update task({}) success: pre({}), status({})", new Object[]{id, prestatus, status});
            return true;
        }
        LOG.warn("Update task({}) status conflict: current({}), pre({}), status({})", new Object[]{id, task.status(), prestatus, status});
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateStatusWithLock(Id id, TaskStatus prestatus, TaskStatus status) {
        LockResult lockResult = this.tryLockTask(id.asString());
        if (lockResult.lockSuccess()) {
            try {
                boolean bl = this.updateStatus(id, prestatus, status);
                return bl;
            }
            finally {
                this.unlockTask(id.asString(), lockResult);
            }
        }
        return false;
    }

    private boolean tryStartHugeTask(HugeTask<?> task) {
        ThreadPoolExecutor executor;
        this.logCurrentState();
        this.initTaskParams(task);
        ExecutorService chosenExecutor = this.gremlinTaskExecutor;
        if (task.computer()) {
            chosenExecutor = this.olapTaskExecutor;
        }
        if (task.gremlinTask()) {
            chosenExecutor = this.gremlinTaskExecutor;
        }
        if (task.schemaTask()) {
            chosenExecutor = this.schemaTaskExecutor;
        }
        if ((executor = (ThreadPoolExecutor)chosenExecutor).getActiveCount() < executor.getMaximumPoolSize()) {
            TaskRunner runner = new TaskRunner(task);
            chosenExecutor.submit(runner);
            LOG.info("Submit task({})@({}/{})", new Object[]{task.id(), this.graphSpace, this.graphName});
            return true;
        }
        return false;
    }

    protected void logCurrentState() {
        int gremlinActive = ((ThreadPoolExecutor)this.gremlinTaskExecutor).getActiveCount();
        int schemaActive = ((ThreadPoolExecutor)this.schemaTaskExecutor).getActiveCount();
        int ephemeralActive = ((ThreadPoolExecutor)this.ephemeralTaskExecutor).getActiveCount();
        int olapActive = ((ThreadPoolExecutor)this.olapTaskExecutor).getActiveCount();
        LOG.info("Current State: gremlinTaskExecutor({}), schemaTaskExecutor({}), ephemeralTaskExecutor({}), olapTaskExecutor({})", new Object[]{gremlinActive, schemaActive, ephemeralActive, olapActive});
    }

    private LockResult tryLockTask(String taskId) {
        LockResult lockResult = new LockResult();
        try {
            lockResult = MetaManager.instance().tryLockTask(this.graphSpace, this.graphName, taskId);
        }
        catch (Throwable t) {
            LOG.warn(String.format("try to lock task(%s) error", taskId), t);
        }
        return lockResult;
    }

    private void unlockTask(String taskId, LockResult lockResult) {
        try {
            MetaManager.instance().unlockTask(this.graphSpace, this.graphName, taskId, lockResult);
        }
        catch (Throwable t) {
            LOG.warn(String.format("try to unlock task(%s) error", taskId), t);
        }
    }

    private boolean isLockedTask(String taskId) {
        return MetaManager.instance().isLockedTask(this.graphSpace, this.graphName, taskId);
    }

    @Override
    public String graphName() {
        return this.graph.name();
    }

    @Override
    public void taskDone(HugeTask<?> task) {
    }

    private class TaskRunner<V>
    implements Runnable {
        private final HugeTask<V> task;

        public TaskRunner(HugeTask<V> task) {
            this.task = task;
        }

        @Override
        public void run() {
            LockResult lockResult = DistributedTaskScheduler.this.tryLockTask(this.task.id().asString());
            DistributedTaskScheduler.this.initTaskParams(this.task);
            if (lockResult.lockSuccess() && !this.task.completed()) {
                LOG.info("Start task({})", (Object)this.task.id());
                TaskManager.setContext(this.task.context());
                try {
                    HugeTask queryTask = DistributedTaskScheduler.this.task(this.task.id());
                    if (queryTask != null && !TaskStatus.NEW.equals(queryTask.status())) {
                        return;
                    }
                    DistributedTaskScheduler.this.runningTasks.put(this.task.id(), this.task);
                    this.task.run();
                }
                catch (Throwable t) {
                    LOG.warn("exception when execute task", t);
                }
                finally {
                    DistributedTaskScheduler.this.runningTasks.remove(this.task.id());
                    DistributedTaskScheduler.this.unlockTask(this.task.id().asString(), lockResult);
                    LOG.info("task({}) finished.", (Object)this.task.id().toString());
                }
            }
        }
    }
}

