/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.traversal.algorithm.OltpTraverser;
import org.apache.hugegraph.traversal.algorithm.SameNeighborTraverser;
import org.apache.hugegraph.traversal.algorithm.steps.EdgeStep;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;

public class PredictionTraverser
extends OltpTraverser {
    public PredictionTraverser(HugeGraph graph) {
        super(graph);
    }

    public double adamicAdar(Id source, Id target, Directions dir, String label, long degree, int limit) {
        Set<Id> neighbors = this.checkAndGetCommonNeighbors(source, target, dir, label, degree, limit);
        EdgeStep step = label == null ? new EdgeStep(this.graph(), dir) : new EdgeStep(this.graph(), dir, (List<String>)ImmutableList.of((Object)label));
        double sum = 0.0;
        for (Id vid : neighbors) {
            long currentDegree = this.edgesCount(vid, step);
            if (currentDegree <= 0L) continue;
            sum += 1.0 / Math.log(currentDegree);
        }
        return sum;
    }

    public double resourceAllocation(Id source, Id target, Directions dir, String label, long degree, int limit) {
        Set<Id> neighbors = this.checkAndGetCommonNeighbors(source, target, dir, label, degree, limit);
        EdgeStep step = label == null ? new EdgeStep(this.graph(), dir) : new EdgeStep(this.graph(), dir, (List<String>)ImmutableList.of((Object)label));
        double sum = 0.0;
        for (Id vid : neighbors) {
            long currentDegree = this.edgesCount(vid, step);
            if (currentDegree <= 0L) continue;
            sum += 1.0 / (double)currentDegree;
        }
        return sum;
    }

    private Set<Id> checkAndGetCommonNeighbors(Id source, Id target, Directions dir, String label, long degree, int limit) {
        E.checkNotNull((Object)source, (String)"source id");
        E.checkNotNull((Object)target, (String)"the target id");
        this.checkVertexExist(source, "source");
        this.checkVertexExist(target, "target");
        E.checkNotNull((Object)dir, (String)"direction");
        PredictionTraverser.checkDegree(degree);
        SameNeighborTraverser traverser = new SameNeighborTraverser(this.graph());
        return traverser.sameNeighbors(source, target, dir, label, degree, limit);
    }
}

