/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.optimize;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.hugegraph.traversal.optimize.HugeCountStepStrategy;
import org.apache.hugegraph.traversal.optimize.HugeGraphStep;
import org.apache.hugegraph.traversal.optimize.TraversalUtil;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;

public final class HugeGraphStepStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    private static final long serialVersionUID = -2952498905649139719L;
    private static final HugeGraphStepStrategy INSTANCE = new HugeGraphStepStrategy();

    private HugeGraphStepStrategy() {
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        TraversalUtil.convAllHasSteps(traversal);
        List steps = TraversalHelper.getStepsOfClass(GraphStep.class, traversal);
        for (GraphStep originStep : steps) {
            TraversalUtil.trySetGraph(originStep, TraversalUtil.tryGetGraph((Step)steps.get(0)));
            HugeGraphStep newStep = new HugeGraphStep(originStep);
            TraversalHelper.replaceStep((Step)originStep, newStep, traversal);
            TraversalUtil.extractHasContainer(newStep, traversal);
            TraversalUtil.extractRange(newStep, traversal, false);
            TraversalUtil.extractCount(newStep, traversal);
        }
    }

    public Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> applyPost() {
        return Collections.singleton(HugeCountStepStrategy.class);
    }

    public static HugeGraphStepStrategy instance() {
        return INSTANCE;
    }
}

