/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.rpc;

import com.alipay.sofa.rpc.bootstrap.Bootstraps;
import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.client.AbstractCluster;
import com.alipay.sofa.rpc.client.Cluster;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.ext.ExtensionLoaderFactory;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.RpcOptions;
import org.apache.hugegraph.rpc.RpcCommonConfig;
import org.apache.hugegraph.rpc.RpcServiceConfig4Client;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class RpcConsumerConfig
implements RpcServiceConfig4Client {
    private final HugeConfig conf;
    private final String remoteUrls;
    private final Map<String, ConsumerConfig<?>> configs;
    private final List<ConsumerBootstrap<?>> bootstraps;

    public RpcConsumerConfig(HugeConfig config, String remoteUrls) {
        RpcCommonConfig.initRpcConfigs(config);
        this.conf = config;
        this.remoteUrls = remoteUrls;
        this.configs = Maps.newHashMap();
        this.bootstraps = Lists.newArrayList();
    }

    @Override
    public <T> T serviceProxy(String interfaceId) {
        return this.serviceProxy(null, interfaceId);
    }

    @Override
    public <T> T serviceProxy(String graph, String interfaceId) {
        ConsumerConfig<T> config = this.consumerConfig(graph, interfaceId);
        ConsumerBootstrap bootstrap = Bootstraps.from(config);
        this.bootstraps.add(bootstrap);
        return (T)bootstrap.refer();
    }

    @Override
    public void removeAllServiceProxy() {
        for (ConsumerBootstrap<?> bootstrap : this.bootstraps) {
            bootstrap.unRefer();
        }
    }

    public void destroy() {
        HashSet clusters = Sets.newHashSet();
        for (ConsumerBootstrap<?> bootstrap : this.bootstraps) {
            bootstrap.unRefer();
            clusters.add(bootstrap.getCluster());
        }
        for (Cluster cluster : clusters) {
            cluster.destroy();
        }
    }

    private <T> ConsumerConfig<T> consumerConfig(String graph, String interfaceId) {
        String serviceId = graph != null ? interfaceId + ":" + graph : interfaceId;
        ConsumerConfig consumerConfig = this.configs.get(serviceId);
        if (consumerConfig != null) {
            return consumerConfig;
        }
        assert (consumerConfig == null);
        consumerConfig = new ConsumerConfig();
        HugeConfig conf = this.conf;
        String protocol = (String)conf.get(RpcOptions.RPC_PROTOCOL);
        int timeout = (Integer)conf.get(RpcOptions.RPC_CLIENT_READ_TIMEOUT) * 1000;
        int connectTimeout = (Integer)conf.get(RpcOptions.RPC_CLIENT_CONNECT_TIMEOUT) * 1000;
        int reconnectPeriod = (Integer)conf.get(RpcOptions.RPC_CLIENT_RECONNECT_PERIOD) * 1000;
        int retries = (Integer)conf.get(RpcOptions.RPC_CLIENT_RETRIES);
        String loadBalancer = (String)conf.get(RpcOptions.RPC_CLIENT_LOAD_BALANCER);
        if (graph != null) {
            ((ConsumerConfig)consumerConfig.setId(serviceId)).setUniqueId(graph);
            consumerConfig.setCluster("fanout");
        }
        ((ConsumerConfig)consumerConfig.setInterfaceId(interfaceId)).setProtocol(protocol).setDirectUrl(this.remoteUrls).setTimeout(timeout).setConnectTimeout(connectTimeout).setReconnectPeriod(reconnectPeriod).setRetries(retries).setSerialization((String)conf.get(RpcOptions.RPC_SERIALIZATION)).setLoadBalancer(loadBalancer);
        this.configs.put(serviceId, consumerConfig);
        return consumerConfig;
    }

    static {
        ExtensionLoaderFactory.getExtensionLoader(Cluster.class).loadExtension(FanoutCluster.class);
    }

    @Extension(value="fanout")
    private static class FanoutCluster
    extends AbstractCluster {
        private static final Logger LOG = Log.logger(FanoutCluster.class);

        FanoutCluster(ConsumerBootstrap<?> consumerBootstrap) {
            super(consumerBootstrap);
        }

        protected SofaResponse doInvoke(SofaRequest request) throws SofaRpcException {
            List providers = this.getRouterChain().route(request, null);
            ArrayList<SofaResponse> responses = new ArrayList<SofaResponse>(providers.size());
            ArrayList<SofaRpcException> excepts = new ArrayList<SofaRpcException>(providers.size());
            for (ProviderInfo provider : providers) {
                try {
                    SofaResponse response = this.doInvoke(request, provider);
                    responses.add(response);
                }
                catch (SofaRpcException e) {
                    excepts.add(e);
                    LOG.warn("{}.(error {})", (Object)e.getMessage(), (Object)e.getErrorType());
                }
            }
            if (!responses.isEmpty()) {
                return (SofaResponse)responses.get(0);
            }
            if (!excepts.isEmpty()) {
                throw (SofaRpcException)((Object)excepts.get(0));
            }
            assert (providers.isEmpty());
            String method = FanoutCluster.methodName(request);
            throw new SofaRpcException(210, "No service provider for " + method);
        }

        private SofaResponse doInvoke(SofaRequest request, ProviderInfo providerInfo) {
            try {
                SofaResponse response = this.filterChain(providerInfo, request);
                if (response != null) {
                    return response;
                }
                String method = FanoutCluster.methodName(request);
                throw new SofaRpcException(299, "Failed to call " + method + " on remote server " + providerInfo + ", return null response");
            }
            catch (Exception e) {
                int error = 299;
                if (e instanceof SofaRpcException) {
                    error = ((SofaRpcException)((Object)e)).getErrorType();
                }
                String method = FanoutCluster.methodName(request);
                throw new SofaRpcException(error, "Failed to call " + method + " on remote server " + providerInfo + ", caused by exception: " + e);
            }
        }

        private static String methodName(SofaRequest request) {
            return request.getInterfaceName() + "." + request.getMethodName() + "()";
        }
    }
}

