/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store;

import javax.annotation.concurrent.ThreadSafe;
import org.apache.hugegraph.pd.client.PDClient;
import org.apache.hugegraph.pd.client.PDConfig;
import org.apache.hugegraph.store.HgSessionProvider;
import org.apache.hugegraph.store.HgStoreSession;
import org.apache.hugegraph.store.client.HgStoreNodeManager;
import org.apache.hugegraph.store.client.HgStoreNodePartitionerImpl;
import org.apache.hugegraph.store.client.HgStoreSessionProvider;

@ThreadSafe
public final class HgStoreClient {
    private final HgSessionProvider sessionProvider = new HgStoreSessionProvider();
    private PDClient pdClient;

    public HgStoreClient() {
    }

    public HgStoreClient(PDConfig config) {
        this.pdClient = PDClient.create((PDConfig)config);
        this.setPdClient(this.pdClient);
    }

    public HgStoreClient(PDClient pdClient) {
        this.setPdClient(pdClient);
    }

    public static HgStoreClient create(PDConfig config) {
        return new HgStoreClient(config);
    }

    public static HgStoreClient create(PDClient pdClient) {
        return new HgStoreClient(pdClient);
    }

    public static HgStoreClient create() {
        return new HgStoreClient();
    }

    public void setPDConfig(PDConfig config) {
        this.pdClient = PDClient.create((PDConfig)config);
        this.setPdClient(this.pdClient);
    }

    public HgStoreSession openSession(String graphName) {
        return this.sessionProvider.createSession(graphName);
    }

    public PDClient getPdClient() {
        return this.pdClient;
    }

    public void setPdClient(PDClient client) {
        this.pdClient = client;
        HgStoreNodeManager nodeManager = HgStoreNodeManager.getInstance();
        HgStoreNodePartitionerImpl p = new HgStoreNodePartitionerImpl(this.pdClient, nodeManager);
        nodeManager.setNodeProvider(p);
        nodeManager.setNodePartitioner(p);
        nodeManager.setNodeNotifier(p);
    }
}

