/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.grpc;

import io.grpc.stub.StreamObserver;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hugegraph.store.HgKvEntry;
import org.apache.hugegraph.store.HgKvIterator;
import org.apache.hugegraph.store.HgKvOrderedIterator;
import org.apache.hugegraph.store.HgOwnerKey;
import org.apache.hugegraph.store.HgScanQuery;
import org.apache.hugegraph.store.buffer.KVByteBuffer;
import org.apache.hugegraph.store.client.grpc.GrpcKvEntryImpl;
import org.apache.hugegraph.store.client.grpc.KvBatchScannerMerger;
import org.apache.hugegraph.store.client.grpc.KvBatchUtil;
import org.apache.hugegraph.store.client.grpc.KvCloseableIterator;
import org.apache.hugegraph.store.client.util.PropertyUtil;
import org.apache.hugegraph.store.grpc.common.Header;
import org.apache.hugegraph.store.grpc.common.ScanOrderType;
import org.apache.hugegraph.store.grpc.stream.HgStoreStreamGrpc;
import org.apache.hugegraph.store.grpc.stream.KvStream;
import org.apache.hugegraph.store.grpc.stream.ScanReceiptRequest;
import org.apache.hugegraph.store.grpc.stream.ScanStreamBatchReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class KvBatchScanner
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(KvBatchScanner.class);
    static final Supplier<HgKvIterator<HgKvEntry>> NO_DATA = () -> null;
    static int maxTaskSizePerStore = PropertyUtil.getInt("net.kv.scanner.task.size", 8);
    private final StreamObserver<ScanStreamBatchReq> sender;
    private final KvBatchScannerMerger notifier;
    private final String graphName;
    private final HgScanQuery scanQuery;
    private final ScanReceiptRequest.Builder responseBuilder = ScanReceiptRequest.newBuilder();
    private final KvBatchReceiver receiver;
    volatile int currentSeqNo = 0;
    private volatile boolean running;

    public KvBatchScanner(HgStoreStreamGrpc.HgStoreStreamStub stub, String graphName, HgScanQuery scanQuery, KvCloseableIterator iterator) {
        this.graphName = graphName;
        this.notifier = (KvBatchScannerMerger)iterator;
        this.notifier.registerScanner(this);
        this.running = true;
        this.scanQuery = scanQuery;
        this.receiver = new KvBatchReceiver(this, scanQuery.getOrderType() == ScanOrderType.ORDER_STRICT);
        this.sender = stub.scanBatch2((StreamObserver)this.receiver);
        this.sendQuery(this.scanQuery);
    }

    public static KvCloseableIterator ofMerger(HgScanQuery scanQuery, BiFunction<HgScanQuery, KvCloseableIterator, Boolean> handler) {
        KvBatchScannerMerger merger = scanQuery.getOrderType() == ScanOrderType.ORDER_STRICT ? new KvBatchScannerMerger.SortedScannerMerger(new TaskSplitter(scanQuery, handler)) : new KvBatchScannerMerger(new TaskSplitter(scanQuery, handler));
        merger.startTask();
        return merger;
    }

    public static void scan(HgStoreStreamGrpc.HgStoreStreamStub stub, String graphName, HgScanQuery scanQuery, KvCloseableIterator iterator) {
        new KvBatchScanner(stub, graphName, scanQuery, iterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendQuery(HgScanQuery query) {
        StreamObserver<ScanStreamBatchReq> streamObserver = this.sender;
        synchronized (streamObserver) {
            if (this.running) {
                this.sender.onNext((Object)ScanStreamBatchReq.newBuilder().setHeader(Header.newBuilder().setGraph(this.graphName).build()).setQueryRequest(KvBatchUtil.createQueryReq(query, 0L)).build());
            }
        }
    }

    public void sendResponse() {
        try {
            this.sendResponse(this.currentSeqNo);
        }
        catch (Exception e) {
            log.error("exception", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResponse(int seqNo) {
        this.currentSeqNo = seqNo;
        StreamObserver<ScanStreamBatchReq> streamObserver = this.sender;
        synchronized (streamObserver) {
            if (this.running) {
                this.sender.onNext((Object)ScanStreamBatchReq.newBuilder().setHeader(Header.newBuilder().setGraph(this.graphName).build()).setReceiptRequest(this.responseBuilder.setTimes(seqNo).build()).build());
            }
        }
    }

    public void dataArrived(Supplier<HgKvIterator<HgKvEntry>> supplier) throws InterruptedException {
        this.notifier.dataArrived(this, supplier);
    }

    public void dataComplete() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.notifier.unregisterScanner(this) < 0) {
                this.notifier.dataArrived(this, NO_DATA);
            }
        }
        catch (InterruptedException e) {
            log.error("exception ", (Throwable)e);
        }
        StreamObserver<ScanStreamBatchReq> streamObserver = this.sender;
        synchronized (streamObserver) {
            try {
                if (this.running) {
                    this.sender.onCompleted();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.running = false;
        }
    }

    static class KVBytesIterator
    implements HgKvOrderedIterator<HgKvEntry> {
        private final KvBatchScanner scanner;
        KVByteBuffer buffer;
        HgKvEntry entry;
        int sn;
        boolean hasSN;

        public KVBytesIterator(ByteBuffer buffer, boolean hasNo, KvBatchScanner scanner) {
            this.buffer = new KVByteBuffer(buffer);
            this.hasSN = hasNo;
            this.scanner = scanner;
        }

        @Override
        public void close() {
        }

        @Override
        public byte[] key() {
            return this.entry.key();
        }

        @Override
        public byte[] value() {
            return this.entry.value();
        }

        @Override
        public byte[] position() {
            return new byte[0];
        }

        @Override
        public void seek(byte[] position) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public boolean hasNext() {
            return this.buffer.hasRemaining();
        }

        @Override
        public HgKvEntry next() {
            if (this.hasSN) {
                this.sn = this.buffer.getInt();
            }
            this.entry = new GrpcKvEntryImpl(this.buffer.getBytes(), this.buffer.getBytes(), 0);
            return this.entry;
        }

        @Override
        public long getSequence() {
            return this.sn;
        }

        @Override
        public int compareTo(HgKvOrderedIterator o) {
            return Long.compare(this.getSequence(), o.getSequence());
        }
    }

    static class KvBatchReceiver
    implements StreamObserver<KvStream> {
        KvBatchScanner scanner;
        boolean sortByVertex;

        KvBatchReceiver(KvBatchScanner scanner, boolean sortByVertex) {
            this.scanner = scanner;
            this.sortByVertex = sortByVertex;
        }

        public void onNext(KvStream value) {
            try {
                ByteBuffer buffer = value.getStream();
                int seqNo = value.getSeqNo();
                boolean isOver = value.getOver();
                this.scanner.dataArrived(() -> {
                    this.scanner.sendResponse(seqNo);
                    if (isOver) {
                        this.scanner.dataComplete();
                    }
                    return new KVBytesIterator(buffer, this.sortByVertex, this.scanner);
                });
            }
            catch (InterruptedException e) {
                this.close();
                log.error("exception ", (Throwable)e);
                throw new RuntimeException(e);
            }
        }

        public void onError(Throwable t) {
            log.error("exception ", t);
            this.close();
        }

        public void onCompleted() {
            this.close();
        }

        private void close() {
            if (this.scanner != null) {
                this.scanner.close();
            }
        }
    }

    static class TaskSplitter {
        final HgScanQuery scanQuery;
        final BiFunction<HgScanQuery, KvCloseableIterator, Boolean> taskHandler;
        private KvBatchScannerMerger notifier;
        private Iterator<HgOwnerKey> prefixItr;
        private int maxTaskSize = 0;
        private int maxBatchSize = PropertyUtil.getInt("net.kv.scanner.batch.size", 1000);
        private volatile boolean finished = false;
        private volatile boolean splitting = false;
        private volatile int nextKeySerialNo = 1;

        public TaskSplitter(HgScanQuery scanQuery, BiFunction<HgScanQuery, KvCloseableIterator, Boolean> handler) {
            this.scanQuery = scanQuery;
            this.taskHandler = handler;
            if (scanQuery.getScanMethod() == HgScanQuery.ScanMethod.PREFIX) {
                this.prefixItr = scanQuery.getPrefixItr() != null ? scanQuery.getPrefixItr() : scanQuery.getPrefixList().listIterator();
            }
        }

        public void setNotifier(KvBatchScannerMerger notifier) {
            this.notifier = notifier;
        }

        public boolean isFinished() {
            return this.finished;
        }

        private void evaluateMaxTaskSize() {
            if (this.maxTaskSize == 0) {
                this.maxTaskSize = this.scanQuery.getOrderType() == ScanOrderType.ORDER_STRICT ? 1 : this.notifier.getScannerCount() * maxTaskSizePerStore;
                this.maxBatchSize = this.notifier.getScannerCount() * this.maxBatchSize;
                if (this.scanQuery.getLimit() < (long)this.maxBatchSize * 30L) {
                    this.maxTaskSize = 1;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void splitTask() {
            if (this.finished || this.splitting) {
                return;
            }
            TaskSplitter taskSplitter = this;
            synchronized (taskSplitter) {
                if (this.finished) {
                    return;
                }
                this.splitting = true;
                if (this.scanQuery.getScanMethod() == HgScanQuery.ScanMethod.PREFIX) {
                    if (this.prefixItr.hasNext() && (this.maxTaskSize == 0 || this.notifier.getScannerCount() < this.maxTaskSize)) {
                        ArrayList<HgOwnerKey> keys = new ArrayList<HgOwnerKey>(this.maxBatchSize);
                        for (int i = 0; i < this.maxBatchSize && this.prefixItr.hasNext(); ++i) {
                            keys.add(this.prefixItr.next().setSerialNo(this.nextKeySerialNo++));
                        }
                        this.taskHandler.apply(HgScanQuery.prefixOf(this.scanQuery.getTable(), keys, this.scanQuery.getOrderType()), this.notifier);
                        this.evaluateMaxTaskSize();
                        if (this.notifier.getScannerCount() < this.maxTaskSize) {
                            this.splitTask();
                        }
                    }
                    this.finished = !this.prefixItr.hasNext();
                } else {
                    this.taskHandler.apply(this.scanQuery, this.notifier);
                    this.finished = true;
                }
                this.splitting = false;
            }
        }

        public synchronized void close() {
            this.finished = true;
        }
    }
}

