/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.linked;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.caffinitas.ohc.linked.Uns;
import org.caffinitas.ohc.linked.Util;
import org.caffinitas.ohc.util.ByteBufferCompat;

final class BufferedWritableByteChannel
implements WritableByteChannel {
    private final WritableByteChannel delegate;
    private final long bufferAddress;
    private ByteBuffer buffer;
    private boolean closed;

    BufferedWritableByteChannel(WritableByteChannel delegate, int bufferSize) throws IOException {
        this.delegate = delegate;
        this.bufferAddress = Uns.allocateIOException(bufferSize);
        this.buffer = Uns.directBufferFor(this.bufferAddress, 0L, bufferSize, false);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int wr = 0;
        int sr;
        while ((sr = src.remaining()) != 0) {
            int br = this.buffer.remaining();
            if (br == 0) {
                ByteBufferCompat.byteBufferFlip(this.buffer);
                Util.writeFully(this.delegate, this.buffer);
                ByteBufferCompat.byteBufferClear(this.buffer);
            }
            if (sr > br) {
                int lim = src.limit();
                ByteBufferCompat.byteBufferLimit(src, src.position() + br);
                this.buffer.put(src);
                ByteBufferCompat.byteBufferPosition(src, src.limit());
                ByteBufferCompat.byteBufferLimit(src, lim);
                wr += br;
                continue;
            }
            this.buffer.put(src);
            wr += sr;
        }
        return wr;
    }

    @Override
    public boolean isOpen() {
        return this.buffer != null;
    }

    @Override
    public void close() throws IOException {
        ByteBufferCompat.byteBufferFlip(this.buffer);
        Util.writeFully(this.delegate, this.buffer);
        this.buffer = null;
        if (!this.closed) {
            Uns.free(this.bufferAddress);
        }
        this.closed = true;
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            Uns.free(this.bufferAddress);
        }
        super.finalize();
    }
}

