/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.dic;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.wltea.analyzer.dic.Hit;

class DictSegment
implements Comparable<DictSegment> {
    private static final Map<Character, Character> charMap = new HashMap<Character, Character>(16, 0.95f);
    private static final int ARRAY_LENGTH_LIMIT = 3;
    private Map<Character, DictSegment> childrenMap;
    private DictSegment[] childrenArray;
    private Character nodeChar;
    private int storeSize = 0;
    private int nodeState = 0;

    DictSegment(Character nodeChar) {
        if (nodeChar == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e3a\u7a7a\u5f02\u5e38\uff0c\u5b57\u7b26\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.nodeChar = nodeChar;
    }

    Character getNodeChar() {
        return this.nodeChar;
    }

    boolean hasNextNode() {
        return this.storeSize > 0;
    }

    Hit match(char[] charArray) {
        return this.match(charArray, 0, charArray.length, null);
    }

    Hit match(char[] charArray, int begin, int length) {
        return this.match(charArray, begin, length, null);
    }

    Hit match(char[] charArray, int begin, int length, Hit searchHit) {
        if (searchHit == null) {
            searchHit = new Hit();
            searchHit.setBegin(begin);
        } else {
            searchHit.setUnmatch();
        }
        searchHit.setEnd(begin);
        Character keyChar = new Character(charArray[begin]);
        Object ds = null;
        Object[] segmentArray = this.childrenArray;
        Map<Character, DictSegment> segmentMap = this.childrenMap;
        if (segmentArray != null) {
            DictSegment keySegment = new DictSegment(keyChar);
            int position = Arrays.binarySearch(segmentArray, 0, this.storeSize, keySegment);
            if (position >= 0) {
                ds = segmentArray[position];
            }
        } else if (segmentMap != null) {
            ds = segmentMap.get(keyChar);
        }
        if (ds != null) {
            if (length > 1) {
                return ((DictSegment)ds).match(charArray, begin + 1, length - 1, searchHit);
            }
            if (length == 1) {
                if (((DictSegment)ds).nodeState == 1) {
                    searchHit.setMatch();
                }
                if (((DictSegment)ds).hasNextNode()) {
                    searchHit.setPrefix();
                    searchHit.setMatchedDictSegment((DictSegment)ds);
                }
                return searchHit;
            }
        }
        return searchHit;
    }

    void fillSegment(char[] charArray) {
        this.fillSegment(charArray, 0, charArray.length, 1);
    }

    void disableSegment(char[] charArray) {
        this.fillSegment(charArray, 0, charArray.length, 0);
    }

    private synchronized void fillSegment(char[] charArray, int begin, int length, int enabled) {
        DictSegment ds;
        Character beginChar = new Character(charArray[begin]);
        Character keyChar = charMap.get(beginChar);
        if (keyChar == null) {
            charMap.put(beginChar, beginChar);
            keyChar = beginChar;
        }
        if ((ds = this.lookforSegment(keyChar, enabled)) != null) {
            if (length > 1) {
                ds.fillSegment(charArray, begin + 1, length - 1, enabled);
            } else if (length == 1) {
                ds.nodeState = enabled;
            }
        }
    }

    private DictSegment lookforSegment(Character keyChar, int create) {
        Object ds = null;
        if (this.storeSize <= 3) {
            DictSegment keySegment;
            Object[] segmentArray = this.getChildrenArray();
            int position = Arrays.binarySearch(segmentArray, 0, this.storeSize, keySegment = new DictSegment(keyChar));
            if (position >= 0) {
                ds = segmentArray[position];
            }
            if (ds == null && create == 1) {
                ds = keySegment;
                if (this.storeSize < 3) {
                    segmentArray[this.storeSize] = ds;
                    ++this.storeSize;
                    Arrays.sort(segmentArray, 0, this.storeSize);
                } else {
                    Map<Character, DictSegment> segmentMap = this.getChildrenMap();
                    this.migrate((DictSegment[])segmentArray, segmentMap);
                    segmentMap.put(keyChar, (DictSegment)ds);
                    ++this.storeSize;
                    this.childrenArray = null;
                }
            }
        } else {
            Map<Character, DictSegment> segmentMap = this.getChildrenMap();
            ds = segmentMap.get(keyChar);
            if (ds == null && create == 1) {
                ds = new DictSegment(keyChar);
                segmentMap.put(keyChar, (DictSegment)ds);
                ++this.storeSize;
            }
        }
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DictSegment[] getChildrenArray() {
        if (this.childrenArray == null) {
            DictSegment dictSegment = this;
            synchronized (dictSegment) {
                if (this.childrenArray == null) {
                    this.childrenArray = new DictSegment[3];
                }
            }
        }
        return this.childrenArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Character, DictSegment> getChildrenMap() {
        if (this.childrenMap == null) {
            DictSegment dictSegment = this;
            synchronized (dictSegment) {
                if (this.childrenMap == null) {
                    this.childrenMap = new HashMap<Character, DictSegment>(6, 0.8f);
                }
            }
        }
        return this.childrenMap;
    }

    private void migrate(DictSegment[] segmentArray, Map<Character, DictSegment> segmentMap) {
        for (DictSegment segment : segmentArray) {
            if (segment == null) continue;
            segmentMap.put(segment.nodeChar, segment);
        }
    }

    @Override
    public int compareTo(DictSegment o) {
        return this.nodeChar.compareTo(o.nodeChar);
    }
}

