/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy.jsr223;

import groovy.json.StringEscapeUtils;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationConverter;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.SackFunctions;
import org.apache.tinkerpop.gremlin.process.traversal.Script;
import org.apache.tinkerpop.gremlin.process.traversal.TextP;
import org.apache.tinkerpop.gremlin.process.traversal.Translator;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalOptionParent;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.TraversalStrategyProxy;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.process.traversal.util.OrP;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.function.Lambda;

@Deprecated
public final class GroovyTranslator
implements Translator.ScriptTranslator {
    private final String traversalSource;
    private final Translator.ScriptTranslator.TypeTranslator typeTranslator;

    private GroovyTranslator(String traversalSource, Translator.ScriptTranslator.TypeTranslator typeTranslator) {
        this.traversalSource = traversalSource;
        this.typeTranslator = typeTranslator;
    }

    public static final GroovyTranslator of(String traversalSource) {
        return GroovyTranslator.of(traversalSource, false);
    }

    public static final GroovyTranslator of(String traversalSource, boolean withParameters) {
        return GroovyTranslator.of(traversalSource, new DefaultTypeTranslator(withParameters));
    }

    public static final GroovyTranslator of(String traversalSource, Translator.ScriptTranslator.TypeTranslator typeTranslator) {
        return new GroovyTranslator(traversalSource, typeTranslator);
    }

    public Script translate(Bytecode bytecode) {
        return (Script)this.typeTranslator.apply((Object)this.traversalSource, (Object)bytecode);
    }

    public String getTargetLanguage() {
        return "gremlin-groovy";
    }

    public String toString() {
        return StringFactory.translatorString((Translator)this);
    }

    public String getTraversalSource() {
        return this.traversalSource;
    }

    public static class DefaultTypeTranslator
    implements Translator.ScriptTranslator.TypeTranslator {
        protected final boolean withParameters;
        protected final Script script;

        public DefaultTypeTranslator(boolean withParameters) {
            this.withParameters = withParameters;
            this.script = new Script();
        }

        public Script apply(String traversalSource, Object o) {
            this.script.init();
            if (o instanceof Bytecode) {
                return this.internalTranslate(traversalSource, (Bytecode)o);
            }
            return this.convertToScript(o);
        }

        protected Script convertToScript(Object object) {
            if (object instanceof Bytecode.Binding) {
                return this.script.getBoundKeyOrAssign(this.withParameters, (Object)((Bytecode.Binding)object).variable());
            }
            if (object instanceof Bytecode) {
                return this.internalTranslate("__", (Bytecode)object);
            }
            if (object instanceof Traversal) {
                return this.convertToScript(((Traversal)object).asAdmin().getBytecode());
            }
            if (object instanceof String) {
                String wrapper = (((String)object).contains("\"") ? "\"\"\"" + StringEscapeUtils.escapeJava((String)((String)object)) + "\"\"\"" : "\"" + StringEscapeUtils.escapeJava((String)((String)object)) + "\"").replace("$", "\\$");
                return this.script.getBoundKeyOrAssign(this.withParameters, this.withParameters ? object : wrapper);
            }
            if (object instanceof Set) {
                this.convertToScript(((Set)object).stream().collect(Collectors.toList()));
                return this.script.append(" as Set");
            }
            if (object instanceof List) {
                Iterator iterator = ((List)object).iterator();
                if (!iterator.hasNext()) {
                    return this.script.append("[]");
                }
                this.script.append("[");
                while (true) {
                    Object e = iterator.next();
                    this.convertToScript(e);
                    if (!iterator.hasNext()) {
                        return this.script.append("]");
                    }
                    this.script.append(",").append(" ");
                }
            }
            if (object instanceof Map) {
                this.script.append("[");
                for (Map.Entry entry : ((Map)object).entrySet()) {
                    this.script.append("(");
                    this.convertToScript(entry.getKey());
                    this.script.append("):(");
                    this.convertToScript(entry.getValue());
                    this.script.append("),");
                }
                if (!((Map)object).isEmpty()) {
                    return this.script.setCharAtEnd(']');
                }
                return this.script.append("]");
            }
            if (object instanceof Long) {
                return this.script.getBoundKeyOrAssign(this.withParameters, this.withParameters ? object : object + "L");
            }
            if (object instanceof Double) {
                return this.script.getBoundKeyOrAssign(this.withParameters, this.withParameters ? object : object + "d");
            }
            if (object instanceof Float) {
                return this.script.getBoundKeyOrAssign(this.withParameters, this.withParameters ? object : object + "f");
            }
            if (object instanceof Integer) {
                return this.script.getBoundKeyOrAssign(this.withParameters, this.withParameters ? object : "(int) " + object);
            }
            if (object instanceof Class) {
                return this.script.append(((Class)object).getCanonicalName());
            }
            if (object instanceof Timestamp) {
                return this.script.getBoundKeyOrAssign(this.withParameters, this.withParameters ? object : "new java.sql.Timestamp(" + ((Timestamp)object).getTime() + ")");
            }
            if (object instanceof Date) {
                return this.script.getBoundKeyOrAssign(this.withParameters, this.withParameters ? object : "new java.util.Date(" + ((Date)object).getTime() + ")");
            }
            if (object instanceof UUID) {
                return this.script.getBoundKeyOrAssign(this.withParameters, this.withParameters ? object : "java.util.UUID.fromString('" + object.toString() + "')");
            }
            if (object instanceof P) {
                return this.convertPToScript((P)object);
            }
            if (object instanceof SackFunctions.Barrier) {
                return this.script.append("SackFunctions.Barrier." + object.toString());
            }
            if (object instanceof VertexProperty.Cardinality) {
                return this.script.append("VertexProperty.Cardinality." + object.toString());
            }
            if (object instanceof TraversalOptionParent.Pick) {
                return this.script.append("TraversalOptionParent.Pick." + object.toString());
            }
            if (object instanceof Enum) {
                return this.script.append(((Enum)object).getDeclaringClass().getSimpleName() + "." + object.toString());
            }
            if (object instanceof Element) {
                if (object instanceof Vertex) {
                    Vertex vertex = (Vertex)object;
                    this.script.append("new org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex(");
                    this.convertToScript(vertex.id());
                    this.script.append(",");
                    this.convertToScript(vertex.label());
                    return this.script.append(", Collections.emptyMap())");
                }
                if (object instanceof Edge) {
                    Edge edge = (Edge)object;
                    this.script.append("new org.apache.tinkerpop.gremlin.structure.util.detached.DetachedEdge(");
                    this.convertToScript(edge.id());
                    this.script.append(",");
                    this.convertToScript(edge.label());
                    this.script.append(",");
                    this.script.append("Collections.emptyMap(),");
                    this.convertToScript(edge.outVertex().id());
                    this.script.append(",");
                    this.convertToScript(edge.outVertex().label());
                    this.script.append(",");
                    this.convertToScript(edge.inVertex().id());
                    this.script.append(",");
                    this.convertToScript(edge.inVertex().label());
                    return this.script.append(")");
                }
                VertexProperty vertexProperty = (VertexProperty)object;
                this.script.append("new org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertexProperty(");
                this.convertToScript(vertexProperty.id());
                this.script.append(",");
                this.convertToScript(vertexProperty.label());
                this.script.append(",");
                this.convertToScript(vertexProperty.value());
                this.script.append(",");
                this.script.append("Collections.emptyMap(),");
                this.convertToScript(vertexProperty.element());
                return this.script.append(")");
            }
            if (object instanceof Lambda) {
                String lambdaString = ((Lambda)object).getLambdaScript().trim();
                String wrapper = lambdaString.startsWith("{") ? lambdaString : "{" + lambdaString + "}";
                return this.script.getBoundKeyOrAssign(this.withParameters, this.withParameters ? object : wrapper);
            }
            if (object instanceof TraversalStrategyProxy) {
                TraversalStrategyProxy proxy = (TraversalStrategyProxy)object;
                if (proxy.getConfiguration().isEmpty()) {
                    return this.script.append(proxy.getStrategyClass().getCanonicalName() + ".instance()");
                }
                this.script.append(proxy.getStrategyClass().getCanonicalName() + ".create(new org.apache.commons.configuration2.MapConfiguration(");
                this.convertToScript(ConfigurationConverter.getMap((Configuration)proxy.getConfiguration()));
                return this.script.append("))");
            }
            if (object instanceof TraversalStrategy) {
                return this.convertToScript(new TraversalStrategyProxy((TraversalStrategy)object));
            }
            return null == object ? this.script.append("null") : this.script.getBoundKeyOrAssign(this.withParameters, object);
        }

        protected Script internalTranslate(String start, Bytecode bytecode) {
            this.script.append(start);
            for (Bytecode.Instruction instruction : bytecode.getInstructions()) {
                String methodName = instruction.getOperator();
                if (0 == instruction.getArguments().length) {
                    this.script.append(".").append(methodName).append("()");
                    continue;
                }
                this.script.append(".").append(methodName).append("(");
                if (methodName.equals("withSack") && instruction.getArguments().length == 2 && instruction.getArguments()[1] instanceof Lambda) {
                    String castSecondArgTo;
                    String castFirstArgTo = instruction.getArguments()[0] instanceof Lambda ? Supplier.class.getName() : "";
                    Lambda secondArg = (Lambda)instruction.getArguments()[1];
                    String string = castSecondArgTo = secondArg.getLambdaArguments() == 1 ? UnaryOperator.class.getName() : BinaryOperator.class.getName();
                    if (!castFirstArgTo.isEmpty()) {
                        this.script.append(String.format("(%s) ", castFirstArgTo));
                    }
                    this.convertToScript(instruction.getArguments()[0]);
                    this.script.append(", (").append(castSecondArgTo).append(") ");
                    this.convertToScript(instruction.getArguments()[1]);
                    this.script.append(",");
                } else {
                    for (Object object : instruction.getArguments()) {
                        this.convertToScript(object);
                        this.script.append(",");
                    }
                }
                this.script.setCharAtEnd(')');
            }
            return this.script;
        }

        protected Script convertPToScript(P p) {
            if (p instanceof TextP) {
                return this.convertTextPToScript((TextP)p);
            }
            if (p instanceof ConnectiveP) {
                List list = ((ConnectiveP)p).getPredicates();
                for (int i = 0; i < list.size(); ++i) {
                    this.convertPToScript((P)list.get(i));
                    if (i >= list.size() - 1) continue;
                    this.script.append(p instanceof OrP ? ".or(" : ".and(");
                }
                this.script.append(")");
            } else {
                this.script.append("P.").append(p.getBiPredicate().toString()).append("(");
                this.convertToScript(p.getValue());
                this.script.append(")");
            }
            return this.script;
        }

        protected Script convertTextPToScript(TextP p) {
            this.script.append("TextP.").append(p.getBiPredicate().toString()).append("(");
            this.convertToScript(p.getValue());
            this.script.append(")");
            return this.script;
        }
    }
}

