/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.grpc;

import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.apache.hugegraph.rocksdb.access.ScanIterator;

final class FusingScanIterator
implements ScanIterator {
    public static final byte[] EMPTY_BYTES = new byte[0];
    private long max;
    private long accumulator;
    private Supplier<ScanIterator> supplier;
    private ScanIterator iterator;
    private byte[] position = EMPTY_BYTES;

    private FusingScanIterator() {
    }

    public static FusingScanIterator maxOf(long maxThreshold, Supplier<ScanIterator> iteratorSupplier) {
        FusingScanIterator res = new FusingScanIterator();
        res.max = maxThreshold;
        res.supplier = iteratorSupplier;
        return res;
    }

    private ScanIterator getIterator() {
        ScanIterator buf = (ScanIterator)this.supplier.get();
        if (buf == null) {
            return null;
        }
        if (!buf.hasNext()) {
            buf = null;
        }
        return buf;
    }

    private void init() {
        if (this.iterator == null) {
            this.iterator = this.getIterator();
        }
    }

    public boolean hasNext() {
        if (this.isThresholdExceeded()) {
            return false;
        }
        if (this.iterator == null) {
            this.iterator = this.getIterator();
        }
        return this.iterator != null;
    }

    public boolean isValid() {
        return this.hasNext();
    }

    public byte[] position() {
        return this.position;
    }

    private boolean isThresholdExceeded() {
        return this.accumulator >= this.max;
    }

    public <T> T next() {
        if (this.isThresholdExceeded()) {
            throw new NoSuchElementException();
        }
        this.init();
        if (this.iterator == null) {
            throw new NoSuchElementException();
        }
        Object t = this.iterator.next();
        this.position = this.iterator.position();
        ++this.accumulator;
        if (!this.iterator.hasNext() || this.isThresholdExceeded()) {
            this.iterator.close();
            this.iterator = null;
        }
        return (T)t;
    }

    public void close() {
        if (this.iterator != null) {
            this.iterator.close();
        }
    }
}

