/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.grpc;

import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.core.NodeMetrics;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.GeneratedMessageV3;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.hugegraph.store.HgStoreEngine;
import org.apache.hugegraph.store.business.DataMover;
import org.apache.hugegraph.store.business.DefaultDataMover;
import org.apache.hugegraph.store.grpc.common.GraphMethod;
import org.apache.hugegraph.store.grpc.session.BatchReq;
import org.apache.hugegraph.store.grpc.session.CleanReq;
import org.apache.hugegraph.store.grpc.session.GraphReq;
import org.apache.hugegraph.store.grpc.session.TableReq;
import org.apache.hugegraph.store.node.AppConfig;
import org.apache.hugegraph.store.node.grpc.HgStoreNodeService;
import org.apache.hugegraph.store.node.grpc.HgStoreSessionImpl;
import org.apache.hugegraph.store.options.HgStoreEngineOptions;
import org.apache.hugegraph.store.options.RaftRocksdbOptions;
import org.apache.hugegraph.store.raft.RaftClosure;
import org.apache.hugegraph.store.raft.RaftOperation;
import org.apache.hugegraph.store.raft.RaftTaskHandler;
import org.apache.hugegraph.store.util.HgRaftError;
import org.apache.hugegraph.store.util.HgStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HgStoreNodeService
implements RaftTaskHandler {
    private static final Logger log = LoggerFactory.getLogger(HgStoreNodeService.class);
    public static final byte BATCH_OP = 18;
    public static final byte TABLE_OP = 19;
    public static final byte GRAPH_OP = 20;
    public static final byte CLEAN_OP = 21;
    public static final byte MAX_OP = 89;
    private final AppConfig appConfig;
    @Autowired
    HgStoreSessionImpl hgStoreSession;
    private HgStoreEngine storeEngine;

    public HgStoreNodeService(@Autowired AppConfig appConfig) {
        this.appConfig = appConfig;
    }

    public HgStoreEngine getStoreEngine() {
        return this.storeEngine;
    }

    @PostConstruct
    public void init() {
        log.info("{}", (Object)this.appConfig.toString());
        1 options = new /* Unavailable Anonymous Inner Class!! */;
        RaftRocksdbOptions.initRocksdbGlobalConfig((Map)options.getRocksdbConfig());
        options.getLabels().put("rest.port", Integer.toString(this.appConfig.getRestPort()));
        log.info("HgStoreEngine init {}", (Object)options);
        options.setTaskHandler((RaftTaskHandler)this);
        options.setDataTransfer((DataMover)new DefaultDataMover());
        this.storeEngine = HgStoreEngine.getInstance();
        this.storeEngine.init((HgStoreEngineOptions)options);
    }

    public List<Integer> getGraphLeaderPartitionIds(String graphName) {
        return this.storeEngine.getPartitionManager().getLeaderPartitionIds(graphName);
    }

    public <Req extends GeneratedMessageV3> void addRaftTask(byte methodId, String graphName, Integer partitionId, Req req, RaftClosure closure) {
        if (!this.storeEngine.isClusterReady()) {
            closure.run(new Status(HgRaftError.CLUSTER_NOT_READY.getNumber(), "The cluster is not ready, please check active stores number!"));
            log.error("The cluster is not ready, please check active stores number!");
            return;
        }
        try {
            byte[] buffer = new byte[req.getSerializedSize() + 1];
            CodedOutputStream output = CodedOutputStream.newInstance((byte[])buffer);
            output.write(methodId);
            req.writeTo(output);
            output.checkNoSpaceLeft();
            output.flush();
            this.storeEngine.addRaftTask(graphName, partitionId, RaftOperation.create((byte)methodId, (byte[])buffer, req), closure);
        }
        catch (Exception e) {
            closure.run(new Status(HgRaftError.UNKNOWN.getNumber(), e.getMessage()));
            log.error("addRaftTask {}", (Throwable)e);
        }
    }

    public boolean invoke(int partId, byte[] request, RaftClosure response) throws HgStoreException {
        try {
            CodedInputStream input = CodedInputStream.newInstance((byte[])request);
            byte methodId = input.readRawByte();
            switch (methodId) {
                case 18: {
                    this.invoke(partId, methodId, (Object)BatchReq.parseFrom((CodedInputStream)input), response);
                    break;
                }
                case 19: {
                    this.invoke(partId, methodId, (Object)TableReq.parseFrom((CodedInputStream)input), response);
                    break;
                }
                case 20: {
                    this.invoke(partId, methodId, (Object)GraphReq.parseFrom((CodedInputStream)input), response);
                    break;
                }
                case 21: {
                    this.invoke(partId, methodId, (Object)CleanReq.parseFrom((CodedInputStream)input), response);
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        catch (IOException e) {
            throw new HgStoreException(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public boolean invoke(int partId, byte methodId, Object req, RaftClosure response) throws HgStoreException {
        switch (methodId) {
            case 18: {
                this.hgStoreSession.doBatch(partId, (BatchReq)req, response);
                break;
            }
            case 19: {
                this.hgStoreSession.doTable(partId, (TableReq)req, response);
                break;
            }
            case 20: {
                if (((GraphReq)req).getMethod() == GraphMethod.GRAPH_METHOD_DELETE) {
                    this.storeEngine.deletePartition(Integer.valueOf(partId), ((GraphReq)req).getGraphName());
                }
                this.hgStoreSession.doGraph(partId, (GraphReq)req, response);
                break;
            }
            case 21: {
                this.hgStoreSession.doClean(partId, (CleanReq)req, response);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @PreDestroy
    public void destroy() {
        this.storeEngine.shutdown();
    }

    private String getSerializingExceptionMessage(String target) {
        return "Serializing " + this.getClass().getName() + " to a " + target + " threw an IOException (should never happen).";
    }

    public Map<String, NodeMetrics> getNodeMetrics() {
        return this.storeEngine.getNodeMetrics();
    }
}

