/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.grpc;

import io.grpc.stub.StreamObserver;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.hugegraph.store.grpc.state.ScanState;
import org.apache.hugegraph.store.grpc.stream.HgStoreStreamGrpc;
import org.apache.hugegraph.store.grpc.stream.KvPageRes;
import org.apache.hugegraph.store.grpc.stream.KvStream;
import org.apache.hugegraph.store.grpc.stream.ScanStreamBatchReq;
import org.apache.hugegraph.store.grpc.stream.ScanStreamReq;
import org.apache.hugegraph.store.node.AppConfig;
import org.apache.hugegraph.store.node.grpc.HgStoreNodeService;
import org.apache.hugegraph.store.node.grpc.HgStoreWrapperEx;
import org.apache.hugegraph.store.node.grpc.ScanBatchOneShotResponse;
import org.apache.hugegraph.store.node.grpc.ScanBatchResponse3;
import org.apache.hugegraph.store.node.grpc.ScanBatchResponseFactory;
import org.apache.hugegraph.store.node.grpc.ScanOneShotResponse;
import org.apache.hugegraph.store.node.grpc.ScanStreamResponse;
import org.apache.hugegraph.store.node.util.HgExecutorUtil;
import org.lognet.springboot.grpc.GRpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@GRpcService
public class HgStoreStreamImpl
extends HgStoreStreamGrpc.HgStoreStreamImplBase {
    private static final Logger log = LoggerFactory.getLogger(HgStoreStreamImpl.class);
    @Autowired
    private HgStoreNodeService storeService;
    @Autowired
    private AppConfig appConfig;
    private HgStoreWrapperEx wrapper;
    private ThreadPoolExecutor executor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HgStoreWrapperEx getWrapper() {
        if (this.wrapper == null) {
            HgStoreStreamImpl hgStoreStreamImpl = this;
            synchronized (hgStoreStreamImpl) {
                if (this.wrapper == null) {
                    this.wrapper = new HgStoreWrapperEx(this.storeService.getStoreEngine().getBusinessHandler());
                }
            }
        }
        return this.wrapper;
    }

    public ThreadPoolExecutor getRealExecutor() {
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPoolExecutor getExecutor() {
        if (this.executor == null) {
            HgStoreStreamImpl hgStoreStreamImpl = this;
            synchronized (hgStoreStreamImpl) {
                if (this.executor == null) {
                    AppConfig.ThreadPoolScan scan = this.appConfig.getThreadPoolScan();
                    this.executor = HgExecutorUtil.createExecutor((String)"hg-scan", (int)scan.getCore(), (int)scan.getMax(), (int)scan.getQueue());
                }
            }
        }
        return this.executor;
    }

    public ScanState getState() {
        ThreadPoolExecutor ex = this.getExecutor();
        ScanState.Builder builder = ScanState.newBuilder();
        BlockingQueue<Runnable> queue = ex.getQueue();
        ScanState state = builder.setActiveCount(ex.getActiveCount()).setTaskCount(ex.getTaskCount()).setCompletedTaskCount(ex.getCompletedTaskCount()).setMaximumPoolSize(ex.getMaximumPoolSize()).setLargestPoolSize(ex.getLargestPoolSize()).setPoolSize(ex.getPoolSize()).setAddress(this.appConfig.getStoreServerAddress()).setQueueSize(queue.size()).setQueueRemainingCapacity(queue.remainingCapacity()).build();
        return state;
    }

    public StreamObserver<ScanStreamReq> scan(StreamObserver<KvPageRes> response) {
        return ScanStreamResponse.of(response, (HgStoreWrapperEx)this.getWrapper(), (ThreadPoolExecutor)this.getExecutor(), (AppConfig)this.appConfig);
    }

    public void scanOneShot(ScanStreamReq request, StreamObserver<KvPageRes> response) {
        ScanOneShotResponse.scanOneShot((ScanStreamReq)request, response, (HgStoreWrapperEx)this.getWrapper());
    }

    public StreamObserver<ScanStreamBatchReq> scanBatch(StreamObserver<KvPageRes> response) {
        return ScanBatchResponse3.of(response, (HgStoreWrapperEx)this.getWrapper(), (ThreadPoolExecutor)this.getExecutor());
    }

    public StreamObserver<ScanStreamBatchReq> scanBatch2(StreamObserver<KvStream> response) {
        return ScanBatchResponseFactory.of(response, (HgStoreWrapperEx)this.getWrapper(), (ThreadPoolExecutor)this.getExecutor());
    }

    public void scanBatchOneShot(ScanStreamBatchReq request, StreamObserver<KvPageRes> response) {
        ScanBatchOneShotResponse.scanOneShot((ScanStreamBatchReq)request, response, (HgStoreWrapperEx)this.getWrapper());
    }
}

