/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.metrics;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hugegraph.store.node.metrics.ProcFileHandler;
import org.apache.hugegraph.store.node.metrics.ProcfsRecord;
import org.apache.hugegraph.store.node.metrics.SystemMemoryStats;

/*
 * Exception performing whole class analysis ignored.
 */
public class SystemMemoryStats
extends ProcfsRecord {
    private static final int KB = 1024;
    private final Map<MetricKey, AtomicLong> metrics = new HashMap();

    public SystemMemoryStats() {
        super(ProcFileHandler.getInstance((String)"smaps"));
    }

    SystemMemoryStats(ProcFileHandler reader) {
        super(reader);
    }

    private static long parseKilobytes(String line) {
        Objects.requireNonNull(line);
        return Long.parseLong(line.split("\\s+")[1]);
    }

    protected void clear() {
        EnumSet.allOf(MetricKey.class).forEach(key -> this.metrics.put(key, new AtomicLong(-1L)));
    }

    protected void process(Collection<String> lines) {
        Objects.requireNonNull(lines);
        for (String line : lines) {
            if (line.startsWith("Size:")) {
                this.increment(MetricKey.VSS, SystemMemoryStats.parseKilobytes((String)line) * 1024L);
                continue;
            }
            if (line.startsWith("Rss:")) {
                this.increment(MetricKey.RSS, SystemMemoryStats.parseKilobytes((String)line) * 1024L);
                continue;
            }
            if (line.startsWith("Pss:")) {
                this.increment(MetricKey.PSS, SystemMemoryStats.parseKilobytes((String)line) * 1024L);
                continue;
            }
            if (line.startsWith("Swap:")) {
                this.increment(MetricKey.SWAP, SystemMemoryStats.parseKilobytes((String)line) * 1024L);
                continue;
            }
            if (!line.startsWith("SwapPss:")) continue;
            this.increment(MetricKey.SWAPPSS, SystemMemoryStats.parseKilobytes((String)line) * 1024L);
        }
    }

    public Long getMetric(MetricKey key) {
        Objects.requireNonNull(key);
        this.clear();
        return ((AtomicLong)this.metrics.get(key)).longValue();
    }

    private void increment(MetricKey key, long increment) {
        Objects.requireNonNull(key);
        ((AtomicLong)this.metrics.get(key)).getAndUpdate(currentValue -> currentValue + increment + (long)(currentValue == -1L ? 1 : 0));
    }
}

