/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.util;

import java.security.AccessController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class PropertyUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyUtil.class);

    public static String get(String key) {
        return PropertyUtil.get((String)key, null);
    }

    public static String get(String key, String def) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("key must not be empty.");
        }
        String value = null;
        try {
            value = System.getSecurityManager() == null ? System.getProperty(key) : AccessController.doPrivileged(() -> System.getProperty(key));
        }
        catch (Exception e) {
            LOG.error("exception {}", (Throwable)e);
        }
        if (value == null) {
            return def;
        }
        return value;
    }

    public static boolean getBoolean(String key, boolean def) {
        String value = PropertyUtil.get((String)key, (String)Boolean.toString(def));
        if ((value = value.trim().toLowerCase()).isEmpty()) {
            return true;
        }
        if ("true".equals(value) || "yes".equals(value) || "1".equals(value)) {
            return true;
        }
        if ("false".equals(value) || "no".equals(value) || "0".equals(value)) {
            return false;
        }
        return def;
    }

    public static int getInt(String key, int def) {
        String value = PropertyUtil.get((String)key);
        if (value == null) {
            return def;
        }
        value = value.trim().toLowerCase();
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            LOG.warn("exception ", (Throwable)e);
            return def;
        }
    }

    public static Object setProperty(String key, String value) {
        return System.getProperties().setProperty(key, value);
    }
}

