/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.rsc.rpc;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.ScheduledFuture;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.livy.rsc.RSCConf;
import org.apache.livy.rsc.Utils;
import org.apache.livy.rsc.rpc.KryoMessageCodec;
import org.apache.livy.rsc.rpc.RpcDispatcher;
import org.apache.livy.rsc.rpc.SaslHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rpc
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Rpc.class);
    static final String SASL_REALM = "rsc";
    static final String SASL_USER = "rsc";
    static final String SASL_PROTOCOL = "rsc";
    static final String SASL_AUTH_CONF = "auth-conf";
    private final RSCConf config;
    private final AtomicBoolean rpcClosed;
    private final AtomicLong rpcId;
    private final Channel channel;
    private final EventExecutorGroup egroup;
    private volatile RpcDispatcher dispatcher;

    public static Promise<Rpc> createClient(final RSCConf config, final EventLoopGroup eloop, String host, int port, final String clientId, final String secret, final RpcDispatcher dispatcher) throws Exception {
        int connectTimeoutMs = (int)config.getTimeAsMs(RSCConf.Entry.RPC_CLIENT_CONNECT_TIMEOUT);
        final ChannelFuture cf = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eloop)).handler((ChannelHandler)new ChannelInboundHandlerAdapter(){})).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectTimeoutMs)).connect(host, port);
        final Promise promise = eloop.next().newPromise();
        AtomicReference rpc = new AtomicReference();
        Runnable timeoutTask = new Runnable(){

            @Override
            public void run() {
                promise.setFailure((Throwable)new TimeoutException("Timed out waiting for RPC server connection."));
            }
        };
        final ScheduledFuture timeoutFuture = eloop.schedule(timeoutTask, config.getTimeAsMs(RSCConf.Entry.RPC_CLIENT_HANDSHAKE_TIMEOUT), TimeUnit.MILLISECONDS);
        cf.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture cf) throws Exception {
                if (cf.isSuccess()) {
                    SaslClientHandler saslHandler = new SaslClientHandler(config, clientId, (Promise<Rpc>)promise, timeoutFuture, secret, dispatcher);
                    Rpc rpc = Rpc.createRpc(config, saslHandler, (SocketChannel)cf.channel(), (EventExecutorGroup)eloop);
                    saslHandler.rpc = rpc;
                    saslHandler.sendHello(cf.channel());
                } else {
                    promise.setFailure(cf.cause());
                }
            }
        });
        promise.addListener((GenericFutureListener)new GenericFutureListener<Promise<Rpc>>(){

            public void operationComplete(Promise<Rpc> p) {
                if (p.isCancelled()) {
                    cf.cancel(true);
                }
            }
        });
        return promise;
    }

    static Rpc createServer(SaslHandler saslHandler, RSCConf config, SocketChannel channel, EventExecutorGroup egroup) throws IOException {
        return Rpc.createRpc(config, saslHandler, channel, egroup);
    }

    private static Rpc createRpc(RSCConf config, SaslHandler saslHandler, SocketChannel client, EventExecutorGroup egroup) throws IOException {
        LogLevel logLevel = LogLevel.TRACE;
        String logLevelStr = config.get(RSCConf.Entry.RPC_CHANNEL_LOG_LEVEL);
        if (logLevelStr != null) {
            try {
                logLevel = LogLevel.valueOf((String)logLevelStr);
            }
            catch (Exception e) {
                LOG.warn("Invalid log level {}, reverting to default.", (Object)logLevelStr);
            }
        }
        boolean logEnabled = false;
        switch (logLevel) {
            case DEBUG: {
                logEnabled = LOG.isDebugEnabled();
                break;
            }
            case ERROR: {
                logEnabled = LOG.isErrorEnabled();
                break;
            }
            case INFO: {
                logEnabled = LOG.isInfoEnabled();
                break;
            }
            case TRACE: {
                logEnabled = LOG.isTraceEnabled();
                break;
            }
            case WARN: {
                logEnabled = LOG.isWarnEnabled();
            }
        }
        if (logEnabled) {
            client.pipeline().addLast("logger", (ChannelHandler)new LoggingHandler(Rpc.class, logLevel));
        }
        KryoMessageCodec kryo = new KryoMessageCodec(config.getInt(RSCConf.Entry.RPC_MAX_MESSAGE_SIZE), MessageHeader.class, NullMessage.class, SaslMessage.class);
        saslHandler.setKryoMessageCodec(kryo);
        client.pipeline().addLast("codec", (ChannelHandler)kryo).addLast("sasl", (ChannelHandler)saslHandler);
        return new Rpc(config, (Channel)client, egroup);
    }

    static Rpc createEmbedded(RpcDispatcher dispatcher) {
        EmbeddedChannel c = new EmbeddedChannel(new ChannelHandler[]{new LoggingHandler(Rpc.class), new KryoMessageCodec(0, MessageHeader.class, NullMessage.class), dispatcher});
        Rpc rpc = new Rpc(new RSCConf(null), (Channel)c, (EventExecutorGroup)ImmediateEventExecutor.INSTANCE);
        rpc.dispatcher = dispatcher;
        return rpc;
    }

    private Rpc(RSCConf config, Channel channel, EventExecutorGroup egroup) {
        Utils.checkArgument(channel != null);
        Utils.checkArgument(egroup != null);
        this.config = config;
        this.channel = channel;
        this.dispatcher = null;
        this.egroup = egroup;
        this.rpcClosed = new AtomicBoolean();
        this.rpcId = new AtomicLong();
        channel.pipeline().addLast("monitor", (ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                Rpc.this.close();
                super.channelInactive(ctx);
            }
        });
    }

    public Future<Void> call(Object msg) {
        return this.call(msg, Void.class);
    }

    public <T> Future<T> call(final Object msg, Class<T> retType) {
        Utils.checkArgument(msg != null);
        Utils.checkState(this.channel.isOpen(), "RPC channel is closed.", new Object[0]);
        try {
            final long id = this.rpcId.getAndIncrement();
            final Promise promise = this.egroup.next().newPromise();
            final ChannelFutureListener listener = new ChannelFutureListener(){

                public void operationComplete(ChannelFuture cf) {
                    if (!cf.isSuccess() && !promise.isDone()) {
                        LOG.warn("Failed to send RPC, closing connection.", cf.cause());
                        promise.setFailure(cf.cause());
                        Rpc.this.dispatcher.discardRpc(id);
                        Rpc.this.close();
                    }
                }
            };
            this.dispatcher.registerRpc(id, promise, msg.getClass().getName());
            this.channel.eventLoop().submit(new Runnable(){

                @Override
                public void run() {
                    Rpc.this.channel.write((Object)new MessageHeader(id, MessageType.CALL)).addListener((GenericFutureListener)listener);
                    Rpc.this.channel.writeAndFlush(msg).addListener((GenericFutureListener)listener);
                }
            });
            return promise;
        }
        catch (Exception e) {
            throw Utils.propagate(e);
        }
    }

    public Channel getChannel() {
        return this.channel;
    }

    void setDispatcher(RpcDispatcher dispatcher) {
        Utils.checkNotNull((Object)dispatcher);
        Utils.checkState(this.dispatcher == null, "Dispatcher already set.", new Object[0]);
        this.dispatcher = dispatcher;
        this.channel.pipeline().addLast("dispatcher", (ChannelHandler)dispatcher);
    }

    @Override
    public void close() {
        if (!this.rpcClosed.compareAndSet(false, true)) {
            return;
        }
        try {
            this.channel.close().sync();
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
        }
    }

    private static class SaslClientHandler
    extends SaslHandler
    implements CallbackHandler {
        private final SaslClient client;
        private final String clientId;
        private final String secret;
        private final RpcDispatcher dispatcher;
        private Promise<Rpc> promise;
        private ScheduledFuture<?> timeout;
        private Rpc rpc;

        SaslClientHandler(RSCConf config, String clientId, Promise<Rpc> promise, ScheduledFuture<?> timeout, String secret, RpcDispatcher dispatcher) throws IOException {
            super(config);
            this.clientId = clientId;
            this.promise = promise;
            this.timeout = timeout;
            this.secret = secret;
            this.dispatcher = dispatcher;
            this.client = Sasl.createSaslClient(new String[]{config.get(RSCConf.Entry.SASL_MECHANISMS)}, null, "rsc", "rsc", config.getSaslOptions(), this);
        }

        @Override
        protected boolean isComplete() {
            return this.client.isComplete();
        }

        @Override
        protected String getNegotiatedProperty(String name) {
            return (String)this.client.getNegotiatedProperty(name);
        }

        @Override
        protected SaslMessage update(SaslMessage challenge) throws IOException {
            byte[] response = this.client.evaluateChallenge(challenge.payload);
            return response != null ? new SaslMessage(response) : null;
        }

        @Override
        public byte[] wrap(byte[] data, int offset, int len) throws IOException {
            return this.client.wrap(data, offset, len);
        }

        @Override
        public byte[] unwrap(byte[] data, int offset, int len) throws IOException {
            return this.client.unwrap(data, offset, len);
        }

        @Override
        public void dispose() throws IOException {
            if (!this.client.isComplete()) {
                this.onError(new SaslException("Client closed before SASL negotiation finished."));
            }
            this.client.dispose();
        }

        @Override
        protected void onComplete() throws Exception {
            this.timeout.cancel(true);
            this.rpc.setDispatcher(this.dispatcher);
            this.promise.setSuccess((Object)this.rpc);
            this.timeout = null;
            this.promise = null;
        }

        @Override
        protected void onError(Throwable error) {
            this.timeout.cancel(true);
            if (!this.promise.isDone()) {
                this.promise.setFailure(error);
            }
        }

        @Override
        public void handle(Callback[] callbacks) {
            for (Callback cb : callbacks) {
                if (cb instanceof NameCallback) {
                    ((NameCallback)cb).setName(this.clientId);
                    continue;
                }
                if (cb instanceof PasswordCallback) {
                    ((PasswordCallback)cb).setPassword(this.secret.toCharArray());
                    continue;
                }
                if (!(cb instanceof RealmCallback)) continue;
                RealmCallback rb = (RealmCallback)cb;
                rb.setText(rb.getDefaultText());
            }
        }

        void sendHello(Channel c) throws Exception {
            byte[] hello = this.client.hasInitialResponse() ? this.client.evaluateChallenge(new byte[0]) : new byte[]{};
            c.writeAndFlush((Object)new SaslMessage(this.clientId, hello)).sync();
        }
    }

    static class SaslMessage {
        final String clientId;
        final byte[] payload;

        SaslMessage() {
            this(null, null);
        }

        SaslMessage(byte[] payload) {
            this(null, payload);
        }

        SaslMessage(String clientId, byte[] payload) {
            this.clientId = clientId;
            this.payload = payload;
        }
    }

    static class NullMessage {
        NullMessage() {
        }
    }

    static class MessageHeader {
        final long id;
        final MessageType type;

        MessageHeader() {
            this(-1L, null);
        }

        MessageHeader(long id, MessageType type) {
            this.id = id;
            this.type = type;
        }
    }

    static enum MessageType {
        CALL,
        REPLY,
        ERROR;

    }
}

