/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.config;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.persistence.MetaStoreManagerFactory;
import org.apache.polaris.core.persistence.PolarisEntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class RealmEntityManagerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(RealmEntityManagerFactory.class);
    private final MetaStoreManagerFactory metaStoreManagerFactory;
    private final Map<String, PolarisEntityManager> cachedEntityManagers = new ConcurrentHashMap<String, PolarisEntityManager>();

    @Inject
    public RealmEntityManagerFactory(MetaStoreManagerFactory metaStoreManagerFactory) {
        this.metaStoreManagerFactory = metaStoreManagerFactory;
    }

    public PolarisEntityManager getOrCreateEntityManager(RealmContext context) {
        String realm = context.getRealmIdentifier();
        LOGGER.debug("Looking up PolarisEntityManager for realm {}", (Object)realm);
        return this.cachedEntityManagers.computeIfAbsent(realm, r -> {
            LOGGER.info("Initializing new PolarisEntityManager for realm {}", r);
            return new PolarisEntityManager(this.metaStoreManagerFactory.getOrCreateMetaStoreManager(context), this.metaStoreManagerFactory.getOrCreateStorageCredentialCache(context), this.metaStoreManagerFactory.getOrCreateEntityCache(context));
        });
    }
}

