/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.processors.UnicastProcessor;
import io.smallrye.mutiny.subscription.ContextSupport;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import io.smallrye.mutiny.subscription.SerializedSubscriber;
import io.smallrye.mutiny.subscription.SwitchableSubscriptionSubscriber;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;

public final class MultiRetryWhenOp<T>
extends AbstractMultiOperator<T, T> {
    private final Function<? super Multi<Throwable>, ? extends Flow.Publisher<?>> triggerStreamFactory;
    private final Predicate<? super Throwable> onFailurePredicate;

    public MultiRetryWhenOp(Multi<? extends T> upstream, Predicate<? super Throwable> onFailurePredicate, Function<? super Multi<Throwable>, ? extends Flow.Publisher<?>> triggerStreamFactory) {
        super(upstream);
        this.onFailurePredicate = onFailurePredicate;
        this.triggerStreamFactory = triggerStreamFactory;
    }

    private static <T> void subscribe(MultiSubscriber<? super T> downstream, Predicate<? super Throwable> onFailurePredicate, Function<? super Multi<Throwable>, ? extends Flow.Publisher<?>> triggerStreamFactory, Multi<? extends T> upstream) {
        Flow.Publisher<?> publisher;
        TriggerSubscriber other = new TriggerSubscriber();
        SerializedSubscriber<Throwable> signaller = new SerializedSubscriber<Throwable>(other.processor);
        signaller.onSubscribe(Subscriptions.empty());
        SerializedSubscriber<T> serialized = new SerializedSubscriber<T>(downstream);
        RetryWhenOperator<T> operator = new RetryWhenOperator<T>(upstream, onFailurePredicate, serialized, signaller);
        other.operator = operator;
        serialized.onSubscribe(operator);
        try {
            publisher = triggerStreamFactory.apply(other);
            if (publisher == null) {
                throw new NullPointerException("The stream factory returned `null`");
            }
        }
        catch (Throwable e) {
            downstream.onFailure(e);
            return;
        }
        publisher.subscribe(other);
        if (!operator.isCancelled()) {
            upstream.subscribe(operator);
        }
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        MultiRetryWhenOp.subscribe(downstream, this.onFailurePredicate, this.triggerStreamFactory, this.upstream);
    }

    static final class TriggerSubscriber
    extends AbstractMulti<Throwable>
    implements Multi<Throwable>,
    Flow.Subscriber<Object>,
    ContextSupport {
        RetryWhenOperator<?> operator;
        private final Flow.Processor<Throwable, Throwable> processor = UnicastProcessor.create().serialized();
        private Context context;

        TriggerSubscriber() {
        }

        @Override
        public void onSubscribe(Flow.Subscription s) {
            this.operator.setWhen(s);
        }

        @Override
        public void onNext(Object t) {
            this.operator.resubscribe();
        }

        @Override
        public void onError(Throwable t) {
            this.operator.whenFailure(t);
        }

        @Override
        public void onComplete() {
            this.operator.whenComplete();
        }

        @Override
        public void subscribe(Flow.Subscriber<? super Throwable> actual) {
            this.context = actual instanceof ContextSupport ? ((ContextSupport)((Object)actual)).context() : Context.empty();
            this.processor.subscribe(actual);
        }

        @Override
        public Context context() {
            return this.context;
        }
    }

    static final class RetryWhenOperator<T>
    extends SwitchableSubscriptionSubscriber<T> {
        private final Flow.Publisher<? extends T> upstream;
        private final AtomicInteger wip = new AtomicInteger();
        private final Flow.Subscriber<Throwable> signaller;
        private final Subscriptions.DeferredSubscription arbiter = new Subscriptions.DeferredSubscription();
        private final Predicate<? super Throwable> onFailurePredicate;
        long produced;

        RetryWhenOperator(Flow.Publisher<? extends T> upstream, Predicate<? super Throwable> onFailurePredicate, MultiSubscriber<? super T> downstream, Flow.Subscriber<Throwable> signaller) {
            super(downstream);
            this.onFailurePredicate = onFailurePredicate;
            this.upstream = upstream;
            this.signaller = signaller;
        }

        @Override
        public void cancel() {
            if (!this.isCancelled()) {
                this.arbiter.cancel();
                super.cancel();
            }
        }

        public void setWhen(Flow.Subscription w) {
            this.arbiter.set(w);
        }

        @Override
        public void onItem(T t) {
            this.downstream.onItem(t);
            ++this.produced;
        }

        @Override
        public void onFailure(Throwable t) {
            if (this.testOnFailurePredicate(t)) {
                return;
            }
            long p = this.produced;
            if (p != 0L) {
                this.produced = 0L;
                this.emitted(p);
            }
            this.arbiter.request(1L);
            this.signaller.onNext(t);
        }

        private boolean testOnFailurePredicate(Throwable t) {
            try {
                if (!this.onFailurePredicate.test(t)) {
                    this.arbiter.cancel();
                    this.downstream.onFailure(t);
                }
            }
            catch (Throwable e) {
                this.arbiter.cancel();
                this.downstream.onFailure(new CompositeException(e, t));
                return true;
            }
            return false;
        }

        @Override
        public void onCompletion() {
            this.arbiter.cancel();
            this.downstream.onComplete();
        }

        void resubscribe() {
            if (this.wip.getAndIncrement() == 0) {
                do {
                    if (this.isCancelled()) {
                        return;
                    }
                    this.upstream.subscribe(this);
                } while (this.wip.decrementAndGet() != 0);
            }
        }

        void whenFailure(Throwable failure) {
            super.cancel();
            this.downstream.onFailure(failure);
        }

        void whenComplete() {
            super.cancel();
            this.downstream.onComplete();
        }
    }
}

