/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Locale;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;

public class FileStorageConfigurationInfo
extends PolarisStorageConfigurationInfo {
    public FileStorageConfigurationInfo(@JsonProperty(value="allowedLocations", required=true) @Nonnull List<String> allowedLocations) {
        super(PolarisStorageConfigurationInfo.StorageType.FILE, allowedLocations);
    }

    @Override
    public String getFileIoImplClassName() {
        return "org.apache.iceberg.hadoop.HadoopFileIO";
    }

    @Override
    public void validatePrefixForStorageType(String loc) {
        if (this.getStorageType().getPrefixes().stream().noneMatch(p -> loc.toLowerCase(Locale.ROOT).startsWith((String)p)) && !loc.startsWith("file:/") && !loc.startsWith("/") && !loc.equals("*")) {
            throw new IllegalArgumentException(String.format("Location prefix not allowed: '%s', expected prefix: file:// or / or *", loc));
        }
    }
}

