/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.TaskManifest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestCommitterSupport;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.AbstractJobOrTaskStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.StageConfig;
import org.apache.hadoop.shaded.org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveTaskManifestStage
extends AbstractJobOrTaskStage<Supplier<TaskManifest>, Pair<Path, TaskManifest>> {
    private static final Logger LOG = LoggerFactory.getLogger(SaveTaskManifestStage.class);

    public SaveTaskManifestStage(StageConfig stageConfig) {
        super(true, stageConfig, "task_stage_save_manifest", false);
    }

    @Override
    protected Pair<Path, TaskManifest> executeStage(Supplier<TaskManifest> manifestSource) throws IOException {
        Path manifestDir = this.getTaskManifestDir();
        Path manifestFile = ManifestCommitterSupport.manifestPathForTask(manifestDir, this.getRequiredTaskId());
        Path manifestTempFile = ManifestCommitterSupport.manifestTempPathForTaskAttempt(manifestDir, this.getRequiredTaskAttemptId());
        LOG.info("{}: Saving manifest file to {}", (Object)this.getName(), (Object)manifestFile);
        TaskManifest manifest = this.saveManifest(manifestSource, manifestTempFile, manifestFile, "task_stage_save_task_manifest");
        return Pair.of((Object)manifestFile, (Object)manifest);
    }
}

