---
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
linkTitle: Community Guidelines
type: docs
weight: 500
---

# Community Guidelines

We value and appreciate the diverse contributions and ideas from the community. To maintain a welcoming and inclusive environment, we kindly ask you to adhere to the following guidelines:

* Be respectful and considerate of other community members. Treat everyone with respect and professionalism.
* Refrain from engaging in offensive, discriminatory, or harassing behavior.
* Be patient and understanding towards others, especially newcomers who may be learning.
* Stay constructive and provide helpful feedback.
* Engage in meaningful and relevant discussions related to the project.
* Avoid spamming, excessive self-promotion, or advertising unrelated content.
* Use clear and consise language to facilitate effective communication.

You can also take a look on the [Code of Conduct](https://github.com/apache/polaris/blob/main/CODE_OF_CONDUCT.md), and the ASF [Code of Conduct](https://www.apache.org/foundation/policies/conduct.html).

The Polaris community is built on the principles described in the [Apache Way](https://www.apache.org/theapacheway/index.html).
