/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.closure;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.closure.ClosureQueue;
import com.alipay.sofa.jraft.closure.TaskClosure;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.util.OnlyForTest;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.ThreadPoolsFactory;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClosureQueueImpl
implements ClosureQueue {
    private static final Logger LOG = LoggerFactory.getLogger(ClosureQueueImpl.class);
    private String groupId;
    private final Lock lock = new ReentrantLock();
    private long firstIndex = 0L;
    private LinkedList<Closure> queue = new LinkedList();

    @OnlyForTest
    public long getFirstIndex() {
        return this.firstIndex;
    }

    @OnlyForTest
    public LinkedList<Closure> getQueue() {
        return this.queue;
    }

    public ClosureQueueImpl() {
    }

    public ClosureQueueImpl(String groupId) {
        this();
        this.groupId = groupId;
    }

    @Override
    public void clear() {
        LinkedList<Closure> savedQueue;
        this.lock.lock();
        try {
            this.firstIndex = 0L;
            savedQueue = this.queue;
            this.queue = new LinkedList();
        }
        finally {
            this.lock.unlock();
        }
        Status status = new Status(RaftError.EPERM, "Leader stepped down", new Object[0]);
        ThreadPoolsFactory.runInThread(this.groupId, () -> {
            for (Closure done : savedQueue) {
                if (done == null) continue;
                done.run(status);
            }
        });
    }

    @Override
    public void resetFirstIndex(long firstIndex) {
        this.lock.lock();
        try {
            Requires.requireTrue(this.queue.isEmpty(), "Queue is not empty.");
            this.firstIndex = firstIndex;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void appendPendingClosure(Closure closure) {
        this.lock.lock();
        try {
            this.queue.add(closure);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long popClosureUntil(long endIndex, List<Closure> closures) {
        return this.popClosureUntil(endIndex, closures, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long popClosureUntil(long endIndex, List<Closure> closures, List<TaskClosure> taskClosures) {
        closures.clear();
        if (taskClosures != null) {
            taskClosures.clear();
        }
        this.lock.lock();
        try {
            long outFirstIndex;
            int queueSize = this.queue.size();
            if (queueSize == 0 || endIndex < this.firstIndex) {
                long l = endIndex + 1L;
                return l;
            }
            if (endIndex > this.firstIndex + (long)queueSize - 1L) {
                LOG.error("Invalid endIndex={}, firstIndex={}, closureQueueSize={}", new Object[]{endIndex, this.firstIndex, queueSize});
                long l = -1L;
                return l;
            }
            for (long i = outFirstIndex = this.firstIndex; i <= endIndex; ++i) {
                Closure closure = this.queue.pollFirst();
                if (taskClosures != null && closure instanceof TaskClosure) {
                    taskClosures.add((TaskClosure)closure);
                }
                closures.add(closure);
            }
            this.firstIndex = endIndex + 1L;
            long l = outFirstIndex;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }
}

