/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe.internal;

import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.internal.CircuitBreakerInternals;
import net.jodah.failsafe.internal.CircuitState;
import net.jodah.failsafe.internal.util.CircularBitSet;
import net.jodah.failsafe.util.Ratio;

public class ClosedState
extends CircuitState {
    private final CircuitBreaker breaker;
    private final CircuitBreakerInternals internals;

    public ClosedState(CircuitBreaker breaker, CircuitBreakerInternals internals) {
        this.breaker = breaker;
        this.internals = internals;
        this.setFailureThreshold(breaker.getFailureThreshold() != null ? breaker.getFailureThreshold() : ONE_OF_ONE);
    }

    @Override
    public boolean allowsExecution() {
        return true;
    }

    @Override
    public CircuitBreaker.State getInternals() {
        return CircuitBreaker.State.CLOSED;
    }

    @Override
    public synchronized void recordFailure(ExecutionContext context) {
        this.bitSet.setNext(false);
        this.checkThreshold(context);
    }

    @Override
    public synchronized void recordSuccess() {
        this.bitSet.setNext(true);
        this.checkThreshold(null);
    }

    @Override
    public void setFailureThreshold(Ratio threshold) {
        this.bitSet = new CircularBitSet(threshold.getDenominator(), this.bitSet);
    }

    synchronized void checkThreshold(ExecutionContext context) {
        Ratio failureRatio = this.breaker.getFailureThreshold();
        if (failureRatio != null && this.bitSet.occupiedBits() >= failureRatio.getDenominator() && this.bitSet.negativeRatioValue() >= failureRatio.getValue()) {
            this.internals.open(context);
        } else if (failureRatio == null && this.bitSet.negativeRatioValue() == 1.0) {
            this.internals.open(context);
        }
    }
}

