/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.meter;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.DoubleAdder;
import org.apache.skywalking.apm.agent.core.meter.AbstractBuilder;
import org.apache.skywalking.apm.agent.core.meter.BaseMeter;
import org.apache.skywalking.apm.agent.core.meter.CounterMode;
import org.apache.skywalking.apm.agent.core.meter.MeterId;
import org.apache.skywalking.apm.agent.core.meter.MeterType;
import org.apache.skywalking.apm.network.language.agent.v3.MeterData;
import org.apache.skywalking.apm.network.language.agent.v3.MeterSingleValue;

public class Counter
extends BaseMeter {
    protected final DoubleAdder count;
    protected final CounterMode mode;
    private final AtomicReference<Double> previous = new AtomicReference();

    public Counter(MeterId meterId, CounterMode mode) {
        super(meterId);
        this.count = new DoubleAdder();
        this.mode = mode;
    }

    public void increment(double count) {
        this.count.add(count);
    }

    public double get() {
        return this.count.doubleValue();
    }

    @Override
    public MeterData.Builder transform() {
        Double previousValue;
        double currentValue = this.get();
        double count = Objects.equals((Object)this.mode, (Object)CounterMode.RATE) ? ((previousValue = this.previous.getAndSet(currentValue)) == null ? currentValue : currentValue - previousValue) : currentValue;
        MeterData.Builder builder = MeterData.newBuilder();
        builder.setSingleValue(MeterSingleValue.newBuilder().setName(this.getName()).addAllLabels(this.transformTags()).setValue(count).build());
        return builder;
    }

    public static class Builder
    extends AbstractBuilder<Builder, Counter> {
        private CounterMode mode = CounterMode.INCREMENT;

        public Builder(String name) {
            super(name);
        }

        public Builder mode(CounterMode mode) {
            this.mode = mode;
            return this;
        }

        @Override
        protected Counter create(MeterId meterId) {
            return new Counter(meterId, this.mode);
        }

        @Override
        protected MeterType getType() {
            return MeterType.COUNTER;
        }
    }

    public static enum Mode {
        INCREMENT,
        RATE;

    }
}

