/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.serializer.seata.protocol.transaction;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import org.apache.seata.core.model.BranchStatus;
import org.apache.seata.core.model.BranchType;
import org.apache.seata.core.protocol.transaction.BranchReportRequest;
import org.apache.seata.serializer.seata.protocol.transaction.AbstractTransactionRequestToTCCodec;

public class BranchReportRequestCodec
extends AbstractTransactionRequestToTCCodec {
    @Override
    public Class<?> getMessageClassType() {
        return BranchReportRequest.class;
    }

    @Override
    public <T> void encode(T t, ByteBuf out) {
        byte[] bs;
        BranchReportRequest branchReportRequest = (BranchReportRequest)t;
        String xid = branchReportRequest.getXid();
        long branchId = branchReportRequest.getBranchId();
        BranchStatus status = branchReportRequest.getStatus();
        String resourceId = branchReportRequest.getResourceId();
        String applicationData = branchReportRequest.getApplicationData();
        BranchType branchType = branchReportRequest.getBranchType();
        if (xid != null) {
            bs = xid.getBytes(UTF8);
            out.writeShort((int)((short)bs.length));
            if (bs.length > 0) {
                out.writeBytes(bs);
            }
        } else {
            out.writeShort(0);
        }
        out.writeLong(branchId);
        out.writeByte(status.getCode());
        if (resourceId != null) {
            bs = resourceId.getBytes(UTF8);
            out.writeShort((int)((short)bs.length));
            if (bs.length > 0) {
                out.writeBytes(bs);
            }
        } else {
            out.writeShort(0);
        }
        if (applicationData != null) {
            byte[] applicationDataBytes = applicationData.getBytes(UTF8);
            out.writeInt(applicationDataBytes.length);
            if (applicationDataBytes.length > 0) {
                out.writeBytes(applicationDataBytes);
            }
        } else {
            out.writeInt(0);
        }
        out.writeByte(branchType.ordinal());
    }

    @Override
    public <T> void decode(T t, ByteBuffer in) {
        int iLen;
        BranchReportRequest branchReportRequest = (BranchReportRequest)t;
        short xidLen = in.getShort();
        if (xidLen > 0) {
            byte[] bs = new byte[xidLen];
            in.get(bs);
            branchReportRequest.setXid(new String(bs, UTF8));
        }
        branchReportRequest.setBranchId(in.getLong());
        branchReportRequest.setStatus(BranchStatus.get((byte)in.get()));
        short len = in.getShort();
        if (len > 0) {
            byte[] bs = new byte[len];
            in.get(bs);
            branchReportRequest.setResourceId(new String(bs, UTF8));
        }
        if ((iLen = in.getInt()) > 0) {
            byte[] bs = new byte[iLen];
            in.get(bs);
            branchReportRequest.setApplicationData(new String(bs, UTF8));
        }
        branchReportRequest.setBranchType(BranchType.get((byte)in.get()));
    }
}

