/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.instrumentation.kafka;

import org.apache.flume.instrumentation.ChannelCounter;
import org.apache.flume.instrumentation.kafka.KafkaChannelCounterMBean;

public class KafkaChannelCounter
extends ChannelCounter
implements KafkaChannelCounterMBean {
    private static final String TIMER_KAFKA_EVENT_GET = "channel.kafka.event.get.time";
    private static final String TIMER_KAFKA_EVENT_SEND = "channel.kafka.event.send.time";
    private static final String TIMER_KAFKA_COMMIT = "channel.kafka.commit.time";
    private static final String COUNT_ROLLBACK = "channel.rollback.count";
    private static String[] ATTRIBUTES = new String[]{"channel.kafka.commit.time", "channel.kafka.event.send.time", "channel.kafka.event.get.time", "channel.rollback.count"};

    public KafkaChannelCounter(String name) {
        super(name, ATTRIBUTES);
    }

    public long addToKafkaEventGetTimer(long delta) {
        return this.addAndGet(TIMER_KAFKA_EVENT_GET, delta);
    }

    public long addToKafkaEventSendTimer(long delta) {
        return this.addAndGet(TIMER_KAFKA_EVENT_SEND, delta);
    }

    public long addToKafkaCommitTimer(long delta) {
        return this.addAndGet(TIMER_KAFKA_COMMIT, delta);
    }

    public long addToRollbackCounter(long delta) {
        return this.addAndGet(COUNT_ROLLBACK, delta);
    }

    @Override
    public long getKafkaEventGetTimer() {
        return this.get(TIMER_KAFKA_EVENT_GET);
    }

    @Override
    public long getKafkaEventSendTimer() {
        return this.get(TIMER_KAFKA_EVENT_SEND);
    }

    @Override
    public long getKafkaCommitTimer() {
        return this.get(TIMER_KAFKA_COMMIT);
    }

    @Override
    public long getRollbackCount() {
        return this.get(COUNT_ROLLBACK);
    }
}

