/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.interceptor;

import java.util.List;
import java.util.Map;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.interceptor.Interceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(StaticInterceptor.class);
    private final boolean preserveExisting;
    private final String key;
    private final String value;

    private StaticInterceptor(boolean preserveExisting, String key, String value) {
        this.preserveExisting = preserveExisting;
        this.key = key;
        this.value = value;
    }

    @Override
    public void initialize() {
    }

    @Override
    public Event intercept(Event event) {
        Map headers = event.getHeaders();
        if (this.preserveExisting && headers.containsKey(this.key)) {
            return event;
        }
        headers.put(this.key, this.value);
        return event;
    }

    @Override
    public List<Event> intercept(List<Event> events) {
        for (Event event : events) {
            this.intercept(event);
        }
        return events;
    }

    @Override
    public void close() {
    }

    public static class Constants {
        public static final String KEY = "key";
        public static final String KEY_DEFAULT = "key";
        public static final String VALUE = "value";
        public static final String VALUE_DEFAULT = "value";
        public static final String PRESERVE = "preserveExisting";
        public static final boolean PRESERVE_DEFAULT = true;
    }

    public static class Builder
    implements Interceptor.Builder {
        private boolean preserveExisting;
        private String key;
        private String value;

        @Override
        public void configure(Context context) {
            this.preserveExisting = context.getBoolean("preserveExisting", Boolean.valueOf(true));
            this.key = context.getString("key", "key");
            this.value = context.getString("value", "value");
        }

        @Override
        public Interceptor build() {
            logger.info(String.format("Creating StaticInterceptor: preserveExisting=%s,key=%s,value=%s", this.preserveExisting, this.key, this.value));
            return new StaticInterceptor(this.preserveExisting, this.key, this.value);
        }
    }
}

