/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.event.EventBuilder;
import org.apache.flume.event.JSONEvent;
import org.apache.flume.source.http.HTTPBadRequestException;
import org.apache.flume.source.http.HTTPSourceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONHandler
implements HTTPSourceHandler {
    private static final Logger LOG = LoggerFactory.getLogger(JSONHandler.class);
    private final Type listType = new TypeToken<List<JSONEvent>>(){}.getType();
    private final Gson gson = new GsonBuilder().disableHtmlEscaping().create();

    @Override
    public List<Event> getEvents(HttpServletRequest request) throws Exception {
        BufferedReader reader = request.getReader();
        String charset = request.getCharacterEncoding();
        if (charset == null) {
            LOG.debug("Charset is null, default charset of UTF-8 will be used.");
            charset = "UTF-8";
        } else if (!(charset.equalsIgnoreCase("utf-8") || charset.equalsIgnoreCase("utf-16") || charset.equalsIgnoreCase("utf-32"))) {
            LOG.error("Unsupported character set in request {}. JSON handler supports UTF-8, UTF-16 and UTF-32 only.", (Object)charset);
            throw new UnsupportedCharsetException("JSON handler supports UTF-8, UTF-16 and UTF-32 only.");
        }
        List<Event> eventList = new ArrayList(0);
        try {
            eventList = (List)this.gson.fromJson((Reader)reader, this.listType);
        }
        catch (JsonSyntaxException ex) {
            throw new HTTPBadRequestException("Request has invalid JSON Syntax.", ex);
        }
        for (Event e : eventList) {
            ((JSONEvent)e).setCharset(charset);
        }
        return this.getSimpleEvents(eventList);
    }

    @Override
    public void configure(Context context) {
    }

    private List<Event> getSimpleEvents(List<Event> events) {
        ArrayList<Event> newEvents = new ArrayList<Event>(events.size());
        for (Event e : events) {
            newEvents.add(EventBuilder.withBody((byte[])e.getBody(), (Map)e.getHeaders()));
        }
        return newEvents;
    }
}

