/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectReader;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.PlanReference;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.InternalPlan;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.planner.delegation.DefaultExecutor;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.ExecNodeGraphInternalPlan;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraph;
import org.apache.flink.table.planner.plan.nodes.exec.processor.ExecNodeGraphProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodePlanDumper;
import org.apache.flink.table.planner.plan.optimize.Optimizer;
import org.apache.flink.table.planner.plan.optimize.StreamCommonSubGraphBasedOptimizer;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistributionTraitDef$;
import org.apache.flink.table.planner.plan.trait.MiniBatchIntervalTraitDef$;
import org.apache.flink.table.planner.plan.trait.ModifyKindSetTraitDef$;
import org.apache.flink.table.planner.plan.trait.UpdateKindTraitDef$;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.utils.DummyStreamExecutionEnvironment;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple4;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001B\u0001\u0003\u0001=\u0011Qb\u0015;sK\u0006l\u0007\u000b\\1o]\u0016\u0014(BA\u0002\u0005\u0003)!W\r\\3hCRLwN\u001c\u0006\u0003\u000b\u0019\tq\u0001\u001d7b]:,'O\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005-\u0001F.\u00198oKJ\u0014\u0015m]3\t\u0011U\u0001!\u0011!Q\u0001\nY\t\u0001\"\u001a=fGV$xN\u001d\t\u0003/ei\u0011\u0001\u0007\u0006\u0003\u0007\u0019I!A\u0007\r\u0003\u0011\u0015CXmY;u_JD\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!H\u0001\fi\u0006\u0014G.Z\"p]\u001aLw\r\u0005\u0002\u001fC5\tqD\u0003\u0002!\r\u0005\u0019\u0011\r]5\n\u0005\tz\"a\u0003+bE2,7i\u001c8gS\u001eD\u0011\u0002\n\u0001\u0003\u0002\u0003\u0006I!J\u0016\u0002\u001b5|G-\u001e7f\u001b\u0006t\u0017mZ3s!\t1\u0013&D\u0001(\u0015\tAc!\u0001\u0004n_\u0012,H.Z\u0005\u0003U\u001d\u0012Q\"T8ek2,W*\u00198bO\u0016\u0014\u0018B\u0001\u0013\u0013\u0011%i\u0003A!A!\u0002\u0013qC'A\bgk:\u001cG/[8o\u0007\u0006$\u0018\r\\8h!\ty#'D\u00011\u0015\t\td!A\u0004dCR\fGn\\4\n\u0005M\u0002$a\u0004$v]\u000e$\u0018n\u001c8DCR\fGn\\4\n\u00055\u0012\u0002\"\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001c;\u00039\u0019\u0017\r^1m_\u001el\u0015M\\1hKJ\u0004\"a\f\u001d\n\u0005e\u0002$AD\"bi\u0006dwnZ'b]\u0006<WM]\u0005\u0003mIAQ\u0001\u0010\u0001\u0005\u0002u\na\u0001P5oSRtDC\u0002 @\u0001\u0006\u00135\t\u0005\u0002\u0012\u0001!)Qc\u000fa\u0001-!)Ad\u000fa\u0001;!)Ae\u000fa\u0001K!)Qf\u000fa\u0001]!)ag\u000fa\u0001o!)Q\t\u0001C)\r\u0006aq-\u001a;Ue\u0006LG\u000fR3ggV\tq\tE\u0002I\u00176k\u0011!\u0013\u0006\u0002\u0015\u0006)1oY1mC&\u0011A*\u0013\u0002\u0006\u0003J\u0014\u0018-\u001f\u0019\u0003\u001db\u00032a\u0014+W\u001b\u0005\u0001&BA)S\u0003\u0011\u0001H.\u00198\u000b\u0005MS\u0011aB2bY\u000eLG/Z\u0005\u0003+B\u00131BU3m)J\f\u0017\u000e\u001e#fMB\u0011q\u000b\u0017\u0007\u0001\t%IF)!A\u0001\u0002\u000b\u0005!LA\u0002`IE\n\"a\u00170\u0011\u0005!c\u0016BA/J\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aT0\n\u0005\u0001\u0004&\u0001\u0003*fYR\u0013\u0018-\u001b;\t\u000b\t\u0004A\u0011K2\u0002\u0019\u001d,Go\u00149uS6L'0\u001a:\u0016\u0003\u0011\u0004\"!Z5\u000e\u0003\u0019T!a\u001a5\u0002\u0011=\u0004H/[7ju\u0016T!!\u0015\u0003\n\u0005)4'!C(qi&l\u0017N_3s\u0011\u0015a\u0007\u0001\"\u0015n\u0003i9W\r^#yK\u000etu\u000eZ3He\u0006\u0004\b\u000e\u0015:pG\u0016\u001c8o\u001c:t+\u0005q\u0007cA8xu:\u0011\u0001/\u001e\b\u0003cRl\u0011A\u001d\u0006\u0003g:\ta\u0001\u0010:p_Rt\u0014\"\u0001&\n\u0005YL\u0015a\u00029bG.\fw-Z\u0005\u0003qf\u00141aU3r\u0015\t1\u0018\nE\u0002|\u0003\u000bi\u0011\u0001 \u0006\u0003{z\f\u0011\u0002\u001d:pG\u0016\u001c8o\u001c:\u000b\u0007}\f\t!\u0001\u0003fq\u0016\u001c'bAA\u0002Q\u0006)an\u001c3fg&\u0019\u0011q\u0001?\u0003-\u0015CXm\u0019(pI\u0016<%/\u00199i!J|7-Z:t_JDq!a\u0003\u0001\t#\ni!A\bue\u0006t7\u000f\\1uKR{\u0007\u000b\\1o)\u0011\ty!!\u0010\u0011\r\u0005E\u00111DA\u0010\u001b\t\t\u0019B\u0003\u0003\u0002\u0016\u0005]\u0011\u0001B;uS2T!!!\u0007\u0002\t)\fg/Y\u0005\u0005\u0003;\t\u0019B\u0001\u0003MSN$\b\u0007BA\u0011\u0003c\u0001b!a\t\u0002,\u0005=RBAA\u0013\u0015\u0011\t9#!\u000b\u0002\u0007\u0011\fwM\u0003\u0002!\u0011%!\u0011QFA\u0013\u00059!&/\u00198tM>\u0014X.\u0019;j_:\u00042aVA\u0019\t1\t\u0019$!\u0003\u0002\u0002\u0003\u0005)\u0011AA\u001b\u0005\ryFEM\t\u00047\u0006]\u0002c\u0001%\u0002:%\u0019\u00111H%\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002@\u0005%\u0001\u0019AA!\u0003%)\u00070Z2He\u0006\u0004\b\u000e\u0005\u0003\u0002D\u0005\u0015S\"\u0001@\n\u0007\u0005\u001dcPA\u0007Fq\u0016\u001cgj\u001c3f\u000fJ\f\u0007\u000f\u001b\u0005\b\u0003\u0017\u0002A\u0011IA'\u0003\u001d)\u0007\u0010\u001d7bS:$b!a\u0014\u0002`\u0005=\u0004\u0003BA)\u00033rA!a\u0015\u0002VA\u0011\u0011/S\u0005\u0004\u0003/J\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002\\\u0005u#AB*ue&twMC\u0002\u0002X%C\u0001\"!\u0019\u0002J\u0001\u0007\u00111M\u0001\u000b_B,'/\u0019;j_:\u001c\bCBA\t\u00037\t)\u0007\u0005\u0003\u0002h\u0005-TBAA5\u0015\r\t\tGB\u0005\u0005\u0003[\nIGA\u0005Pa\u0016\u0014\u0018\r^5p]\"A\u0011\u0011OA%\u0001\u0004\t\u0019(\u0001\u0007fqR\u0014\u0018\rR3uC&d7\u000fE\u0003I\u0003k\nI(C\u0002\u0002x%\u0013!\u0002\u0010:fa\u0016\fG/\u001a3?!\rq\u00121P\u0005\u0004\u0003{z\"!D#ya2\f\u0017N\u001c#fi\u0006LG\u000eC\u0004\u0002\u0002\u0002!I!a!\u0002%\r\u0014X-\u0019;f\tVlW.\u001f)mC:tWM\u001d\u000b\u0002}!9\u0011q\u0011\u0001\u0005B\u0005%\u0015\u0001\u00037pC\u0012\u0004F.\u00198\u0015\t\u0005-\u0015\u0011\u0013\t\u0004/\u00055\u0015bAAH1\ta\u0011J\u001c;fe:\fG\u000e\u00157b]\"A\u00111SAC\u0001\u0004\t)*A\u0007qY\u0006t'+\u001a4fe\u0016t7-\u001a\t\u0004=\u0005]\u0015bAAM?\ti\u0001\u000b\\1o%\u00164WM]3oG\u0016Dq!!(\u0001\t\u0003\ny*A\u0006d_6\u0004\u0018\u000e\\3QY\u0006tG\u0003BAF\u0003CC\u0001\"a)\u0002\u001c\u0002\u0007\u0011QU\u0001\u0011[>$\u0017NZ=Pa\u0016\u0014\u0018\r^5p]N\u0004b!!\u0005\u0002\u001c\u0005\u001d\u0006\u0003BA4\u0003SKA!a+\u0002j\tyQj\u001c3jMf|\u0005/\u001a:bi&|g\u000eC\u0004\u00020\u0002!\t%!-\u0002\u001bQ\u0014\u0018M\\:mCR,\u0007\u000b\\1o)\u0011\t\u0019,a0\u0011\r\u0005E\u00111DA[a\u0011\t9,a/\u0011\r\u0005\r\u00121FA]!\r9\u00161\u0018\u0003\r\u0003{\u000bi+!A\u0001\u0002\u000b\u0005\u0011Q\u0007\u0002\u0004?\u0012\u001a\u0004bB)\u0002.\u0002\u0007\u00111\u0012\u0005\b\u0003\u0007\u0004A\u0011IAc\u0003-)\u0007\u0010\u001d7bS:\u0004F.\u00198\u0015\r\u0005=\u0013qYAe\u0011\u001d\t\u0016\u0011\u0019a\u0001\u0003\u0017C\u0001\"!\u001d\u0002B\u0002\u0007\u00111\u000f\u0005\b\u0003\u001b\u0004A\u0011IAh\u0003E\u0011WMZ8sKR\u0013\u0018M\\:mCRLwN\u001c\u000b\u0003\u0003#\u00042\u0001SAj\u0013\r\t).\u0013\u0002\u0005+:LG\u000f")
public class StreamPlanner
extends PlannerBase {
    private final Executor executor;
    private final TableConfig tableConfig;

    @Override
    public RelTraitDef<? extends RelTrait>[] getTraitDefs() {
        return (RelTraitDef[])((Object[])new RelTraitDef[]{ConventionTraitDef.INSTANCE, FlinkRelDistributionTraitDef$.MODULE$.INSTANCE(), MiniBatchIntervalTraitDef$.MODULE$.INSTANCE(), ModifyKindSetTraitDef$.MODULE$.INSTANCE(), UpdateKindTraitDef$.MODULE$.INSTANCE()});
    }

    @Override
    public Optimizer getOptimizer() {
        return new StreamCommonSubGraphBasedOptimizer(this);
    }

    @Override
    public Seq<ExecNodeGraphProcessor> getExecNodeGraphProcessors() {
        return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    @Override
    public List<Transformation<?>> translateToPlan(ExecNodeGraph execGraph) {
        this.beforeTranslation();
        StreamPlanner planner = this.createDummyPlanner();
        Buffer transformations = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(execGraph.getRootNodes()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ExecNode execNode = x0$1;
            if (!(execNode instanceof StreamExecNode)) {
                throw new TableException("Cannot generate DataStream due to an invalid logical plan. This is a bug and should not happen. Please file an issue.");
            }
            StreamExecNode streamExecNode = (StreamExecNode)execNode;
            Transformation transformation = streamExecNode.translateToPlan(planner);
            return transformation;
        }, Buffer$.MODULE$.canBuildFrom());
        this.afterTranslation();
        return JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(transformations);
    }

    public String explain(List<Operation> operations, Seq<ExplainDetail> extraDetails) {
        BoxedUnit boxedUnit;
        Tuple4<Buffer<RelNode>, Seq<RelNode>, ExecNodeGraph, StreamGraph> tuple4 = this.getExplainGraphs(operations);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        Buffer sinkRelNodes = (Buffer)tuple4._1();
        Seq optimizedRelNodes = (Seq)tuple4._2();
        ExecNodeGraph execGraph = (ExecNodeGraph)tuple4._3();
        StreamGraph streamGraph = (StreamGraph)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)sinkRelNodes, (Object)optimizedRelNodes, (Object)execGraph, (Object)streamGraph);
        Tuple4 tuple43 = tuple42;
        Buffer sinkRelNodes2 = (Buffer)tuple43._1();
        Seq optimizedRelNodes2 = (Seq)tuple43._2();
        ExecNodeGraph execGraph2 = (ExecNodeGraph)tuple43._3();
        StreamGraph streamGraph2 = (StreamGraph)tuple43._4();
        StringBuilder sb = new StringBuilder();
        sb.append("== Abstract Syntax Tree ==");
        sb.append(System.lineSeparator());
        sinkRelNodes2.foreach((Function1 & Serializable & scala.Serializable)sink -> {
            sb.append(FlinkRelOptUtil$.MODULE$.toString((RelNode)sink, SqlExplainLevel.EXPPLAN_ATTRIBUTES, FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5()));
            return sb.append(System.lineSeparator());
        });
        sb.append("== Optimized Physical Plan ==");
        sb.append(System.lineSeparator());
        SqlExplainLevel explainLevel = extraDetails.contains((Object)ExplainDetail.ESTIMATED_COST) ? SqlExplainLevel.ALL_ATTRIBUTES : SqlExplainLevel.DIGEST_ATTRIBUTES;
        boolean withChangelogTraits = extraDetails.contains((Object)ExplainDetail.CHANGELOG_MODE);
        optimizedRelNodes2.foreach((Function1 & Serializable & scala.Serializable)rel -> {
            RelNode x$2 = rel;
            SqlExplainLevel x$3 = explainLevel;
            boolean x$4 = withChangelogTraits;
            boolean x$5 = FlinkRelOptUtil$.MODULE$.toString$default$3();
            boolean x$6 = FlinkRelOptUtil$.MODULE$.toString$default$5();
            sb.append(FlinkRelOptUtil$.MODULE$.toString(x$2, x$3, x$5, x$4, x$6));
            return sb.append(System.lineSeparator());
        });
        sb.append("== Optimized Execution Plan ==");
        sb.append(System.lineSeparator());
        sb.append(ExecNodePlanDumper.dagToString(execGraph2));
        if (extraDetails.contains((Object)ExplainDetail.JSON_EXECUTION_PLAN)) {
            sb.append(System.lineSeparator());
            sb.append("== Physical Execution Plan ==");
            sb.append(System.lineSeparator());
            boxedUnit = sb.append(streamGraph2.getStreamingPlanAsJSON());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return sb.toString();
    }

    private StreamPlanner createDummyPlanner() {
        DummyStreamExecutionEnvironment dummyExecEnv = new DummyStreamExecutionEnvironment(this.getExecEnv());
        DefaultExecutor executor = new DefaultExecutor(dummyExecEnv);
        return new StreamPlanner(executor, this.tableConfig, super.moduleManager(), super.functionCatalog(), super.catalogManager());
    }

    public InternalPlan loadPlan(PlanReference planReference) {
        ExecNodeGraph execNodeGraph;
        SerdeContext ctx = this.createSerdeContext();
        ObjectReader objectReader = JsonSerdeUtil.createObjectReader(ctx);
        PlanReference planReference2 = planReference;
        if (planReference2 instanceof PlanReference.FilePlanReference) {
            PlanReference.FilePlanReference filePlanReference = (PlanReference.FilePlanReference)planReference2;
            execNodeGraph = (ExecNodeGraph)objectReader.readValue(filePlanReference.getFile(), ExecNodeGraph.class);
        } else if (planReference2 instanceof PlanReference.ContentPlanReference) {
            PlanReference.ContentPlanReference contentPlanReference = (PlanReference.ContentPlanReference)planReference2;
            execNodeGraph = (ExecNodeGraph)objectReader.readValue(contentPlanReference.getContent(), ExecNodeGraph.class);
        } else if (planReference2 instanceof PlanReference.ResourcePlanReference) {
            PlanReference.ResourcePlanReference resourcePlanReference = (PlanReference.ResourcePlanReference)planReference2;
            URL url = resourcePlanReference.getClassLoader().getResource(resourcePlanReference.getResourcePath());
            if (url == null) {
                throw new IOException(new java.lang.StringBuilder(47).append("Cannot load the plan reference from classpath: ").append(planReference).toString());
            }
            execNodeGraph = (ExecNodeGraph)objectReader.readValue(new File(url.toURI()), ExecNodeGraph.class);
        } else {
            throw new IllegalStateException("Unknown PlanReference. This is a bug, please contact the developers");
        }
        ExecNodeGraph execNodeGraph2 = execNodeGraph;
        return new ExecNodeGraphInternalPlan(JsonSerdeUtil.createObjectWriter(ctx).withDefaultPrettyPrinter().writeValueAsString((Object)execNodeGraph2), execNodeGraph2);
    }

    public InternalPlan compilePlan(List<ModifyOperation> modifyOperations) {
        this.beforeTranslation();
        Buffer relNodes = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(modifyOperations).map((Function1 & Serializable & scala.Serializable)modifyOperation -> this.translateToRel((ModifyOperation)modifyOperation), Buffer$.MODULE$.canBuildFrom());
        Seq<RelNode> optimizedRelNodes = this.optimize((Seq<RelNode>)relNodes);
        ExecNodeGraph execGraph = this.translateToExecNodeGraph(optimizedRelNodes, true);
        this.afterTranslation();
        return new ExecNodeGraphInternalPlan(JsonSerdeUtil.createObjectWriter(this.createSerdeContext()).withDefaultPrettyPrinter().writeValueAsString((Object)execGraph), execGraph);
    }

    /*
     * WARNING - void declaration
     */
    public List<Transformation<?>> translatePlan(InternalPlan plan) {
        void var3_3;
        this.beforeTranslation();
        ExecNodeGraph execGraph = ((ExecNodeGraphInternalPlan)plan).getExecNodeGraph();
        List<Transformation<?>> transformations = this.translateToPlan(execGraph);
        this.afterTranslation();
        return var3_3;
    }

    public String explainPlan(InternalPlan plan, Seq<ExplainDetail> extraDetails) {
        BoxedUnit boxedUnit;
        this.beforeTranslation();
        ExecNodeGraph execGraph = ((ExecNodeGraphInternalPlan)plan).getExecNodeGraph();
        List<Transformation<?>> transformations = this.translateToPlan(execGraph);
        this.afterTranslation();
        StreamGraph streamGraph = (StreamGraph)this.executor.createPipeline(transformations, (ReadableConfig)this.tableConfig.getConfiguration(), null);
        StringBuilder sb = new StringBuilder();
        sb.append("== Optimized Execution Plan ==");
        sb.append(System.lineSeparator());
        sb.append(ExecNodePlanDumper.dagToString(execGraph));
        if (extraDetails.contains((Object)ExplainDetail.JSON_EXECUTION_PLAN)) {
            sb.append(System.lineSeparator());
            sb.append("== Physical Execution Plan ==");
            sb.append(System.lineSeparator());
            boxedUnit = sb.append(streamGraph.getStreamingPlanAsJSON());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return sb.toString();
    }

    @Override
    public void beforeTranslation() {
        RuntimeExecutionMode runtimeMode;
        super.beforeTranslation();
        RuntimeExecutionMode runtimeExecutionMode = runtimeMode = (RuntimeExecutionMode)this.getTableConfig().get(ExecutionOptions.RUNTIME_MODE);
        RuntimeExecutionMode runtimeExecutionMode2 = RuntimeExecutionMode.STREAMING;
        if (runtimeExecutionMode == null ? runtimeExecutionMode2 != null : !runtimeExecutionMode.equals(runtimeExecutionMode2)) {
            throw new IllegalArgumentException("Mismatch between configured runtime mode and actual runtime mode. Currently, the 'execution.runtime-mode' can only be set when instantiating the table environment. Subsequent changes are not supported. Please instantiate a new TableEnvironment if necessary.");
        }
    }

    public String explainPlan(InternalPlan plan, ExplainDetail[] extraDetails) {
        return this.explainPlan(plan, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])extraDetails));
    }

    public String explain(List<Operation> operations, ExplainDetail[] extraDetails) {
        return this.explain(operations, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])extraDetails));
    }

    public StreamPlanner(Executor executor, TableConfig tableConfig, ModuleManager moduleManager, FunctionCatalog functionCatalog, CatalogManager catalogManager) {
        this.executor = executor;
        this.tableConfig = tableConfig;
        super(executor, tableConfig, moduleManager, functionCatalog, catalogManager, true);
    }
}

