/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.batch;

import java.io.Serializable;
import java.util.Collection;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions$;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalJoin;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalHashJoin;
import org.apache.flink.table.planner.plan.rules.physical.batch.BatchPhysicalHashJoinRule$;
import org.apache.flink.table.planner.plan.rules.physical.batch.BatchPhysicalJoinRuleBase;
import org.apache.flink.table.planner.plan.rules.physical.batch.BatchPhysicalJoinRuleBase$;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution$;
import org.apache.flink.table.planner.plan.utils.OperatorType;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Range;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001e4A!\u0001\u0002\u0001+\tI\")\u0019;dQBC\u0017p]5dC2D\u0015m\u001d5K_&t'+\u001e7f\u0015\t\u0019A!A\u0003cCR\u001c\u0007N\u0003\u0002\u0006\r\u0005A\u0001\u000f[=tS\u000e\fGN\u0003\u0002\b\u0011\u0005)!/\u001e7fg*\u0011\u0011BC\u0001\u0005a2\fgN\u0003\u0002\f\u0019\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0007\u000f\u0003\u0015!\u0018M\u00197f\u0015\ty\u0001#A\u0003gY&t7N\u0003\u0002\u0012%\u00051\u0011\r]1dQ\u0016T\u0011aE\u0001\u0004_J<7\u0001A\n\u0004\u0001Yi\u0002CA\f\u001c\u001b\u0005A\"BA\u0005\u001a\u0015\tQ\u0002#A\u0004dC2\u001c\u0017\u000e^3\n\u0005qA\"A\u0003*fY>\u0003HOU;mKB\u0011adH\u0007\u0002\u0005%\u0011\u0001E\u0001\u0002\u001a\u0005\u0006$8\r\u001b)isNL7-\u00197K_&t'+\u001e7f\u0005\u0006\u001cX\rC\u0003#\u0001\u0011\u00051%\u0001\u0004=S:LGO\u0010\u000b\u0002IA\u0011a\u0004\u0001\u0005\u0006M\u0001!\teJ\u0001\b[\u0006$8\r[3t)\tAc\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#FA\u0004C_>dW-\u00198\t\u000b=*\u0003\u0019\u0001\u0019\u0002\t\r\fG\u000e\u001c\t\u0003/EJ!A\r\r\u0003\u001dI+Gn\u00149u%VdWmQ1mY\")A\u0007\u0001C!k\u00059qN\\'bi\u000eDGC\u0001\u001c:!\tIs'\u0003\u00029U\t!QK\\5u\u0011\u0015y3\u00071\u00011\u0011\u0015Y\u0004\u0001\"\u0003=\u00031\u0019\u0017M\u001c\"s_\u0006$7-Y:u)\u0015i\u0004I\u00131c!\u0011Ic\b\u000b\u0015\n\u0005}R#A\u0002+va2,'\u0007C\u0003Bu\u0001\u0007!)\u0001\u0005k_&tG+\u001f9f!\t\u0019\u0005*D\u0001E\u0015\t)e)\u0001\u0003d_J,'BA$\u001a\u0003\r\u0011X\r\\\u0005\u0003\u0013\u0012\u00131BS8j]J+G\u000eV=qK\")1J\u000fa\u0001\u0019\u0006AA.\u001a4u'&TX\r\u0005\u0002N;:\u0011aj\u0017\b\u0003\u001fjs!\u0001U-\u000f\u0005ECfB\u0001*X\u001d\t\u0019f+D\u0001U\u0015\t)F#\u0001\u0004=e>|GOP\u0005\u0002'%\u0011\u0011CE\u0005\u0003\u001fAI!!\u0004\b\n\u0005-a\u0011B\u0001/\u000b\u0003\u001d\u0001\u0018mY6bO\u0016L!AX0\u0003\u000f)#u.\u001e2mK*\u0011AL\u0003\u0005\u0006Cj\u0002\r\u0001T\u0001\ne&<\u0007\u000e^*ju\u0016DQa\u0019\u001eA\u0002\u0011\f1\u0002^1cY\u0016\u001cuN\u001c4jOB\u0011Q\r[\u0007\u0002M*\u0011q\rD\u0001\u0004CBL\u0017BA5g\u0005-!\u0016M\u00197f\u0007>tg-[4\b\u000b-\u0014\u0001\u0012\u00017\u00023\t\u000bGo\u00195QQf\u001c\u0018nY1m\u0011\u0006\u001c\bNS8j]J+H.\u001a\t\u0003=54Q!\u0001\u0002\t\u00029\u001c\"!\\8\u0011\u0005%\u0002\u0018BA9+\u0005\u0019\te.\u001f*fM\")!%\u001cC\u0001gR\tA\u000eC\u0004v[\n\u0007I\u0011\u0001<\u0002\u0011%s5\u000bV!O\u0007\u0016+\u0012\u0001\n\u0005\u0007q6\u0004\u000b\u0011\u0002\u0013\u0002\u0013%s5\u000bV!O\u0007\u0016\u0003\u0003")
public class BatchPhysicalHashJoinRule
extends RelOptRule
implements BatchPhysicalJoinRuleBase {
    public static BatchPhysicalHashJoinRule INSTANCE() {
        return BatchPhysicalHashJoinRule$.MODULE$.INSTANCE();
    }

    @Override
    public RelNode addLocalDistinctAgg(RelNode node, Seq<Object> distinctKeys) {
        return BatchPhysicalJoinRuleBase.addLocalDistinctAgg$(this, node, distinctKeys);
    }

    @Override
    public boolean chooseSemiBuildDistinct(RelNode buildRel, Seq<Object> distinctKeys) {
        return BatchPhysicalJoinRuleBase.chooseSemiBuildDistinct$(this, buildRel, distinctKeys);
    }

    @Override
    public Double binaryRowRelNodeSize(RelNode relNode) {
        return BatchPhysicalJoinRuleBase.binaryRowRelNodeSize$(this, relNode);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        boolean isBroadcast;
        Join join = (Join)call.rel(0);
        JoinInfo joinInfo = join.analyzeCondition();
        if (joinInfo.pairs().isEmpty()) {
            return false;
        }
        TableConfig tableConfig = call.getPlanner().getContext().unwrap(FlinkContext.class).getTableConfig();
        boolean isShuffleHashJoinEnabled = !TableConfigUtils.isOperatorDisabled(tableConfig, OperatorType.ShuffleHashJoin);
        boolean isBroadcastHashJoinEnabled = !TableConfigUtils.isOperatorDisabled(tableConfig, OperatorType.BroadcastHashJoin);
        Double leftSize = this.binaryRowRelNodeSize(join.getLeft());
        Double rightSize = this.binaryRowRelNodeSize(join.getRight());
        Tuple2<Object, Object> tuple2 = this.canBroadcast(join.getJoinType(), leftSize, rightSize, tableConfig);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean bl = isBroadcast = tuple2._1$mcZ$sp();
        boolean isBroadcast2 = bl;
        return isBroadcast2 ? isBroadcastHashJoinEnabled : isShuffleHashJoinEnabled;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        block7: {
            boolean leftIsBuild;
            boolean isBroadcast;
            boolean tryDistinctBuildRow;
            RelNode right;
            RelNode left;
            JoinInfo joinInfo;
            Join join;
            TableConfig tableConfig;
            block6: {
                Tuple2 tuple2;
                tableConfig = call.getPlanner().getContext().unwrap(FlinkContext.class).getTableConfig();
                join = (Join)call.rel(0);
                joinInfo = join.analyzeCondition();
                JoinRelType joinType = join.getJoinType();
                left = join.getLeft();
                JoinRelType joinRelType = joinType;
                boolean bl = ((Object)((Object)JoinRelType.SEMI)).equals((Object)joinRelType) ? true : ((Object)((Object)JoinRelType.ANTI)).equals((Object)joinRelType);
                if (bl) {
                    Range distinctKeys = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), join.getRight().getRowType().getFieldCount());
                    boolean useBuildDistinct = this.chooseSemiBuildDistinct(join.getRight(), (Seq<Object>)distinctKeys);
                    tuple2 = useBuildDistinct ? new Tuple2((Object)this.addLocalDistinctAgg(join.getRight(), (Seq<Object>)distinctKeys), (Object)BoxesRunTime.boxToBoolean((boolean)true)) : new Tuple2((Object)join.getRight(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                } else {
                    tuple2 = new Tuple2((Object)join.getRight(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                }
                Tuple2 tuple22 = tuple2;
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                RelNode right2 = (RelNode)tuple22._1();
                boolean tryDistinctBuildRow2 = tuple22._2$mcZ$sp();
                Tuple2 tuple23 = new Tuple2((Object)right2, (Object)BoxesRunTime.boxToBoolean((boolean)tryDistinctBuildRow2));
                Tuple2 tuple24 = tuple23;
                right = (RelNode)tuple24._1();
                tryDistinctBuildRow = tuple24._2$mcZ$sp();
                Double leftSize = this.binaryRowRelNodeSize(left);
                Double rightSize = this.binaryRowRelNodeSize(right);
                Tuple2<Object, Object> tuple25 = this.canBroadcast(joinType, leftSize, rightSize, tableConfig);
                if (tuple25 == null) {
                    throw new MatchError(tuple25);
                }
                boolean isBroadcast2 = tuple25._1$mcZ$sp();
                boolean leftIsBroadcast = tuple25._2$mcZ$sp();
                Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(isBroadcast2, leftIsBroadcast);
                Tuple2.mcZZ.sp sp3 = sp2;
                isBroadcast = sp3._1$mcZ$sp();
                boolean leftIsBroadcast2 = sp3._2$mcZ$sp();
                boolean bl2 = isBroadcast ? leftIsBroadcast2 : (leftSize == null || rightSize == null || BoxesRunTime.equalsNumNum((Number)leftSize, (Number)rightSize) ? !join.getJoinType().projectsRight() : (leftIsBuild = Predef$.MODULE$.Double2double(leftSize) < Predef$.MODULE$.Double2double(rightSize)));
                if (!isBroadcast) break block6;
                RelTraitSet probeTrait = join.getTraitSet().replace(FlinkConventions$.MODULE$.BATCH_PHYSICAL());
                RelTraitSet buildTrait = join.getTraitSet().replace(FlinkConventions$.MODULE$.BATCH_PHYSICAL()).replace(FlinkRelDistribution$.MODULE$.BROADCAST_DISTRIBUTED());
                if (leftIsBroadcast2) {
                    BatchPhysicalHashJoinRule.transformToEquiv$1(buildTrait, probeTrait, call, join, left, right, tryDistinctBuildRow, isBroadcast, leftIsBuild);
                } else {
                    BatchPhysicalHashJoinRule.transformToEquiv$1(probeTrait, buildTrait, call, join, left, right, tryDistinctBuildRow, isBroadcast, leftIsBuild);
                }
                break block7;
            }
            Function1 & Serializable & scala.Serializable toHashTraitByColumns = (Function1 & Serializable & scala.Serializable)columns -> join.getCluster().getPlanner().emptyTraitSet().replace(FlinkConventions$.MODULE$.BATCH_PHYSICAL()).replace(FlinkRelDistribution$.MODULE$.hash((Collection<? extends Number>)columns, FlinkRelDistribution$.MODULE$.hash$default$2()));
            BatchPhysicalHashJoinRule.transformToEquiv$1((RelTraitSet)toHashTraitByColumns.apply((Object)joinInfo.leftKeys), (RelTraitSet)toHashTraitByColumns.apply((Object)joinInfo.rightKeys), call, join, left, right, tryDistinctBuildRow, isBroadcast, leftIsBuild);
            Boolean isShuffleByPartialKeyEnabled = (Boolean)tableConfig.get(BatchPhysicalJoinRuleBase$.MODULE$.TABLE_OPTIMIZER_SHUFFLE_BY_PARTIAL_KEY_ENABLED());
            if (!Predef$.MODULE$.Boolean2boolean(isShuffleByPartialKeyEnabled) || JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(joinInfo.pairs()).length() <= 1) break block7;
            JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(joinInfo.pairs()).foreach((Function1 & Serializable & scala.Serializable)pair -> {
                BatchPhysicalHashJoinRule.transformToEquiv$1((RelTraitSet)toHashTraitByColumns.apply((Object)ImmutableIntList.of(pair.source)), (RelTraitSet)toHashTraitByColumns.apply((Object)ImmutableIntList.of(pair.target)), call, join, left, right, tryDistinctBuildRow, isBroadcast, leftIsBuild);
                return BoxedUnit.UNIT;
            });
        }
    }

    private Tuple2<Object, Object> canBroadcast(JoinRelType joinType, Double leftSize, Double rightSize, TableConfig tableConfig) {
        Tuple2.mcZZ.sp sp2;
        if (leftSize == null || rightSize == null) {
            return new Tuple2.mcZZ.sp(false, false);
        }
        Long threshold = (Long)tableConfig.get(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD);
        JoinRelType joinRelType = joinType;
        if (((Object)((Object)JoinRelType.LEFT)).equals((Object)joinRelType)) {
            sp2 = new Tuple2.mcZZ.sp(Predef$.MODULE$.Double2double(rightSize) <= (double)Predef$.MODULE$.Long2long(threshold), false);
        } else if (((Object)((Object)JoinRelType.RIGHT)).equals((Object)joinRelType)) {
            sp2 = new Tuple2.mcZZ.sp(Predef$.MODULE$.Double2double(leftSize) <= (double)Predef$.MODULE$.Long2long(threshold), true);
        } else if (((Object)((Object)JoinRelType.FULL)).equals((Object)joinRelType)) {
            sp2 = new Tuple2.mcZZ.sp(false, false);
        } else if (((Object)((Object)JoinRelType.INNER)).equals((Object)joinRelType)) {
            sp2 = new Tuple2.mcZZ.sp(Predef$.MODULE$.Double2double(leftSize) <= (double)Predef$.MODULE$.Long2long(threshold) || Predef$.MODULE$.Double2double(rightSize) <= (double)Predef$.MODULE$.Long2long(threshold), Predef$.MODULE$.Double2double(leftSize) < Predef$.MODULE$.Double2double(rightSize));
        } else {
            boolean bl = ((Object)((Object)JoinRelType.SEMI)).equals((Object)joinRelType) ? true : ((Object)((Object)JoinRelType.ANTI)).equals((Object)joinRelType);
            if (bl) {
                sp2 = new Tuple2.mcZZ.sp(Predef$.MODULE$.Double2double(rightSize) <= (double)Predef$.MODULE$.Long2long(threshold), false);
            } else {
                throw new MatchError((Object)joinRelType);
            }
        }
        return sp2;
    }

    private static final void transformToEquiv$1(RelTraitSet leftRequiredTrait, RelTraitSet rightRequiredTrait, RelOptRuleCall call$1, Join join$1, RelNode left$1, RelNode right$1, boolean tryDistinctBuildRow$1, boolean isBroadcast$1, boolean leftIsBuild$1) {
        RelNode newLeft = RelOptRule.convert(left$1, leftRequiredTrait);
        RelNode newRight = RelOptRule.convert(right$1, rightRequiredTrait);
        RelTraitSet providedTraitSet = join$1.getTraitSet().replace(FlinkConventions$.MODULE$.BATCH_PHYSICAL());
        BatchPhysicalHashJoin newJoin = new BatchPhysicalHashJoin(join$1.getCluster(), providedTraitSet, newLeft, newRight, join$1.getCondition(), join$1.getJoinType(), leftIsBuild$1, isBroadcast$1, tryDistinctBuildRow$1);
        call$1.transformTo(newJoin);
    }

    public BatchPhysicalHashJoinRule() {
        super(RelOptRule.operand(FlinkLogicalJoin.class, RelOptRule.operand(RelNode.class, RelOptRule.any()), new RelOptRuleOperand[0]), "BatchPhysicalHashJoinRule");
        BatchPhysicalJoinRuleBase.$init$(this);
    }
}

