/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Executable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ons.ONS;
import oracle.ons.ONSException;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.FailoverEvent;
import oracle.ucp.common.FailoverEventHandlerTask;
import oracle.ucp.common.Failoverable;
import oracle.ucp.jdbc.oracle.DataBasedConnectionAffinityCallback;
import oracle.ucp.jdbc.oracle.FailoverActionResult;
import oracle.ucp.jdbc.oracle.FailoverStatisticsAccumulator;
import oracle.ucp.jdbc.oracle.FailoverStatisticsCounters;
import oracle.ucp.jdbc.oracle.FailoverStatisticsItem;
import oracle.ucp.jdbc.oracle.FailoverablePooledConnection;
import oracle.ucp.jdbc.oracle.ONSDatabaseEventHandlerTask;
import oracle.ucp.jdbc.oracle.ONSRuntimeLBEventHandlerTask;
import oracle.ucp.jdbc.oracle.OracleConnectionAffinityContext;
import oracle.ucp.jdbc.oracle.OracleFailoverEvent;
import oracle.ucp.jdbc.oracle.OracleGravitateConnectionPoolTask;
import oracle.ucp.jdbc.oracle.OracleLoadBalancingEvent;
import oracle.ucp.jdbc.oracle.RACAffinityContext;
import oracle.ucp.jdbc.oracle.RACCallback;
import oracle.ucp.jdbc.oracle.RACCallbackGuard;
import oracle.ucp.jdbc.oracle.RACInstance;
import oracle.ucp.jdbc.oracle.RACInstanceImpl;
import oracle.ucp.jdbc.oracle.RACManager;
import oracle.ucp.jdbc.oracle.rlb.MetricsAccumulator;
import oracle.ucp.jdbc.oracle.rlb.OracleDatabaseInstanceInfo;
import oracle.ucp.jdbc.oracle.rlb.OracleDatabaseInstanceInfoList;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.routing.oracle.ShardManager;
import oracle.ucp.routing.oracle.ShardManagerImpl;
import oracle.ucp.util.ProlongedTask;
import oracle.ucp.util.TaskManager;
import oracle.ucp.util.TimerManager;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.LOAD_BALANCING, Feature.HIGH_AVAILABILITY})
public class RACManagerImpl
implements RACManager,
Failoverable {
    private boolean m_isEntireServiceDownProcessed = false;
    private int m_cardinality = 0;
    private RACCallbackGuard m_cbk = null;
    private final FailoverStatisticsAccumulator eventAccumulator = new FailoverStatisticsAccumulator();
    private FailoverStatisticsItem currentEvent;
    public final MetricsAccumulator rlbMetricsAccumulator = new MetricsAccumulator();
    private int m_targetTearDownConnCount = 0;
    int m_tornDownConnCount = 0;
    int m_markedToCloseConnCount = 0;
    private int m_targetUpEventNewConnCount = 0;
    private int m_upEventNewConnCount = 0;
    final StringBuilder m_errorInfo = new StringBuilder(512);
    final AtomicReference<ONSDatabaseEventHandlerTask> m_failoverEventHandlerTask = new AtomicReference();
    private final OracleDatabaseInstanceInfoList m_dbInstanceInfoList;
    final AtomicReference<String> m_serviceName = new AtomicReference();
    private final AtomicReference<String> m_onsConfigurationString = new AtomicReference<String>("");
    private final int STARTED = 1;
    private final int STOPPED = 2;
    private int m_state = 2;
    protected final AtomicReference<String> m_fcfProcessingInfo = new AtomicReference<String>("");
    protected final AtomicReference<String> m_fcfProcessingInfoProcessedOnly = new AtomicReference<String>("");
    private final int ACTION_MARKDOWN = 100;
    private final int ACTION_CLEANUP = 200;
    private final BlockingQueue<OracleDatabaseInstanceInfo> m_instancesToGravitateQueue = new LinkedBlockingQueue<OracleDatabaseInstanceInfo>();
    private final Random m_rand = new Random(0L);
    private final AtomicReference<OracleGravitateConnectionPoolTask> m_gravitatePoolTask = new AtomicReference();
    private final AtomicBoolean m_gravitateTaskBusy = new AtomicBoolean();
    int[] m_mixTable;
    static final int MIX_TABLE_SIZE = 4096;
    static final int IRREDUCIBLE_POLYNOMIAL = 4105;
    static final int MIX_TABLE_GENERATOR = 3;
    private final AtomicReference<ONSRuntimeLBEventHandlerTask> m_rlbEventHandlerTask = new AtomicReference();
    private final AtomicBoolean m_runtimeLoadBalancingEnabled = new AtomicBoolean();
    protected ConnectionAffinityCallback m_connectionAffinityCallback = null;
    private final Map<String, Boolean> m_affinityMap = Collections.synchronizedMap(new HashMap());
    protected final AtomicLong m_successfulAffinityBasedBorrowCount = new AtomicLong(0L);
    protected final AtomicLong m_failedAffinityBasedBorrowCount = new AtomicLong(0L);
    protected final AtomicLong m_successfulRCLBBasedBorrowCount = new AtomicLong(0L);
    protected final AtomicLong m_failedRCLBBasedBorrowCount = new AtomicLong(0L);
    private final AtomicBoolean m_rclbMetricsPolicyEnabled = new AtomicBoolean(false);
    private final AtomicInteger m_dbVersion = new AtomicInteger(0);
    private final TaskManager m_taskManager;
    private final TimerManager m_timerManager;
    private boolean olderWLSCompatible;
    private final boolean isStrictWSAffinity;
    private final boolean isStrictXAAffinity;
    protected ONS currentONS = null;
    protected boolean calledStartONS = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;
    private static Executable $$$methodRef$$$61;
    private static Logger $$$loggerRef$$$61;
    private static Executable $$$methodRef$$$62;
    private static Logger $$$loggerRef$$$62;
    private static Executable $$$methodRef$$$63;
    private static Logger $$$loggerRef$$$63;
    private static Executable $$$methodRef$$$64;
    private static Logger $$$loggerRef$$$64;
    private static Executable $$$methodRef$$$65;
    private static Logger $$$loggerRef$$$65;
    private static Executable $$$methodRef$$$66;
    private static Logger $$$loggerRef$$$66;
    private static Executable $$$methodRef$$$67;
    private static Logger $$$loggerRef$$$67;
    private static Executable $$$methodRef$$$68;
    private static Logger $$$loggerRef$$$68;
    private static Executable $$$methodRef$$$69;
    private static Logger $$$loggerRef$$$69;

    RACManagerImpl(TaskManager taskMngr, TimerManager timerMngr, boolean isStrictWSAffinity, boolean isStrictXAAffinity) throws UniversalConnectionPoolException {
        this.m_dbInstanceInfoList = new OracleDatabaseInstanceInfoList(this);
        this.m_taskManager = taskMngr;
        this.m_timerManager = timerMngr;
        this.isStrictWSAffinity = isStrictWSAffinity;
        this.isStrictXAAffinity = isStrictXAAffinity;
        Util.disableDriverHA();
        Util.disableImplicitBeginRequest();
    }

    private boolean validateServiceEvent(OracleFailoverEvent failoverEvent) {
        String _svcName = failoverEvent.getServiceName();
        String _dbName = failoverEvent.getDbUniqueName();
        return _svcName != null && !_svcName.equals("") && _dbName != null && !_dbName.equals("");
    }

    private boolean validateHostDownEvent(OracleFailoverEvent failoverEvent) {
        String _hostName = failoverEvent.getHostName();
        return _hostName != null && !_hostName.equals("");
    }

    @Override
    public void handleFailoverEvent(FailoverEvent event) throws UniversalConnectionPoolException {
        if (event == null || !(event instanceof OracleFailoverEvent)) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(306);
        }
        OracleFailoverEvent failoverEvent = (OracleFailoverEvent)event;
        String status = failoverEvent.getStatus();
        String eventType = failoverEvent.getEventType();
        String serviceName = failoverEvent.getServiceName();
        String instanceName = failoverEvent.getInstanceName();
        String dbUniqueName = failoverEvent.getDbUniqueName();
        String hostName = failoverEvent.getHostName();
        String reason = failoverEvent.getReason();
        ClioSupport.ilogFinest(null, null, null, null, String.format("eventType: %s, status = %s", eventType, status));
        if (eventType.equals("database/event/service")) {
            if (status.equalsIgnoreCase("down") || status.equalsIgnoreCase("not_restarting") || status.equalsIgnoreCase("restart_failed")) {
                if (null == serviceName || !serviceName.equals(this.m_serviceName.get())) {
                    this.eventAccumulator.addItem(new FailoverStatisticsItem(FailoverStatisticsItem.Type.NOT_PROCESSED, serviceName, instanceName, dbUniqueName, hostName));
                    ClioSupport.ilogFinest(null, null, null, null, String.format("The service event has service name: %s, not applicable to this pool and not processed.", serviceName));
                } else if (this.validateServiceEvent(failoverEvent)) {
                    this.currentEvent = new FailoverStatisticsItem(FailoverStatisticsItem.Type.SERVICE_DOWN, serviceName, instanceName, dbUniqueName, hostName);
                    this.eventAccumulator.addItem(this.currentEvent);
                    this.getRACCallback().initiateDownEventProcessing(failoverEvent);
                } else {
                    this.eventAccumulator.addItem(new FailoverStatisticsItem(FailoverStatisticsItem.Type.NOT_PROCESSED, serviceName, instanceName, dbUniqueName, hostName));
                    ClioSupport.ilogFinest(null, null, null, null, "The service down event is invalid and not processed.");
                }
            } else if (status.equalsIgnoreCase("up")) {
                if (null == serviceName || !serviceName.equals(this.m_serviceName.get())) {
                    this.eventAccumulator.addItem(new FailoverStatisticsItem(FailoverStatisticsItem.Type.NOT_PROCESSED, serviceName, instanceName, dbUniqueName, hostName));
                    ClioSupport.ilogFinest(null, null, null, null, String.format("The service event has service name: %s, not applicable to this pool and not processed.", serviceName));
                } else if (this.validateServiceEvent(failoverEvent)) {
                    this.currentEvent = new FailoverStatisticsItem(FailoverStatisticsItem.Type.SERVICE_UP, serviceName, instanceName, dbUniqueName, hostName);
                    this.eventAccumulator.addItem(this.currentEvent);
                    int numToCreate = this.getRACCallback().initiateUpEventProcessing(failoverEvent);
                    this.processUpEvent2ndPhase(numToCreate);
                    this.m_isEntireServiceDownProcessed = false;
                } else {
                    this.eventAccumulator.addItem(new FailoverStatisticsItem(FailoverStatisticsItem.Type.NOT_PROCESSED, serviceName, instanceName, dbUniqueName, hostName));
                    ClioSupport.ilogFinest(null, null, null, null, "The service up event is invalid and not processed.");
                }
            }
        } else if (eventType.equals("database/event/host") && status.equalsIgnoreCase("nodedown")) {
            if (this.validateHostDownEvent(failoverEvent)) {
                this.currentEvent = new FailoverStatisticsItem(FailoverStatisticsItem.Type.HOST_DOWN, serviceName, instanceName, dbUniqueName, hostName);
                this.eventAccumulator.addItem(this.currentEvent);
                this.getRACCallback().initiateDownEventProcessing(failoverEvent);
            } else {
                this.eventAccumulator.addItem(new FailoverStatisticsItem(FailoverStatisticsItem.Type.NOT_PROCESSED, serviceName, instanceName, dbUniqueName, hostName));
                ClioSupport.ilogFinest(null, null, null, null, "The host down event is invalid and not processed.");
            }
        } else {
            this.eventAccumulator.addItem(new FailoverStatisticsItem(FailoverStatisticsItem.Type.NOT_PROCESSED, serviceName, instanceName, dbUniqueName, hostName));
            ClioSupport.ilogFinest(null, null, null, null, "Invalid Event received " + eventType);
        }
        this.updateFCFProcessingInfo(this.eventAccumulator.toString());
        this.updateFCFProcessingInfoProcessedOnly(this.eventAccumulator.toStringProcessedOnly());
        this.resetFCFInternalMetrics();
    }

    @Override
    public int processUpEvent(FailoverablePooledConnection[] aconns, FailoverablePooledConnection[] bconns, int initialPoolSize, int maxPoolSize, OracleFailoverEvent failoverEvent) throws UniversalConnectionPoolException {
        String status = failoverEvent.getStatus();
        String eventType = failoverEvent.getEventType();
        ClioSupport.ilogFinest(null, null, null, null, String.format("status=%s, eventType=%s", status, eventType));
        int numConnsToCreate = -1;
        if (eventType.equals("database/event/service")) {
            if (status.equalsIgnoreCase("up")) {
                numConnsToCreate = this.processServiceUpEvent(aconns, bconns, initialPoolSize, maxPoolSize, failoverEvent.getInstanceName(), failoverEvent.getHostName(), failoverEvent.getDbUniqueName());
            } else {
                ClioSupport.ilogFinest(null, null, null, null, "The service up event is invalid and not processed.");
            }
        } else {
            ClioSupport.ilogFinest(null, null, null, null, "Invalid Event received " + eventType);
        }
        return numConnsToCreate;
    }

    private FailoverStatisticsCounters processConnectionsForServiceDown(FailoverablePooledConnection[] conns, boolean isProcessingAvailableConnections, String instanceName, String dbUniqueName, boolean isPlannedDownEvent, long evtTimestamp, int actionFlag) {
        FailoverStatisticsCounters cs = new FailoverStatisticsCounters();
        cs.conns = conns.length;
        for (int i = 0; i < cs.conns; ++i) {
            if (!this.failoverServiceEventMatch(conns[i], instanceName, dbUniqueName, evtTimestamp)) continue;
            ++cs.affected;
            FailoverActionResult result = this.processFailoverAction(conns[i], isProcessingAvailableConnections, isPlannedDownEvent, actionFlag);
            cs.update(result);
        }
        return cs;
    }

    FailoverActionResult processFailoverAction(FailoverablePooledConnection pc, boolean isAvailableConnection, boolean isPlannedDownEvent, int actionFlag) {
        FailoverActionResult result = FailoverActionResult.NOOP;
        switch (actionFlag) {
            case 0: {
                try {
                    if (!isAvailableConnection && isPlannedDownEvent) {
                        pc.setStatus(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN);
                        result = FailoverActionResult.MARKED_CLOSE_ON_RETURN;
                        break;
                    }
                    pc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                    result = FailoverActionResult.MARKED_BAD;
                }
                catch (UniversalConnectionPoolException ucpe) {
                    ClioSupport.ilogFinest(null, null, null, null, "setting status failed: " + this.getStackTraceString(ucpe));
                    this.m_errorInfo.append(", ").append(ucpe.getStackTrace()[0].toString());
                    result = FailoverActionResult.FAILED;
                }
                break;
            }
            case 1: {
                try {
                    pc.abort();
                }
                catch (Exception exc) {
                    ClioSupport.ilogFinest(null, null, null, null, "aborting connection failed: " + this.getStackTraceString(exc));
                    this.m_errorInfo.append(", ").append(exc.getStackTrace()[0].toString());
                    result = FailoverActionResult.FAILED;
                }
                try {
                    pc.close(!isAvailableConnection);
                    result = FailoverActionResult.ABORTED_AND_CLOSED;
                }
                catch (UniversalConnectionPoolException ucpe) {
                    ClioSupport.ilogFinest(null, null, null, null, "closing connection failed: " + this.getStackTraceString(ucpe));
                    this.m_errorInfo.append(", ").append(ucpe.getStackTrace()[0].toString());
                    result = FailoverActionResult.FAILED;
                }
                break;
            }
        }
        return result;
    }

    private FailoverStatisticsCounters processConnectionsForHostDown(FailoverablePooledConnection[] pooledConnections, boolean isProcessingAvailableConnections, String hostName, long evtTimestamp, int actionFlag) {
        FailoverStatisticsCounters cs = new FailoverStatisticsCounters();
        cs.conns = pooledConnections.length;
        for (int i = 0; i < cs.conns; ++i) {
            if (!this.failoverHostEventMatch(pooledConnections[i], hostName, evtTimestamp)) continue;
            ++cs.affected;
            FailoverActionResult result = this.processFailoverAction(pooledConnections[i], isProcessingAvailableConnections, false, actionFlag);
            cs.update(result);
        }
        return cs;
    }

    private int processServiceUpEvent(FailoverablePooledConnection[] aconns, FailoverablePooledConnection[] bconns, int initialPoolSize, int maxPoolSize, String instanceName, String hostName, String dbUniqueName) {
        int createCount;
        this.currentEvent.availConns = aconns == null ? 0 : aconns.length;
        int n = this.currentEvent.borrowedConns = bconns == null ? 0 : bconns.length;
        assert (this.m_dbInstanceInfoList != null);
        if (instanceName != null && !"".equals(instanceName)) {
            this.m_dbInstanceInfoList.markUpInstanceForUpEvent(this.m_serviceName.get(), instanceName, hostName, dbUniqueName);
        }
        this.m_cardinality = this.m_dbInstanceInfoList.getUpInstancesCount();
        int totalConnsCount = this.currentEvent.availConns + this.currentEvent.borrowedConns;
        if (this.m_cardinality == 0) {
            ClioSupport.ilogFinest(null, null, null, null, "cardinality == 0, incorrect instance status");
            createCount = 0;
        } else if (this.m_cardinality == 1) {
            createCount = initialPoolSize - totalConnsCount;
            if (createCount > 0) {
                ClioSupport.ilogFinest(null, null, null, null, String.format("first up instance, to obtain %d connections", createCount));
            } else {
                createCount = 0;
                ClioSupport.ilogFinest(null, null, null, null, "first up instance, no new connections to obtain");
            }
        } else {
            createCount = this.getUpEventConnectionsToCreateCount(aconns, bconns, maxPoolSize, totalConnsCount);
            ClioSupport.ilogFinest(null, null, null, null, String.format("cardinality is %d, to get %d connections", this.m_cardinality, createCount));
        }
        this.m_targetUpEventNewConnCount = createCount;
        return createCount;
    }

    private void processUpEvent2ndPhase(int createCount) {
        boolean isFCFSuccessful;
        for (int i = 0; i < createCount; ++i) {
            try {
                this.getRACCallback().openNewConnection(null, null);
                ++this.m_upEventNewConnCount;
                continue;
            }
            catch (Exception e) {
                ClioSupport.ilogFinest(null, null, null, null, "UP-event processing failed when adding new connections " + this.getStackTraceString(e));
                this.m_errorInfo.append(", ").append(e.getStackTrace()[0].toString());
            }
        }
        this.currentEvent.cardinality = this.m_cardinality;
        this.currentEvent.targetedToTearConns = this.m_targetTearDownConnCount;
        this.currentEvent.tornDownConns = this.m_tornDownConnCount;
        this.currentEvent.markedToCloseConns = this.m_markedToCloseConnCount;
        this.currentEvent.targetUpEventNewConns = this.m_targetUpEventNewConnCount;
        this.currentEvent.upEventNewConnCount = this.m_upEventNewConnCount;
        this.currentEvent.successful = isFCFSuccessful = this.m_upEventNewConnCount == this.m_targetUpEventNewConnCount && this.m_targetTearDownConnCount == this.m_tornDownConnCount + this.m_markedToCloseConnCount && 0 == this.m_errorInfo.length();
        ClioSupport.ilogFinest(null, null, null, null, "Fast Connection Failover " + (isFCFSuccessful ? "succeeded" : "failed"));
    }

    private int getUpEventConnectionsToCreateCount(FailoverablePooledConnection[] aconns, FailoverablePooledConnection[] bconns, int maxPoolSize, int totalConnsCount) {
        int connectionsToCreate = 0;
        int averageConnections = totalConnsCount / (this.m_cardinality - 1);
        int poolSizeHeadRoom = maxPoolSize - totalConnsCount;
        connectionsToCreate = averageConnections <= poolSizeHeadRoom ? averageConnections : poolSizeHeadRoom;
        if (connectionsToCreate < averageConnections) {
            int connectionsTornDown;
            int targetAverageConnections = totalConnsCount / this.m_cardinality;
            this.m_targetTearDownConnCount = connectionsTornDown = this.tearDownConnections(aconns, bconns, targetAverageConnections);
            if (connectionsTornDown > 0) {
                connectionsToCreate = connectionsTornDown;
            }
        }
        return connectionsToCreate;
    }

    private int tearDownConnections(FailoverablePooledConnection[] aconns, FailoverablePooledConnection[] bconns, int targetAverageConnections) {
        OracleDatabaseInstanceInfo dbInstance;
        boolean _sucProcessingOneConn;
        int i;
        assert (aconns != null);
        assert (bconns != null);
        int _tornDownAvailConnCount = 0;
        int _markedToCloseCount = 0;
        for (i = 0; i < aconns.length; ++i) {
            _sucProcessingOneConn = true;
            dbInstance = this.m_dbInstanceInfoList.getOracleDatabaseInstanceInfo(aconns[i].getInstance(), aconns[i].getDatabase());
            if (dbInstance.getNumToTearDown() == -1) {
                dbInstance.setNumToTearDown(dbInstance.getNumberOfConnectionsCount() - targetAverageConnections);
            }
            if (dbInstance.getNumToTearDown() <= 0) continue;
            _sucProcessingOneConn = FailoverActionResult.FAILED != this.processFailoverAction(aconns[i], true, false, 0);
            boolean bl = _sucProcessingOneConn = _sucProcessingOneConn && FailoverActionResult.FAILED != this.processFailoverAction(aconns[i], true, false, 1);
            if (!_sucProcessingOneConn) continue;
            dbInstance.decrementNumToTearDown();
            ++_tornDownAvailConnCount;
        }
        this.m_tornDownConnCount += _tornDownAvailConnCount;
        for (i = 0; i < bconns.length; ++i) {
            _sucProcessingOneConn = true;
            dbInstance = this.m_dbInstanceInfoList.getOracleDatabaseInstanceInfo(bconns[i].getInstance(), bconns[i].getDatabase());
            if (dbInstance.getNumToTearDown() == -1) {
                dbInstance.setNumToTearDown(dbInstance.getNumberOfConnectionsCount() - targetAverageConnections);
            }
            if (dbInstance.getNumToTearDown() <= 0) continue;
            try {
                bconns[i].setStatus(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN);
            }
            catch (UniversalConnectionPoolException ucpe) {
                ClioSupport.ilogFinest(null, null, null, null, "Borrowed connection tearing failed when setting status " + this.getStackTraceString(ucpe));
                this.m_errorInfo.append(", ").append(ucpe.getStackTrace()[0].toString());
                _sucProcessingOneConn = false;
            }
            if (!_sucProcessingOneConn) continue;
            dbInstance.decrementNumToTearDown();
            ++_markedToCloseCount;
        }
        this.m_markedToCloseConnCount += _markedToCloseCount;
        ClioSupport.ilogFinest(null, null, null, null, String.format("available torn: %d, borrowed marked to close: %d", _tornDownAvailConnCount, _markedToCloseCount));
        return _tornDownAvailConnCount + _markedToCloseCount;
    }

    boolean failoverServiceEventMatch(FailoverablePooledConnection pooledConnection, String instanceName, String dbUniqueName, long evtTimestamp) {
        if (!this.olderWLSCompatible) {
            Date connTS = pooledConnection.getInstanceStartTime();
            ClioSupport.ilogFinest(null, null, null, null, String.format("INSTANCE START TIME: " + (null != connTS ? connTS.toString() : "null"), new Object[0]));
            if (connTS != null && connTS.getTime() > evtTimestamp) {
                ClioSupport.ilogFinest(null, null, null, null, "instance started after FAN event");
                return false;
            }
        }
        String pcDbUniqueName = pooledConnection.getDatabase();
        if (instanceName == null) {
            return pcDbUniqueName == null || dbUniqueName == null || dbUniqueName.equals(pcDbUniqueName);
        }
        String pcDataSourceInstanceName = pooledConnection.getInstance();
        if (pcDataSourceInstanceName == null || pcDbUniqueName == null) {
            return false;
        }
        return instanceName.equals(pcDataSourceInstanceName) && dbUniqueName.equals(pcDbUniqueName);
    }

    private boolean failoverHostEventMatch(FailoverablePooledConnection pooledConnection, String hostName, long evtTimestamp) {
        if (!this.olderWLSCompatible) {
            Date connTS = pooledConnection.getInstanceStartTime();
            ClioSupport.ilogFinest(null, null, null, null, String.format("INSTANCE START TIME: %t", connTS));
            if (connTS != null && connTS.getTime() > evtTimestamp) {
                ClioSupport.ilogFinest(null, null, null, null, "instance started after FAN event");
                return false;
            }
        }
        String pooledConnectionHostName = pooledConnection.getHost();
        return hostName != null && pooledConnectionHostName != null && hostName.equals(pooledConnectionHostName);
    }

    private void resetFCFInternalMetrics() {
        this.m_targetTearDownConnCount = 0;
        this.m_tornDownConnCount = 0;
        this.m_markedToCloseConnCount = 0;
        this.m_targetUpEventNewConnCount = 0;
        this.m_upEventNewConnCount = 0;
        int _len = this.m_errorInfo.length();
        this.m_errorInfo.delete(0, _len);
    }

    @DisableTrace
    String getStackTraceString(Throwable exc) {
        StringWriter stackTraceWriter = new StringWriter(1024);
        PrintWriter pw = new PrintWriter(stackTraceWriter);
        exc.printStackTrace(pw);
        return ((Object)stackTraceWriter).toString();
    }

    private void startONS(final String onsConfigStr) throws UniversalConnectionPoolException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public Object run() throws UniversalConnectionPoolException {
                    try {
                        RACManagerImpl.this.currentONS = new ONS(onsConfigStr);
                        ClioSupport.ilogFinest(null, null, null, null, String.format("ONS(%s) succeeded", Util.maskONSConfigurationString(onsConfigStr)));
                    }
                    catch (ONSException e) {
                        RACManagerImpl.this.currentONS = null;
                        throw UCPErrorHandler.newUniversalConnectionPoolException(308, e);
                    }
                    finally {
                        RACManagerImpl.this.calledStartONS = true;
                    }
                    return null;
                }

                static {
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredConstructor(RACManagerImpl.class, String.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
        catch (PrivilegedActionException onsexc) {
            this.currentONS = null;
            throw UCPErrorHandler.newUniversalConnectionPoolException(308, onsexc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws UniversalConnectionPoolException {
        if (this.m_state != 2) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(60);
        }
        this.olderWLSCompatible = Util.isPreWLS1212Compatible();
        String onsConfigurationString = this.m_onsConfigurationString.get();
        if ((onsConfigurationString == null || "".equals(onsConfigurationString)) && !this.olderWLSCompatible) {
            this.getAutoONSConfigurationFromServer();
        }
        if ((onsConfigurationString = this.m_onsConfigurationString.get()) != null && !"".equals(onsConfigurationString)) {
            this.startONS(onsConfigurationString);
        }
        AtomicReference<ONSDatabaseEventHandlerTask> atomicReference = this.m_failoverEventHandlerTask;
        synchronized (atomicReference) {
            if (this.m_failoverEventHandlerTask.get() != null) {
                this.stop();
            } else {
                this.m_failoverEventHandlerTask.set(new ONSDatabaseEventHandlerTask(this.m_serviceName.get(), this, this.m_taskManager));
            }
        }
        ONSDatabaseEventHandlerTask fcfTask = this.m_failoverEventHandlerTask.get();
        if (fcfTask != null) {
            fcfTask.setTerminate(false);
            try {
                fcfTask.start();
            }
            catch (RejectedExecutionException e) {
                throw new UniversalConnectionPoolException(e);
            }
        }
        this.m_state = 1;
        ClioSupport.ilogFine(null, null, null, null, "started");
    }

    private FailoverEventHandlerTask getFailoverEventHandlerTask() {
        return this.m_failoverEventHandlerTask.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws UniversalConnectionPoolException {
        if (this.m_state == 2) {
            ClioSupport.ilogFinest(null, null, null, null, "failover already stopped");
            return;
        }
        this.terminateRuntimeLoadBalancing();
        ONSDatabaseEventHandlerTask fcfTask = this.m_failoverEventHandlerTask.get();
        if (fcfTask != null) {
            fcfTask.setTerminate(true);
            fcfTask.waitTerminate();
        }
        AtomicReference<ONSDatabaseEventHandlerTask> atomicReference = this.m_failoverEventHandlerTask;
        synchronized (atomicReference) {
            this.m_failoverEventHandlerTask.set(null);
        }
        this.resetRACStatistics();
        this.olderWLSCompatible = false;
        if (this.currentONS != null) {
            this.currentONS.shutdown();
            this.currentONS = null;
            this.calledStartONS = false;
        }
        this.m_state = 2;
        ClioSupport.ilogFine(null, null, null, null, "stopped");
    }

    private void resetRACStatistics() {
        this.m_successfulAffinityBasedBorrowCount.set(0L);
        this.m_failedAffinityBasedBorrowCount.set(0L);
        this.m_successfulRCLBBasedBorrowCount.set(0L);
        this.m_failedRCLBBasedBorrowCount.set(0L);
        this.m_fcfProcessingInfo.set("");
        this.m_fcfProcessingInfoProcessedOnly.set("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFailoverEventHandlerTask(ONSDatabaseEventHandlerTask failoverEventHandlerTask) {
        AtomicReference<ONSDatabaseEventHandlerTask> atomicReference = this.m_failoverEventHandlerTask;
        synchronized (atomicReference) {
            this.m_failoverEventHandlerTask.set(failoverEventHandlerTask);
        }
    }

    @Override
    public void setFailoverInfo(Object info) throws UniversalConnectionPoolException {
        assert (false) : "internal error: this method must not be invoked";
    }

    void updateDatabaseInstanceInfo(Object info, boolean isForFailover, boolean isAddingConnection) throws UniversalConnectionPoolException {
        OracleDatabaseInstanceInfo dbi = (OracleDatabaseInstanceInfo)info;
        this.m_serviceName.compareAndSet(null, dbi.getServiceName());
        assert (this.m_dbInstanceInfoList != null);
        this.m_dbInstanceInfoList.updateDatabaseInstanceInfo(dbi, isForFailover, isAddingConnection);
    }

    @Override
    @DisableTrace
    public Object getFailoverInfo() {
        return this.m_dbInstanceInfoList;
    }

    @Override
    @DisableTrace
    public String getONSConfiguration() {
        return this.m_onsConfigurationString.get();
    }

    @Override
    public void setONSConfiguration(String onsConfigStr) throws UniversalConnectionPoolException {
        String oldOnsConfigStr;
        ClioSupport.ilogFinest(null, null, null, null, "onsConfigStr: " + Util.maskONSConfigurationString(onsConfigStr));
        if (onsConfigStr == null) {
            onsConfigStr = "";
        }
        if (onsConfigStr.equals(oldOnsConfigStr = this.m_onsConfigurationString.getAndSet(onsConfigStr))) {
            return;
        }
        if (this.m_state == 1) {
            this.stop();
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateFCFProcessingInfo(String fcfInfo) {
        AtomicReference<String> atomicReference = this.m_fcfProcessingInfo;
        synchronized (atomicReference) {
            this.m_fcfProcessingInfo.set(fcfInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateFCFProcessingInfoProcessedOnly(String fcfInfo) {
        AtomicReference<String> atomicReference = this.m_fcfProcessingInfoProcessedOnly;
        synchronized (atomicReference) {
            this.m_fcfProcessingInfoProcessedOnly.set(fcfInfo);
        }
    }

    @Override
    public void markDownConnectionsForDownEvent(FailoverablePooledConnection[] aconns, FailoverablePooledConnection[] bconns, OracleFailoverEvent failoverEvent) {
        this.processConnectionsForDownEvent(aconns, bconns, failoverEvent, 100);
    }

    @Override
    public void cleanupConnectionsForDownEvent(FailoverablePooledConnection[] aconns, FailoverablePooledConnection[] bconns, OracleFailoverEvent failoverEvent) {
        this.processConnectionsForDownEvent(aconns, bconns, failoverEvent, 200);
    }

    private void processConnectionsForDownEvent(FailoverablePooledConnection[] aconns, FailoverablePooledConnection[] bconns, OracleFailoverEvent failoverEvent, int actionFlag) {
        String status = failoverEvent.getStatus();
        String eventType = failoverEvent.getEventType();
        long eventTimestamp = failoverEvent.getTimestamp();
        ClioSupport.ilogFinest(null, null, null, null, String.format("status=%s, eventType=%s", status, eventType));
        if (eventType.equals("database/event/service")) {
            if (status.equalsIgnoreCase("down") || status.equalsIgnoreCase("not_restarting") || status.equalsIgnoreCase("restart_failed")) {
                boolean isPlannedDownEvent;
                String instanceName = failoverEvent.getInstanceName();
                String dbUniqueName = failoverEvent.getDbUniqueName();
                String reason = failoverEvent.getReason();
                boolean bl = isPlannedDownEvent = reason != null && reason.equals("user");
                if (actionFlag == 100) {
                    if (!this.m_isEntireServiceDownProcessed) {
                        this.currentEvent.availMarked = this.processConnectionsForServiceDown(aconns, true, instanceName, dbUniqueName, isPlannedDownEvent, eventTimestamp, 0);
                        this.currentEvent.borrowedMarked = this.processConnectionsForServiceDown(bconns, false, instanceName, dbUniqueName, isPlannedDownEvent, eventTimestamp, 0);
                        if (instanceName == null) {
                            this.m_isEntireServiceDownProcessed = false;
                        }
                    }
                } else if (actionFlag == 200) {
                    boolean isFCFSuccessful;
                    this.currentEvent.availConns = aconns == null ? 0 : aconns.length;
                    int n = this.currentEvent.borrowedConns = bconns == null ? 0 : bconns.length;
                    if (!isPlannedDownEvent) {
                        this.currentEvent.borrowedClosed = this.processConnectionsForServiceDown(bconns, false, instanceName, dbUniqueName, isPlannedDownEvent, eventTimestamp, 1);
                    }
                    this.currentEvent.availClosed = this.processConnectionsForServiceDown(aconns, true, instanceName, dbUniqueName, isPlannedDownEvent, eventTimestamp, 1);
                    assert (this.m_dbInstanceInfoList != null);
                    this.m_dbInstanceInfoList.markDownInstanceForServiceDownEvent(instanceName, dbUniqueName);
                    this.currentEvent.reason = reason;
                    this.currentEvent.successful = isFCFSuccessful = this.currentEvent.availClosed.failed == 0 && this.currentEvent.borrowedClosed.failed == 0 && this.m_errorInfo.length() == 0;
                    ClioSupport.ilogFinest(null, null, null, null, "Fast Connection Failover " + (isFCFSuccessful ? "succeeded" : "failed"));
                }
            } else {
                ClioSupport.ilogFinest(null, null, null, null, "The down event is invalid and not processed.");
            }
        } else if (eventType.equals("database/event/host") && status.equalsIgnoreCase("nodedown")) {
            String hostName = failoverEvent.getHostName();
            if (actionFlag == 100) {
                this.currentEvent.availMarked = this.processConnectionsForHostDown(aconns, true, hostName, eventTimestamp, 0);
                this.currentEvent.borrowedMarked = this.processConnectionsForHostDown(bconns, false, hostName, eventTimestamp, 0);
            } else if (actionFlag == 200) {
                boolean isFCFSuccessful;
                this.currentEvent.availConns = aconns == null ? 0 : aconns.length;
                this.currentEvent.borrowedConns = bconns == null ? 0 : bconns.length;
                this.currentEvent.borrowedClosed = this.processConnectionsForHostDown(bconns, false, hostName, eventTimestamp, 1);
                this.currentEvent.availClosed = this.processConnectionsForHostDown(aconns, true, hostName, eventTimestamp, 1);
                assert (this.m_dbInstanceInfoList != null);
                this.m_dbInstanceInfoList.markDownInstanceForHostDownEvent(hostName);
                this.currentEvent.successful = isFCFSuccessful = this.currentEvent.availClosed.failed == 0 && this.currentEvent.borrowedClosed.failed == 0 && this.m_errorInfo.length() == 0;
                ClioSupport.ilogFinest(null, null, null, null, "Fast Connection Failover " + (isFCFSuccessful ? "succeeded" : "failed"));
            }
        } else {
            ClioSupport.ilogFinest(null, null, null, null, "Invalid Event received " + eventType);
        }
    }

    @Override
    public synchronized void registerRACCallback(RACCallback cbk) {
        this.m_cbk = new RACCallbackGuard(cbk);
    }

    @Override
    public synchronized void unregisterRACCallback(RACCallback cbk) {
        if (this.m_cbk == cbk) {
            this.m_cbk = null;
        }
    }

    public synchronized RACCallbackGuard getRACCallback() {
        return this.m_cbk;
    }

    @Override
    public void connectionOpened(FailoverablePooledConnection fpc) throws UniversalConnectionPoolException {
        OracleDatabaseInstanceInfo tmpInstance = new OracleDatabaseInstanceInfo(fpc.getDatabase(), fpc.getInstance(), fpc.getHost());
        tmpInstance.setServiceName(fpc.getService());
        tmpInstance.setId(fpc.getInstanceNumber());
        this.updateDatabaseInstanceInfo(tmpInstance, true, true);
        if (this.m_state == 1 && !this.isRuntimeLoadBalancingEnabled()) {
            this.setRuntimeLoadBalancingEnabled(true);
            this.setDatabaseVersion(fpc.getDatabaseVersion());
        }
    }

    @Override
    public void connectionClosed(FailoverablePooledConnection fpc) throws UniversalConnectionPoolException {
        OracleDatabaseInstanceInfo tmpInstance = new OracleDatabaseInstanceInfo(fpc.getDatabase(), fpc.getInstance(), fpc.getHost());
        tmpInstance.setServiceName(fpc.getService());
        this.updateDatabaseInstanceInfo(tmpInstance, true, false);
        if (fpc.isNamedInstanceConnection()) {
            this.decrementNamedInstanceConnCount(tmpInstance);
        }
    }

    @Override
    @DisableTrace
    public String getFCFProcessingInfoProcessedOnly() {
        return this.m_fcfProcessingInfoProcessedOnly.get();
    }

    @Override
    @DisableTrace
    public String getFCFProcessingInfo() {
        return this.m_fcfProcessingInfo.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementNamedInstanceConnCount(OracleDatabaseInstanceInfo dbInfo) {
        RACManagerImpl rACManagerImpl = this;
        synchronized (rACManagerImpl) {
            OracleDatabaseInstanceInfo dbInstance = this.m_dbInstanceInfoList.getOracleDatabaseInstanceInfo(dbInfo.getInstanceName(), dbInfo.getDatabaseName());
            if (dbInstance.getNumNamedInstanceConns() > 0) {
                dbInstance.decrementNumNamedInstanceConns();
            }
        }
    }

    @Override
    public boolean isRuntimeLoadBalancingEnabled() {
        return this.m_runtimeLoadBalancingEnabled.get();
    }

    public synchronized void setRuntimeLoadBalancingEnabled(boolean RLBEnabled) throws UniversalConnectionPoolException {
        this.m_runtimeLoadBalancingEnabled.set(RLBEnabled);
        if (RLBEnabled) {
            this.initRuntimeLoadBalancing(this.m_serviceName.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void initRuntimeLoadBalancing(String serviceName) throws UniversalConnectionPoolException {
        AtomicReference<ONSRuntimeLBEventHandlerTask> atomicReference = this.m_rlbEventHandlerTask;
        synchronized (atomicReference) {
            if (this.m_rlbEventHandlerTask.get() == null) {
                this.m_rlbEventHandlerTask.set(new ONSRuntimeLBEventHandlerTask(this.m_serviceName.get(), this));
            }
        }
        try {
            this.m_rlbEventHandlerTask.get().start();
        }
        catch (RejectedExecutionException e) {
            throw new UniversalConnectionPoolException(e);
        }
        this.generateMixTable();
    }

    protected synchronized void terminateRuntimeLoadBalancing() throws UniversalConnectionPoolException {
        this.cleanupRLBTasks();
        this.setRuntimeLoadBalancingEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRuntimeLoadBalancingEventHandlerTask(ONSRuntimeLBEventHandlerTask rlbEventHandlerTask) {
        AtomicReference<ONSRuntimeLBEventHandlerTask> atomicReference = this.m_rlbEventHandlerTask;
        synchronized (atomicReference) {
            this.m_rlbEventHandlerTask.set(rlbEventHandlerTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDatabaseInstances() {
        assert (this.m_dbInstanceInfoList != null);
        this.m_dbInstanceInfoList.scheduleInstancesForGravitation(this.m_instancesToGravitateQueue);
        this.setRCLBMetricsPolicyEnabled(true);
        AtomicReference<OracleGravitateConnectionPoolTask> atomicReference = this.m_gravitatePoolTask;
        synchronized (atomicReference) {
            OracleGravitateConnectionPoolTask gravitatePoolTask = this.m_gravitatePoolTask.get();
            if (gravitatePoolTask != null && this.m_gravitateTaskBusy.get()) {
                ClioSupport.ilogFinest(null, null, null, null, "about to stop gravitate thread");
                gravitatePoolTask.stop();
            }
            this.m_gravitatePoolTask.set(new OracleGravitateConnectionPoolTask(this));
            this.m_gravitatePoolTask.get().start();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void gravitatePool() {
        this.m_gravitateTaskBusy.set(true);
        try {
            while (true) {
                ClioSupport.ilogFinest(null, null, null, null, "polling instance queue");
                OracleDatabaseInstanceInfo instanceToGravitate = this.m_instancesToGravitateQueue.poll(1L, TimeUnit.SECONDS);
                if (null == instanceToGravitate) {
                    ClioSupport.ilogFinest(null, null, null, null, "no more instances to retire");
                    return;
                }
                try {
                    this.getRACCallback().tearDownConnectionsForInstance(instanceToGravitate, instanceToGravitate.getConnsToTearDown());
                    continue;
                }
                finally {
                    instanceToGravitate.setRebalancingState(OracleDatabaseInstanceInfo.RebalancingState.SHRUNK);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
            return;
        }
        finally {
            this.m_gravitateTaskBusy.set(false);
            ClioSupport.ilogFinest(null, null, null, null, "gravitation done");
        }
    }

    @Override
    public FailoverablePooledConnection selectConnectionPerRCLBAndAffinity(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        ConnectionAffinityCallback cbk = this.getConnectionAffinityCallback();
        ClioSupport.ilogFinest(null, null, null, null, "affinityPolicy=" + (Object)((Object)cbk.getAffinityPolicy()));
        if (cbk.getAffinityPolicy() == ConnectionAffinityCallback.AffinityPolicy.DATA_BASED_AFFINITY) {
            return this.selectConnectionPerDataBasedAffinity(cri);
        }
        Object appAffinityContext = cbk.getConnectionAffinityContext();
        FailoverablePooledConnection pc = null;
        if (appAffinityContext == null) {
            ClioSupport.ilogFinest(null, null, null, null, "Application has no affinity context established");
            boolean isInstanceAffinityEnabled = cbk.getAffinityPolicy() == ConnectionAffinityCallback.AffinityPolicy.TRANSACTION_BASED_AFFINITY || this.rlbMetricsAccumulator.getReel().size() == 0;
            ClioSupport.ilogFinest(null, null, null, null, "isInstanceAffinityEnabled=" + isInstanceAffinityEnabled);
            pc = this.selectConnectionPerRCLB(cri);
            ClioSupport.ilogFinest(null, null, null, null, "Connection obtained based on RCLB: " + pc);
            if (pc != null) {
                OracleConnectionAffinityContext affinityContext = this.getUpdatedAffinityContextAfterRCLB(pc, isInstanceAffinityEnabled);
                if (affinityContext != null) {
                    cbk.setConnectionAffinityContext(affinityContext.clone());
                }
                ClioSupport.ilogFinest(null, null, null, null, "Application affinity context: " + affinityContext);
            }
        } else {
            OracleConnectionAffinityContext updatedAffinityContext;
            ClioSupport.ilogFinest(null, null, null, null, "Application has affinity context established");
            OracleConnectionAffinityContext affinityContext = (OracleConnectionAffinityContext)appAffinityContext;
            boolean isInstanceAffinityEnabled = affinityContext.isForInstanceAffinity();
            String instanceName = affinityContext.getInstanceName();
            String dbUniqName = affinityContext.getDatabaseUniqueName();
            String serviceName = affinityContext.getServiceName();
            boolean affinityValue = false;
            if (!isInstanceAffinityEnabled) {
                String instanceKey = this.generateDatabaseInstanceKey(instanceName, dbUniqName, serviceName);
                affinityValue = this.getConnectionAffinityValue(instanceKey);
            }
            if (isInstanceAffinityEnabled || affinityValue) {
                ClioSupport.ilogFinest(null, null, null, null, (isInstanceAffinityEnabled ? "Database instance" : "Temporal") + " affinity");
                ClioSupport.ilogFinest(null, null, null, null, "use application's affinityContext: " + affinityContext.toString());
                pc = this.getRACCallback().getAvailableConnectionToInstance(cri, new RACInstanceImpl(serviceName, instanceName, "", dbUniqName));
                ClioSupport.ilogFinest(null, null, null, null, "Connection found matching affinity context: " + pc);
                if (pc == null) {
                    ClioSupport.ilogFinest(null, null, null, null, "Affinity contexts match but no connection available to " + affinityContext.toString());
                    pc = this.getConnectionToNamedInstance(instanceName, dbUniqName, isInstanceAffinityEnabled);
                    ClioSupport.ilogFinest(null, null, null, null, "Connection obtained to named instance: " + pc);
                    if (pc == null) {
                        if (Util.isAffinityStrict() || cbk.getAffinityPolicy() == ConnectionAffinityCallback.AffinityPolicy.WEBSESSION_BASED_AFFINITY && this.isStrictWSAffinity || cbk.getAffinityPolicy() == ConnectionAffinityCallback.AffinityPolicy.TRANSACTION_BASED_AFFINITY && this.isStrictXAAffinity) {
                            ClioSupport.ilogFinest(null, null, null, null, "unable to follow affinity strictly, setting affinity context to null");
                            cbk.setConnectionAffinityContext(null);
                        } else {
                            pc = this.selectConnectionPerRCLB(cri);
                            ClioSupport.ilogFinest(null, null, null, null, "Connection obtained based on RCLB: " + pc);
                            if (pc != null) {
                                updatedAffinityContext = this.getUpdatedAffinityContextAfterRCLB(pc, isInstanceAffinityEnabled);
                                if (!isInstanceAffinityEnabled) {
                                    cbk.setConnectionAffinityContext(updatedAffinityContext);
                                    ClioSupport.ilogFinest(null, null, null, null, "Temporal affinity. Application affinity context is updated: " + updatedAffinityContext);
                                }
                            }
                        }
                        this.incrementFailedAffinityBasedBorrowCount();
                    } else {
                        this.incrementSuccessfulAffinityBasedBorrowCount();
                    }
                } else {
                    this.incrementSuccessfulAffinityBasedBorrowCount();
                }
            } else {
                pc = this.selectConnectionPerRCLB(cri);
                ClioSupport.ilogFinest(null, null, null, null, "Connection obtained based on RCLB: " + pc);
                if (pc != null) {
                    updatedAffinityContext = this.getUpdatedAffinityContextAfterRCLB(pc, false);
                    cbk.setConnectionAffinityContext(updatedAffinityContext);
                    ClioSupport.ilogFinest(null, null, null, null, "Temporal affinity miss. Application affinity context is updated: " + updatedAffinityContext);
                }
                this.incrementFailedAffinityBasedBorrowCount();
            }
        }
        return pc;
    }

    private OracleConnectionAffinityContext getUpdatedAffinityContextAfterRCLB(FailoverablePooledConnection fpc, boolean isInstanceAffinityEnabled) {
        boolean needToCreateAffinityContext = true;
        String instanceName = fpc.getInstance();
        String dbName = fpc.getDatabase();
        String serviceName = fpc.getService();
        if (!isInstanceAffinityEnabled) {
            ClioSupport.ilogFinest(null, null, null, null, "Checking affinity hint for this instance");
            String instanceKey = this.generateDatabaseInstanceKey(instanceName, dbName, serviceName);
            if (!this.getConnectionAffinityValue(instanceKey)) {
                needToCreateAffinityContext = false;
            }
        }
        if (needToCreateAffinityContext) {
            ClioSupport.ilogFinest(null, null, null, null, "Creating temporary updated affinity context");
            OracleConnectionAffinityContext updatedAffinityContext = new OracleConnectionAffinityContext();
            updatedAffinityContext.setConnectionPoolID(this.getRACCallback().getPoolName());
            updatedAffinityContext.setInstanceName(instanceName);
            updatedAffinityContext.setDatabaseUniqueName(dbName);
            updatedAffinityContext.setServiceName(serviceName);
            if (isInstanceAffinityEnabled) {
                ClioSupport.ilogFinest(null, null, null, null, "New context is for instance affinity");
                updatedAffinityContext.setForInstanceAffinity(true);
            }
            ClioSupport.ilogFinest(null, null, null, null, "New Affinity context created: " + updatedAffinityContext);
            return updatedAffinityContext;
        }
        ClioSupport.ilogFinest(null, null, null, null, "Temporal Affinity hint is false");
        return null;
    }

    private FailoverablePooledConnection getConnectionToNamedInstance(String instanceName, String dbUniqName, boolean isInstanceAffinityEnabled) {
        FailoverablePooledConnection fpc = null;
        if (this.m_dbInstanceInfoList.isNamedInstanceConnectingAllowed(instanceName, dbUniqName, isInstanceAffinityEnabled)) {
            ClioSupport.ilogFinest(null, null, null, null, "named instance connecting allowed");
            OracleDatabaseInstanceInfo dbInstance = this.m_dbInstanceInfoList.getOracleDatabaseInstanceInfo(instanceName, dbUniqName);
            String namedInstanceUrl = dbInstance.getNamedInstanceUrl();
            try {
                RACInstanceImpl racInstance = new RACInstanceImpl(dbInstance);
                fpc = this.getRACCallback().openNewConnection(namedInstanceUrl, racInstance);
            }
            catch (Exception exc) {
                fpc = null;
                ClioSupport.ilogThrowing(null, null, null, null, exc);
            }
            if (fpc != null) {
                fpc.setAsNamedInstanceConnection();
                dbInstance.incrementNumNamedInstanceConns();
            }
        } else {
            ClioSupport.ilogFinest(null, null, null, null, "named instance connecting disallowed");
        }
        return fpc;
    }

    protected FailoverablePooledConnection selectConnectionPerDataBasedAffinity(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        DataBasedConnectionAffinityCallback cbk = (DataBasedConnectionAffinityCallback)this.getConnectionAffinityCallback();
        int partitionId = cbk.getPartitionId();
        Object pc = null;
        if (partitionId < 0) {
            ClioSupport.ilogFinest(null, null, null, null, "Callback returns incorrect partition-id.");
        } else {
            ClioSupport.ilogFinest(null, null, null, null, "Callback returns partition-id: " + partitionId);
            int configuredInstCardinality = 128;
            int size = this.m_dbInstanceInfoList.size();
            if (size > 128) {
                ClioSupport.ilogFinest(null, null, null, null, String.format("data affinity is disabled, cardinality>128 (%d)", size));
            }
            while (true) {
                int instanceId = (partitionId %= 4096) % 128;
                OracleDatabaseInstanceInfo dbInstance = this.m_dbInstanceInfoList.getOracleDatabaseInstanceInfo(instanceId);
                ClioSupport.ilogFinest(null, null, null, null, String.format("Partition-id=%d, dbInstance=%s", partitionId, dbInstance));
                if (dbInstance == null) {
                    partitionId = this.m_mixTable[partitionId];
                    ClioSupport.ilogFinest(null, null, null, null, "Bad instance, dbinfo == null in table, remap to partition-id:" + partitionId);
                    continue;
                }
                OracleDatabaseInstanceInfoList.INSTANCE_CATEGORY_FOR_DATA_AFFINITY instanceCategory = this.m_dbInstanceInfoList.getInstanceCategory(dbInstance);
                String instanceName = dbInstance.getInstanceName();
                String dbUniqName = dbInstance.getDatabaseName();
                String serviceName = dbInstance.getServiceName();
                switch (instanceCategory) {
                    case GOOD_INSTANCE: {
                        ClioSupport.ilogFinest(null, null, null, null, "Data-based affinity. Found good instance based on partition-id.");
                        ClioSupport.ilogFinest(null, null, null, null, "Partition-id=" + partitionId);
                        ClioSupport.ilogFinest(null, null, null, null, String.format("Good instance: instance=%s, service=%s, db=%s", instanceName, serviceName, dbUniqName));
                        RACInstanceImpl racInstance = new RACInstanceImpl(serviceName, instanceName, "", dbUniqName);
                        pc = this.getRACCallback().getAvailableConnectionToInstance(cri, racInstance);
                        ClioSupport.ilogFinest(null, null, null, null, "Available connection found in chosen good instance: " + pc);
                        if (pc == null) {
                            ClioSupport.ilogFinest(null, null, null, null, String.format("Found good instance but no connection available to serviceName: %s, instanceName: %s, dbUniqueName: %s", serviceName, instanceName, dbUniqName));
                            pc = this.getConnectionToNamedInstance(instanceName, dbUniqName, true);
                            ClioSupport.ilogFinest(null, null, null, null, "Connection obtained to named instance: " + pc);
                            if (pc == null) {
                                pc = this.selectConnectionPerRCLB(cri);
                                ClioSupport.ilogFinest(null, null, null, null, "Connection obtained based on RCLB: " + pc);
                                this.incrementFailedAffinityBasedBorrowCount();
                                break;
                            }
                            this.incrementSuccessfulAffinityBasedBorrowCount();
                            break;
                        }
                        this.incrementSuccessfulAffinityBasedBorrowCount();
                        break;
                    }
                    case VIOLATING_INSTANCE: {
                        ClioSupport.ilogFinest(null, null, null, null, String.format("Violating instance: instance=%s, service=%s, db=%s", instanceName, serviceName, dbUniqName));
                        pc = this.selectConnectionPerRCLB(cri);
                        ClioSupport.ilogFinest(null, null, null, null, "Connection obtained based on RCLB: " + pc);
                        this.incrementFailedAffinityBasedBorrowCount();
                        break;
                    }
                    case BAD_INSTANCE: {
                        partitionId = this.m_mixTable[partitionId];
                        ClioSupport.ilogFinest(null, null, null, null, String.format("Bad instance, service: %s, instance: %s, db: %s; remap to partition-id: %d", serviceName, instanceName, dbUniqName, partitionId));
                    }
                }
                if (pc != null) break;
            }
        }
        ClioSupport.ilogFinest(null, null, null, null, "method returns connection: " + pc.toString());
        return pc;
    }

    private void generateMixTable() {
        if (this.m_mixTable != null) {
            return;
        }
        int[] alog = new int[4096];
        alog[0] = 1;
        for (int i = 1; i < 4096; ++i) {
            alog[i] = alog[i - 1] << 1 ^ alog[i - 1];
            if ((alog[i] & 0x1000) == 0) continue;
            int n = i;
            alog[n] = alog[n] ^ 0x1009;
        }
        int[] log = new int[4096];
        for (int i = 0; i < 4096; ++i) {
            log[alog[i]] = i;
        }
        log[0] = 4096;
        int[] mix = new int[4096];
        for (int i = 1; i < 4096; ++i) {
            mix[log[i - 1] - 1] = log[i] - 1;
        }
        mix[log[4095] - 1] = log[0] - 1;
        this.m_mixTable = mix;
    }

    private void destroyMixTable() {
        this.m_mixTable = null;
    }

    @Override
    public FailoverablePooledConnection selectConnectionPerRCLB(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        boolean useRLBMetricsPolicy;
        assert (this.m_dbInstanceInfoList != null);
        FailoverablePooledConnection pc = null;
        boolean bl = useRLBMetricsPolicy = this.isRCLBMetricsPolicyEnabled() && this.m_dbInstanceInfoList.size() > 0 && this.m_dbInstanceInfoList.useGoodGroup();
        if (useRLBMetricsPolicy) {
            pc = this.m_dbInstanceInfoList.selectConnectionPerRLBMetrics(cri, this);
        }
        if (!useRLBMetricsPolicy) {
            int i;
            Collection<FailoverablePooledConnection> conns = this.getRACCallback().getAvailableConnections(cri);
            if (conns == null || conns.size() == 0) {
                return null;
            }
            int sz = conns.size();
            int pos = this.m_rand.nextInt(sz);
            Iterator<FailoverablePooledConnection> iter = conns.iterator();
            for (i = 0; i < (pos + sz) % sz; ++i) {
                iter.next();
            }
            for (i = 0; i < sz; ++i) {
                FailoverablePooledConnection tmpPc;
                UniversalPooledConnectionStatus status;
                if (!iter.hasNext()) {
                    iter = conns.iterator();
                }
                if (!(status = (tmpPc = iter.next()).getStatus()).equals(UniversalPooledConnectionStatus.STATUS_NORMAL)) continue;
                pc = tmpPc;
                break;
            }
            this.incrementFailedRCLBBasedBorrowCount();
        }
        return pc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupRLBTasks() {
        AtomicReference<ProlongedTask> atomicReference = this.m_rlbEventHandlerTask;
        synchronized (atomicReference) {
            ONSRuntimeLBEventHandlerTask rlbEventHandlerTask = this.m_rlbEventHandlerTask.get();
            if (rlbEventHandlerTask != null) {
                rlbEventHandlerTask.setTerminate(true);
            }
        }
        atomicReference = this.m_gravitatePoolTask;
        synchronized (atomicReference) {
            ProlongedTask gravitatePoolTask = this.m_gravitatePoolTask.get();
            if (gravitatePoolTask != null) {
                gravitatePoolTask.stop();
                this.m_gravitatePoolTask.set(null);
            }
        }
        this.destroyMixTable();
    }

    @Override
    @DisableTrace
    public long getSuccessfulAffinityBasedBorrowCount() {
        return this.m_successfulAffinityBasedBorrowCount.get();
    }

    @Override
    @DisableTrace
    public long getFailedAffinityBasedBorrowCount() {
        return this.m_failedAffinityBasedBorrowCount.get();
    }

    @Override
    @DisableTrace
    public long getSuccessfulRCLBBasedBorrowCount() {
        return this.m_successfulRCLBBasedBorrowCount.get();
    }

    @Override
    @DisableTrace
    public long getFailedRCLBBasedBorrowCount() {
        return this.m_failedRCLBBasedBorrowCount.get();
    }

    public void incrementSuccessfulAffinityBasedBorrowCount() {
        this.m_successfulAffinityBasedBorrowCount.incrementAndGet();
    }

    protected void incrementFailedAffinityBasedBorrowCount() {
        this.m_failedAffinityBasedBorrowCount.incrementAndGet();
    }

    public void incrementSuccessfulRCLBBasedBorrowCount() {
        this.m_successfulRCLBBasedBorrowCount.incrementAndGet();
    }

    public void incrementFailedRCLBBasedBorrowCount() {
        this.m_failedRCLBBasedBorrowCount.incrementAndGet();
    }

    boolean isRCLBMetricsPolicyEnabled() {
        return this.m_rclbMetricsPolicyEnabled.get();
    }

    void setRCLBMetricsPolicyEnabled(boolean metricsPolicyEnabled) {
        this.m_rclbMetricsPolicyEnabled.set(metricsPolicyEnabled);
    }

    @DisableTrace
    public int getDatabaseVersion() {
        return this.m_dbVersion.get();
    }

    void setDatabaseVersion(int version) {
        this.m_dbVersion.compareAndSet(0, version);
    }

    @Override
    public void registerConnectionAffinityCallback(ConnectionAffinityCallback cbk) throws UniversalConnectionPoolException {
        this.m_connectionAffinityCallback = cbk;
    }

    @Override
    public void unregisterConnectionAffinityCallback(ConnectionAffinityCallback cbk) throws UniversalConnectionPoolException {
        this.m_connectionAffinityCallback = null;
        this.m_affinityMap.clear();
    }

    public synchronized ConnectionAffinityCallback getConnectionAffinityCallback() {
        return this.m_connectionAffinityCallback;
    }

    void setConnectionAffinityValue(String instanceKey, boolean newValue) {
        assert (instanceKey != null);
        this.m_affinityMap.put(instanceKey, newValue);
    }

    public boolean getConnectionAffinityValue(String instanceKey) {
        assert (instanceKey != null);
        Boolean lookupValue = this.m_affinityMap.get(instanceKey);
        if (lookupValue == null) {
            ClioSupport.ilogFinest(null, null, null, null, "instance/context not in map, lookup returns null");
        }
        return lookupValue != null ? lookupValue : false;
    }

    public String generateDatabaseInstanceKey(String instanceName, String dbName, String serviceName) {
        return instanceName + "##" + dbName + "##" + serviceName;
    }

    void handleLoadBalancingEvent(OracleLoadBalancingEvent rlbEvent) throws UniversalConnectionPoolException {
        this.rlbMetricsAccumulator.newEvent(rlbEvent.getServiceName(), rlbEvent.getEventBody(), this.m_dbInstanceInfoList.getRacMetadata());
        for (OracleDatabaseInstanceInfo instanceInfo : this.m_dbInstanceInfoList.getAllInstances()) {
            if (OracleDatabaseInstanceInfo.RebalancingState.SHRINKING == instanceInfo.getRebalancingState()) continue;
            instanceInfo.setRebalancingState(OracleDatabaseInstanceInfo.RebalancingState.QUIESCENT);
        }
        ClioSupport.ilogFinest(null, null, null, null, this.rlbMetricsAccumulator.toString(1));
        MetricsAccumulator.Frame frame = this.rlbMetricsAccumulator.getPreviousFrame();
        if (null != frame) {
            int totalConns = 0;
            for (MetricsAccumulator.InstanceStats stats : frame.distribution.values()) {
                totalConns += stats.getConnsTotal();
            }
            ClioSupport.ilogFinest(null, null, null, null, String.format("serviceName=%s, eventBody=%s", rlbEvent.getServiceName(), new String(rlbEvent.getEventBody())));
            for (String inst : frame.distribution.keySet()) {
                MetricsAccumulator.InstanceStats instStats = frame.distribution.get(inst);
                if (null == instStats) continue;
                float percentTotals = (float)instStats.getConnsTotal() / (float)totalConns * 100.0f;
                float percentLoad = (float)instStats.getConnsBorrowed() / (float)frame.totalBorrowed * 100.0f;
                float percentAdvisory = instStats.getAdvisoryPercent();
                ClioSupport.ilogFinest(null, null, null, null, " -- " + inst + " #c=" + instStats.getConnsTotal() + " (" + percentTotals + "%)" + " load=" + percentLoad + "%" + " ONS=" + percentAdvisory + '%' + " (new=" + instStats.getConnsCreated() + ", closed=" + instStats.getConnsClosed() + ')');
            }
        }
        String instNameKey = null;
        String dbUniqNameKey = null;
        boolean isInstanceAffinityEnabled = false;
        ConnectionAffinityCallback cbk = this.getConnectionAffinityCallback();
        isInstanceAffinityEnabled = cbk != null ? cbk.getAffinityPolicy() == ConnectionAffinityCallback.AffinityPolicy.TRANSACTION_BASED_AFFINITY : false;
        Set<RACInstance> racInstances = rlbEvent.getRACInstances();
        for (RACInstance racInstance : racInstances) {
            instNameKey = racInstance.getInstance();
            dbUniqNameKey = racInstance.getDatabase();
            OracleDatabaseInstanceInfo tmpInstance = new OracleDatabaseInstanceInfo(dbUniqNameKey, instNameKey);
            tmpInstance.setAdvisoryPercent(this.olderWLSCompatible ? (float)racInstance.getPercent() : racInstance.getFloatPercent());
            tmpInstance.flag = racInstance.getInstanceStatus().ordinal() + 1;
            tmpInstance.setServiceName(this.m_serviceName.get());
            this.updateDatabaseInstanceInfo(tmpInstance, false, false);
            if (isInstanceAffinityEnabled) continue;
            String instanceKey = this.generateDatabaseInstanceKey(instNameKey, dbUniqNameKey, this.m_serviceName.get());
            this.setConnectionAffinityValue(instanceKey, ((RACInstanceImpl)racInstance).getAffinityHint());
        }
        if (null != this.rlbMetricsAccumulator.getPreviousFrame()) {
            this.processDatabaseInstances();
        }
        this.getRACCallback().lbaEventOccurred(rlbEvent);
    }

    TaskManager getTaskManager() {
        return this.m_taskManager;
    }

    @Override
    public RACInstance getMostDesirableInstanceToGrow() {
        return this.m_dbInstanceInfoList.getMostDesirableInstanceToGrow();
    }

    @Override
    public RACAffinityContext createRACAffinityContext(String service, String dbUniqName, String instance, String version, RACAffinityContext.AffinityType affinityType) {
        OracleConnectionAffinityContext context = new OracleConnectionAffinityContext();
        context.setServiceName(service);
        context.setDatabaseUniqueName(dbUniqName);
        context.setInstanceName(instance);
        context.setVersionNumber(version);
        context.setForInstanceAffinity(affinityType == RACAffinityContext.AffinityType.TRANSACTION_BASED_AFFINITY);
        return context;
    }

    protected void getAutoONSConfigurationFromServer() throws UniversalConnectionPoolException {
        FailoverablePooledConnection fpc = null;
        try {
            fpc = this.getRACCallback().openNewConnection(null, null);
            if (fpc != null) {
                ClioSupport.ilogFinest(null, null, null, null, "got new physical connection: " + fpc);
                Properties props = fpc.getConnectionInfo();
                String val = props.getProperty("AUTH_ONS_CONFIG");
                if (val != null && !val.equals("")) {
                    ClioSupport.ilogFinest(null, null, null, null, "ONS auto-config: " + val);
                    this.setONSConfiguration(val.trim());
                } else {
                    ClioSupport.ilogFinest(null, null, null, null, "ONS auto-config: null");
                }
            } else {
                ClioSupport.ilogFinest(null, null, null, null, "got null physical connection");
            }
        }
        catch (Throwable throwable) {
            ClioSupport.ilogFinest(null, null, null, null, "Getting ONS auto-config failed: " + this.getStackTraceString(throwable));
            throw UCPErrorHandler.newUniversalConnectionPoolException(313, throwable);
        }
        finally {
            if (fpc != null) {
                try {
                    fpc.abort();
                    fpc.close(false);
                    ClioSupport.ilogFinest(null, null, null, null, "closed physical connection: " + fpc);
                }
                catch (UniversalConnectionPoolException exc) {
                    ClioSupport.ilogFinest(null, null, null, null, "connection cleanup failed after getting ONS auto-config:");
                    exc.printStackTrace();
                }
            }
        }
    }

    protected ONS getONS() throws UniversalConnectionPoolException {
        if (this.calledStartONS && this.currentONS == null && !"".equals(this.getONSConfiguration())) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(312);
        }
        return this.currentONS;
    }

    @Override
    public ShardManager createShardManager() throws UniversalConnectionPoolException {
        return new ShardManagerImpl(this.getONS());
    }

    static {
        try {
            $$$methodRef$$$69 = RACManagerImpl.class.getDeclaredConstructor(TaskManager.class, TimerManager.class, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$69 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$68 = RACManagerImpl.class.getDeclaredMethod("createShardManager", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$68 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$67 = RACManagerImpl.class.getDeclaredMethod("getONS", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$67 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$66 = RACManagerImpl.class.getDeclaredMethod("getAutoONSConfigurationFromServer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$66 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$65 = RACManagerImpl.class.getDeclaredMethod("createRACAffinityContext", String.class, String.class, String.class, String.class, RACAffinityContext.AffinityType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$65 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$64 = RACManagerImpl.class.getDeclaredMethod("getMostDesirableInstanceToGrow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$64 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$63 = RACManagerImpl.class.getDeclaredMethod("getTaskManager", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$62 = RACManagerImpl.class.getDeclaredMethod("handleLoadBalancingEvent", OracleLoadBalancingEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$61 = RACManagerImpl.class.getDeclaredMethod("generateDatabaseInstanceKey", String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$60 = RACManagerImpl.class.getDeclaredMethod("getConnectionAffinityValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$59 = RACManagerImpl.class.getDeclaredMethod("setConnectionAffinityValue", String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$58 = RACManagerImpl.class.getDeclaredMethod("getConnectionAffinityCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$57 = RACManagerImpl.class.getDeclaredMethod("unregisterConnectionAffinityCallback", ConnectionAffinityCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$56 = RACManagerImpl.class.getDeclaredMethod("registerConnectionAffinityCallback", ConnectionAffinityCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$55 = RACManagerImpl.class.getDeclaredMethod("setDatabaseVersion", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$54 = RACManagerImpl.class.getDeclaredMethod("setRCLBMetricsPolicyEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$53 = RACManagerImpl.class.getDeclaredMethod("isRCLBMetricsPolicyEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$52 = RACManagerImpl.class.getDeclaredMethod("incrementFailedRCLBBasedBorrowCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$51 = RACManagerImpl.class.getDeclaredMethod("incrementSuccessfulRCLBBasedBorrowCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$50 = RACManagerImpl.class.getDeclaredMethod("incrementFailedAffinityBasedBorrowCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$49 = RACManagerImpl.class.getDeclaredMethod("incrementSuccessfulAffinityBasedBorrowCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$48 = RACManagerImpl.class.getDeclaredMethod("cleanupRLBTasks", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$47 = RACManagerImpl.class.getDeclaredMethod("selectConnectionPerRCLB", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$46 = RACManagerImpl.class.getDeclaredMethod("destroyMixTable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$45 = RACManagerImpl.class.getDeclaredMethod("generateMixTable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$44 = RACManagerImpl.class.getDeclaredMethod("selectConnectionPerDataBasedAffinity", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$43 = RACManagerImpl.class.getDeclaredMethod("getConnectionToNamedInstance", String.class, String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$42 = RACManagerImpl.class.getDeclaredMethod("getUpdatedAffinityContextAfterRCLB", FailoverablePooledConnection.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$41 = RACManagerImpl.class.getDeclaredMethod("selectConnectionPerRCLBAndAffinity", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$40 = RACManagerImpl.class.getDeclaredMethod("gravitatePool", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$39 = RACManagerImpl.class.getDeclaredMethod("processDatabaseInstances", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$38 = RACManagerImpl.class.getDeclaredMethod("setRuntimeLoadBalancingEventHandlerTask", ONSRuntimeLBEventHandlerTask.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$37 = RACManagerImpl.class.getDeclaredMethod("terminateRuntimeLoadBalancing", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$36 = RACManagerImpl.class.getDeclaredMethod("initRuntimeLoadBalancing", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$35 = RACManagerImpl.class.getDeclaredMethod("setRuntimeLoadBalancingEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$34 = RACManagerImpl.class.getDeclaredMethod("isRuntimeLoadBalancingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$33 = RACManagerImpl.class.getDeclaredMethod("decrementNamedInstanceConnCount", OracleDatabaseInstanceInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$32 = RACManagerImpl.class.getDeclaredMethod("connectionClosed", FailoverablePooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$31 = RACManagerImpl.class.getDeclaredMethod("connectionOpened", FailoverablePooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$30 = RACManagerImpl.class.getDeclaredMethod("getRACCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$29 = RACManagerImpl.class.getDeclaredMethod("unregisterRACCallback", RACCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$28 = RACManagerImpl.class.getDeclaredMethod("registerRACCallback", RACCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$27 = RACManagerImpl.class.getDeclaredMethod("processConnectionsForDownEvent", FailoverablePooledConnection[].class, FailoverablePooledConnection[].class, OracleFailoverEvent.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$26 = RACManagerImpl.class.getDeclaredMethod("cleanupConnectionsForDownEvent", FailoverablePooledConnection[].class, FailoverablePooledConnection[].class, OracleFailoverEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$25 = RACManagerImpl.class.getDeclaredMethod("markDownConnectionsForDownEvent", FailoverablePooledConnection[].class, FailoverablePooledConnection[].class, OracleFailoverEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$24 = RACManagerImpl.class.getDeclaredMethod("updateFCFProcessingInfoProcessedOnly", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$23 = RACManagerImpl.class.getDeclaredMethod("updateFCFProcessingInfo", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$22 = RACManagerImpl.class.getDeclaredMethod("setONSConfiguration", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$21 = RACManagerImpl.class.getDeclaredMethod("updateDatabaseInstanceInfo", Object.class, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$20 = RACManagerImpl.class.getDeclaredMethod("setFailoverInfo", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$19 = RACManagerImpl.class.getDeclaredMethod("setFailoverEventHandlerTask", ONSDatabaseEventHandlerTask.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$18 = RACManagerImpl.class.getDeclaredMethod("resetRACStatistics", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$17 = RACManagerImpl.class.getDeclaredMethod("stop", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$16 = RACManagerImpl.class.getDeclaredMethod("getFailoverEventHandlerTask", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$15 = RACManagerImpl.class.getDeclaredMethod("start", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$14 = RACManagerImpl.class.getDeclaredMethod("startONS", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$13 = RACManagerImpl.class.getDeclaredMethod("resetFCFInternalMetrics", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$12 = RACManagerImpl.class.getDeclaredMethod("failoverHostEventMatch", FailoverablePooledConnection.class, String.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$11 = RACManagerImpl.class.getDeclaredMethod("failoverServiceEventMatch", FailoverablePooledConnection.class, String.class, String.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$10 = RACManagerImpl.class.getDeclaredMethod("tearDownConnections", FailoverablePooledConnection[].class, FailoverablePooledConnection[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$9 = RACManagerImpl.class.getDeclaredMethod("getUpEventConnectionsToCreateCount", FailoverablePooledConnection[].class, FailoverablePooledConnection[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$8 = RACManagerImpl.class.getDeclaredMethod("processUpEvent2ndPhase", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$7 = RACManagerImpl.class.getDeclaredMethod("processServiceUpEvent", FailoverablePooledConnection[].class, FailoverablePooledConnection[].class, Integer.TYPE, Integer.TYPE, String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$6 = RACManagerImpl.class.getDeclaredMethod("processConnectionsForHostDown", FailoverablePooledConnection[].class, Boolean.TYPE, String.class, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$5 = RACManagerImpl.class.getDeclaredMethod("processFailoverAction", FailoverablePooledConnection.class, Boolean.TYPE, Boolean.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$4 = RACManagerImpl.class.getDeclaredMethod("processConnectionsForServiceDown", FailoverablePooledConnection[].class, Boolean.TYPE, String.class, String.class, Boolean.TYPE, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$3 = RACManagerImpl.class.getDeclaredMethod("processUpEvent", FailoverablePooledConnection[].class, FailoverablePooledConnection[].class, Integer.TYPE, Integer.TYPE, OracleFailoverEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$2 = RACManagerImpl.class.getDeclaredMethod("handleFailoverEvent", FailoverEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$1 = RACManagerImpl.class.getDeclaredMethod("validateHostDownEvent", OracleFailoverEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$0 = RACManagerImpl.class.getDeclaredMethod("validateServiceEvent", OracleFailoverEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
    }

    public static interface RACCallbackExtended
    extends RACCallback {
        public void tearDownConnectionsForInstance(OracleDatabaseInstanceInfo var1, int var2);
    }
}

