/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.tuners.stats;

import java.lang.reflect.Executable;
import java.util.Arrays;
import java.util.logging.Logger;
import oracle.ucp.tuners.stats.HistogramInsertionException;
import oracle.ucp.util.Pair;

public class Histogram {
    private final long min;
    private final long max;
    private final long step;
    private final long[] hist;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;

    public Histogram(long min, long max, long step) {
        this.min = min;
        this.max = max;
        this.step = step;
        this.hist = new long[(int)Math.ceil((max - min) / step)];
        Arrays.fill(this.hist, 0L);
        if (max <= min || step > max - min) {
            throw new IllegalArgumentException();
        }
    }

    public void insert(long data) throws HistogramInsertionException {
        if (data < this.min || data > this.max) {
            throw new HistogramInsertionException("data out of range");
        }
        int n = (int)((data - this.min) / this.step);
        this.hist[n] = this.hist[n] + 1L;
    }

    public Histogram add(Histogram anotherHist) {
        int len = this.hist.length;
        if (len != anotherHist.hist.length) {
            throw new IllegalArgumentException("incompatible histograms");
        }
        for (int i = 0; i < len; ++i) {
            int n = i;
            this.hist[n] = this.hist[n] + anotherHist.hist[i];
        }
        return this;
    }

    public Pair<Long, Long> computeEffectiveRange() {
        long maxValue = 0L;
        int indexMax = 0;
        for (int i = 0; i < this.hist.length; ++i) {
            if (this.hist[i] <= maxValue) continue;
            maxValue = this.hist[i] * (((long)i + this.min) * this.step);
            indexMax = i;
        }
        int leftBound = indexMax;
        for (int i = indexMax; i >= 0; --i) {
            if (this.hist[i] * (((long)i + this.min) * this.step) > maxValue / 2L) continue;
            leftBound = i;
            break;
        }
        int rightBound = indexMax;
        for (int i = indexMax; i < this.hist.length; ++i) {
            if (this.hist[i] * (((long)i + this.min) * this.step) > maxValue / 2L) continue;
            rightBound = i;
            break;
        }
        return new Pair<Long, Long>(this.min + (long)leftBound * this.step, this.min + (long)rightBound * this.step);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (long i = this.min; i < this.max; i += this.step) {
            sb.append(i).append(':').append(this.hist[(int)((i - this.min) / this.step)]);
            if (i >= this.max - this.step) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }

    static {
        try {
            $$$methodRef$$$4 = Histogram.class.getDeclaredConstructor(Long.TYPE, Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = Histogram.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = Histogram.class.getDeclaredMethod("computeEffectiveRange", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = Histogram.class.getDeclaredMethod("add", Histogram.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = Histogram.class.getDeclaredMethod("insert", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

