/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import java.util.Comparator;
import java.util.List;
import org.springframework.hateoas.config.HypermediaMappingInformation;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class HypermediaMappingInformationComparator
implements Comparator<HypermediaMappingInformation> {
    private final List<MediaType> mediaTypes;

    HypermediaMappingInformationComparator(List<MediaType> mediaTypes) {
        Assert.notNull(mediaTypes, (String)"MediaTypes must not be null!");
        this.mediaTypes = mediaTypes;
    }

    @Override
    public int compare(@Nullable HypermediaMappingInformation left, @Nullable HypermediaMappingInformation right) {
        for (MediaType mediaType : this.mediaTypes) {
            boolean rightSupports;
            boolean leftSupports = left != null && left.getMediaTypes().contains(mediaType);
            boolean bl = rightSupports = right != null && right.getMediaTypes().contains(mediaType);
            if (leftSupports && !rightSupports) {
                return -1;
            }
            if (leftSupports || !rightSupports) continue;
            return 1;
        }
        return 0;
    }
}

