/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.date4j;

import hirondelle.date4j.DateTime;
import java.util.Locale;
import java.util.TimeZone;

public final class Examples {
    public static void main(String ... aArgs) {
        Examples examples = new Examples();
        examples.currentDateTime();
        examples.currentDateTimeInCairo();
        examples.ageIfBornOnCertainDate();
        examples.optionsExpiry();
        examples.daysTillChristmas();
        examples.whenIs90DaysFromToday();
        examples.whenIs3Months5DaysFromToday();
        examples.hoursDifferenceBetweenParisAndPerth();
        examples.weeksSinceStart();
        examples.timeTillMidnight();
        examples.imitateISOFormat();
        examples.firstDayOfThisWeek();
        examples.jdkDatesSuctorial();
    }

    private static void log(Object aMsg) {
        System.out.println(String.valueOf(aMsg));
    }

    private void currentDateTime() {
        DateTime now = DateTime.now(TimeZone.getDefault());
        String result = now.format("YYYY-MM-DD hh:mm:ss");
        Examples.log("Current date-time in default time zone : " + result);
    }

    private void currentDateTimeInCairo() {
        DateTime now = DateTime.now(TimeZone.getTimeZone("Africa/Cairo"));
        String result = now.format("YYYY-MM-DD hh:mm:ss (WWWW)", Locale.getDefault());
        Examples.log("Current date-time in Cairo : " + result);
    }

    private void ageIfBornOnCertainDate() {
        DateTime today = DateTime.today(TimeZone.getDefault());
        DateTime birthdate = DateTime.forDateOnly(1995, 5, 16);
        int age = today.getYear() - birthdate.getYear();
        if (today.getDayOfYear() < birthdate.getDayOfYear()) {
            --age;
        }
        Examples.log("Age of someone born May 16, 1995 is : " + age);
    }

    private void optionsExpiry() {
        DateTime today = DateTime.today(TimeZone.getDefault());
        DateTime firstOfMonth = today.getStartOfMonth();
        int result = 0;
        result = firstOfMonth.getWeekDay() == 7 ? 21 : 21 - firstOfMonth.getWeekDay();
        DateTime thirdFriday = DateTime.forDateOnly(firstOfMonth.getYear(), firstOfMonth.getMonth(), result);
        Examples.log("The 3rd Friday of this month is : " + thirdFriday.format("YYYY-MM-DD"));
    }

    private void daysTillChristmas() {
        DateTime today = DateTime.today(TimeZone.getDefault());
        DateTime christmas = DateTime.forDateOnly(today.getYear(), 12, 25);
        int result = 0;
        if (!today.isSameDayAs(christmas)) {
            if (today.lt(christmas)) {
                result = today.numDaysFrom(christmas);
            } else if (today.gt(christmas)) {
                DateTime christmasNextYear = DateTime.forDateOnly(today.getYear() + 1, 12, 25);
                result = today.numDaysFrom(christmasNextYear);
            }
        }
        Examples.log("Number of days till Christmas : " + result);
    }

    private void whenIs90DaysFromToday() {
        DateTime today = DateTime.today(TimeZone.getDefault());
        Examples.log("90 days from today is : " + today.plusDays(90).format("YYYY-MM-DD"));
    }

    private void whenIs3Months5DaysFromToday() {
        DateTime today = DateTime.today(TimeZone.getDefault());
        DateTime result = today.plus(0, 3, 5, 0, 0, 0, 0, DateTime.DayOverflow.FirstDay);
        Examples.log("3 months and 5 days from today is : " + result.format("YYYY-MM-DD"));
    }

    private void hoursDifferenceBetweenParisAndPerth() {
        DateTime paris = DateTime.now(TimeZone.getTimeZone("Europe/Paris"));
        DateTime perth = DateTime.now(TimeZone.getTimeZone("Australia/Perth"));
        int result = perth.getHour() - paris.getHour();
        if (result < 0) {
            result += 24;
        }
        Examples.log("Numbers of hours difference between Paris and Perth : " + result);
    }

    private void weeksSinceStart() {
        DateTime today = DateTime.today(TimeZone.getDefault());
        DateTime startOfProject = DateTime.forDateOnly(2010, 9, 6);
        int result = today.getWeekIndex() - startOfProject.getWeekIndex();
        Examples.log("The number of weeks since Sep 6, 2010 : " + result);
    }

    private void timeTillMidnight() {
        DateTime now = DateTime.now(TimeZone.getDefault());
        DateTime midnight = now.plusDays(1).getStartOfDay();
        long result = now.numSecondsFrom(midnight);
        Examples.log("This many seconds till midnight : " + result);
    }

    private void imitateISOFormat() {
        DateTime now = DateTime.now(TimeZone.getDefault());
        Examples.log("Output using an ISO format: " + now.format("YYYY-MM-DDThh:mm:ss"));
    }

    private void firstDayOfThisWeek() {
        int SUNDAY;
        DateTime today;
        DateTime firstDayThisWeek = today = DateTime.today(TimeZone.getDefault());
        int todaysWeekday = today.getWeekDay();
        if (todaysWeekday > (SUNDAY = 1)) {
            int numDaysFromSunday = todaysWeekday - SUNDAY;
            firstDayThisWeek = today.minusDays(numDaysFromSunday);
        }
        Examples.log("The first day of this week is : " + firstDayThisWeek);
    }

    private void jdkDatesSuctorial() {
        DateTime today = DateTime.today(TimeZone.getDefault());
        DateTime jdkFirstPublished = DateTime.forDateOnly(1996, 1, 23);
        int result = today.getYear() - jdkFirstPublished.getYear();
        Examples.log("The number of years the JDK date-time API has been suctorial : " + result);
    }
}

