/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.workflow.form.task;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.exceptions.FormValidateException;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.group.InlongGroupApproveRequest;
import org.apache.inlong.manager.pojo.stream.InlongStreamApproveRequest;
import org.apache.inlong.manager.pojo.workflow.form.task.BaseTaskForm;

public class InlongGroupApproveForm
extends BaseTaskForm {
    public static final String FORM_NAME = "InlongGroupApproveForm";
    @ApiModelProperty(value="Inlong group approve info")
    private InlongGroupApproveRequest groupApproveInfo;
    @ApiModelProperty(value="All inlong stream info under the inlong group, including the sink info")
    private List<InlongStreamApproveRequest> streamApproveInfoList;
    @ApiModelProperty(value="Inlong group approve full info list")
    private List<GroupApproveFullRequest> groupApproveFullInfoList;

    @Override
    public void validate() throws FormValidateException {
        Preconditions.expectTrue((this.groupApproveInfo != null || CollectionUtils.isNotEmpty(this.groupApproveFullInfoList) ? 1 : 0) != 0, (String)"inlong group approve info is empty");
    }

    @Override
    public String getFormName() {
        return FORM_NAME;
    }

    @JsonIgnore
    public List<GroupApproveFullRequest> getApproveFullRequest() {
        ArrayList<GroupApproveFullRequest> result = new ArrayList<GroupApproveFullRequest>();
        if (this.groupApproveInfo != null) {
            result.add(new GroupApproveFullRequest(this.groupApproveInfo, this.streamApproveInfoList));
        }
        if (CollectionUtils.isNotEmpty(this.groupApproveFullInfoList)) {
            result.addAll(this.groupApproveFullInfoList);
        }
        return result;
    }

    public InlongGroupApproveRequest getGroupApproveInfo() {
        return this.groupApproveInfo;
    }

    public List<InlongStreamApproveRequest> getStreamApproveInfoList() {
        return this.streamApproveInfoList;
    }

    public List<GroupApproveFullRequest> getGroupApproveFullInfoList() {
        return this.groupApproveFullInfoList;
    }

    public void setGroupApproveInfo(InlongGroupApproveRequest groupApproveInfo) {
        this.groupApproveInfo = groupApproveInfo;
    }

    public void setStreamApproveInfoList(List<InlongStreamApproveRequest> streamApproveInfoList) {
        this.streamApproveInfoList = streamApproveInfoList;
    }

    public void setGroupApproveFullInfoList(List<GroupApproveFullRequest> groupApproveFullInfoList) {
        this.groupApproveFullInfoList = groupApproveFullInfoList;
    }

    @Override
    public String toString() {
        return "InlongGroupApproveForm(groupApproveInfo=" + this.getGroupApproveInfo() + ", streamApproveInfoList=" + this.getStreamApproveInfoList() + ", groupApproveFullInfoList=" + this.getGroupApproveFullInfoList() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlongGroupApproveForm)) {
            return false;
        }
        InlongGroupApproveForm other = (InlongGroupApproveForm)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InlongGroupApproveRequest this$groupApproveInfo = this.getGroupApproveInfo();
        InlongGroupApproveRequest other$groupApproveInfo = other.getGroupApproveInfo();
        if (this$groupApproveInfo == null ? other$groupApproveInfo != null : !((Object)this$groupApproveInfo).equals(other$groupApproveInfo)) {
            return false;
        }
        List<InlongStreamApproveRequest> this$streamApproveInfoList = this.getStreamApproveInfoList();
        List<InlongStreamApproveRequest> other$streamApproveInfoList = other.getStreamApproveInfoList();
        if (this$streamApproveInfoList == null ? other$streamApproveInfoList != null : !((Object)this$streamApproveInfoList).equals(other$streamApproveInfoList)) {
            return false;
        }
        List<GroupApproveFullRequest> this$groupApproveFullInfoList = this.getGroupApproveFullInfoList();
        List<GroupApproveFullRequest> other$groupApproveFullInfoList = other.getGroupApproveFullInfoList();
        return !(this$groupApproveFullInfoList == null ? other$groupApproveFullInfoList != null : !((Object)this$groupApproveFullInfoList).equals(other$groupApproveFullInfoList));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InlongGroupApproveForm;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InlongGroupApproveRequest $groupApproveInfo = this.getGroupApproveInfo();
        result = result * 59 + ($groupApproveInfo == null ? 43 : ((Object)$groupApproveInfo).hashCode());
        List<InlongStreamApproveRequest> $streamApproveInfoList = this.getStreamApproveInfoList();
        result = result * 59 + ($streamApproveInfoList == null ? 43 : ((Object)$streamApproveInfoList).hashCode());
        List<GroupApproveFullRequest> $groupApproveFullInfoList = this.getGroupApproveFullInfoList();
        result = result * 59 + ($groupApproveFullInfoList == null ? 43 : ((Object)$groupApproveFullInfoList).hashCode());
        return result;
    }

    public static class GroupApproveFullRequest {
        private InlongGroupApproveRequest groupApproveInfo;
        private List<InlongStreamApproveRequest> streamApproveInfoList;

        public static GroupApproveFullRequestBuilder builder() {
            return new GroupApproveFullRequestBuilder();
        }

        public InlongGroupApproveRequest getGroupApproveInfo() {
            return this.groupApproveInfo;
        }

        public List<InlongStreamApproveRequest> getStreamApproveInfoList() {
            return this.streamApproveInfoList;
        }

        public void setGroupApproveInfo(InlongGroupApproveRequest groupApproveInfo) {
            this.groupApproveInfo = groupApproveInfo;
        }

        public void setStreamApproveInfoList(List<InlongStreamApproveRequest> streamApproveInfoList) {
            this.streamApproveInfoList = streamApproveInfoList;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GroupApproveFullRequest)) {
                return false;
            }
            GroupApproveFullRequest other = (GroupApproveFullRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            InlongGroupApproveRequest this$groupApproveInfo = this.getGroupApproveInfo();
            InlongGroupApproveRequest other$groupApproveInfo = other.getGroupApproveInfo();
            if (this$groupApproveInfo == null ? other$groupApproveInfo != null : !((Object)this$groupApproveInfo).equals(other$groupApproveInfo)) {
                return false;
            }
            List<InlongStreamApproveRequest> this$streamApproveInfoList = this.getStreamApproveInfoList();
            List<InlongStreamApproveRequest> other$streamApproveInfoList = other.getStreamApproveInfoList();
            return !(this$streamApproveInfoList == null ? other$streamApproveInfoList != null : !((Object)this$streamApproveInfoList).equals(other$streamApproveInfoList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GroupApproveFullRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            InlongGroupApproveRequest $groupApproveInfo = this.getGroupApproveInfo();
            result = result * 59 + ($groupApproveInfo == null ? 43 : ((Object)$groupApproveInfo).hashCode());
            List<InlongStreamApproveRequest> $streamApproveInfoList = this.getStreamApproveInfoList();
            result = result * 59 + ($streamApproveInfoList == null ? 43 : ((Object)$streamApproveInfoList).hashCode());
            return result;
        }

        public String toString() {
            return "InlongGroupApproveForm.GroupApproveFullRequest(groupApproveInfo=" + this.getGroupApproveInfo() + ", streamApproveInfoList=" + this.getStreamApproveInfoList() + ")";
        }

        public GroupApproveFullRequest() {
        }

        public GroupApproveFullRequest(InlongGroupApproveRequest groupApproveInfo, List<InlongStreamApproveRequest> streamApproveInfoList) {
            this.groupApproveInfo = groupApproveInfo;
            this.streamApproveInfoList = streamApproveInfoList;
        }

        public static class GroupApproveFullRequestBuilder {
            private InlongGroupApproveRequest groupApproveInfo;
            private List<InlongStreamApproveRequest> streamApproveInfoList;

            GroupApproveFullRequestBuilder() {
            }

            public GroupApproveFullRequestBuilder groupApproveInfo(InlongGroupApproveRequest groupApproveInfo) {
                this.groupApproveInfo = groupApproveInfo;
                return this;
            }

            public GroupApproveFullRequestBuilder streamApproveInfoList(List<InlongStreamApproveRequest> streamApproveInfoList) {
                this.streamApproveInfoList = streamApproveInfoList;
                return this;
            }

            public GroupApproveFullRequest build() {
                return new GroupApproveFullRequest(this.groupApproveInfo, this.streamApproveInfoList);
            }

            public String toString() {
                return "InlongGroupApproveForm.GroupApproveFullRequest.GroupApproveFullRequestBuilder(groupApproveInfo=" + this.groupApproveInfo + ", streamApproveInfoList=" + this.streamApproveInfoList + ")";
            }
        }
    }
}

