/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth;

import java.io.IOException;
import java.util.Map;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.EncodedAuthenticationParameterSupport;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.auth.AuthenticationDataBasic;
import org.apache.pulsar.shade.com.google.gson.Gson;
import org.apache.pulsar.shade.com.google.gson.JsonObject;

public class AuthenticationBasic
implements Authentication,
EncodedAuthenticationParameterSupport {
    private String userId;
    private String password;

    public void close() throws IOException {
    }

    public String getAuthMethodName() {
        return "basic";
    }

    public AuthenticationDataProvider getAuthData() throws PulsarClientException {
        try {
            return new AuthenticationDataBasic(this.userId, this.password);
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public void configure(Map<String, String> authParams) {
        this.configure(new Gson().toJson(authParams));
    }

    public void configure(String encodedAuthParamString) {
        JsonObject params = new Gson().fromJson(encodedAuthParamString, JsonObject.class);
        this.userId = params.get("userId").getAsString();
        this.password = params.get("password").getAsString();
    }

    public void start() throws PulsarClientException {
    }
}

