/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sinks;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.inlong.agent.common.AgentThreadFactory;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.conf.OffsetProfile;
import org.apache.inlong.agent.core.task.MemoryManager;
import org.apache.inlong.agent.core.task.OffsetManager;
import org.apache.inlong.agent.message.EndMessage;
import org.apache.inlong.agent.message.file.OffsetAckInfo;
import org.apache.inlong.agent.message.file.ProxyMessage;
import org.apache.inlong.agent.message.file.SenderMessage;
import org.apache.inlong.agent.plugin.Message;
import org.apache.inlong.agent.plugin.MessageFilter;
import org.apache.inlong.agent.plugin.sinks.AbstractSink;
import org.apache.inlong.agent.plugin.sinks.dataproxy.Sender;
import org.apache.inlong.agent.plugin.sinks.dataproxy.SenderManager;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxySink
extends AbstractSink {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxySink.class);
    private final int LOOP_WAIT_TIME_MS = 10;
    public final int SAVE_OFFSET_INTERVAL_MS = 1000;
    public volatile long lastFlushOffset = AgentUtils.getCurrentTime();
    private static final ThreadPoolExecutor EXECUTOR_SERVICE = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new AgentThreadFactory("proxy-sink"));
    private MessageFilter messageFilter;
    private Sender sender;
    private byte[] fieldSplitter;
    private volatile boolean shutdown = false;
    private volatile boolean running = false;
    private volatile boolean inited = false;
    private long lastPrintTime = 0L;
    private List<OffsetAckInfo> ackInfoList = new ArrayList<OffsetAckInfo>();
    private final ReentrantReadWriteLock packageAckInfoLock = new ReentrantReadWriteLock(true);
    private volatile boolean offsetRunning = false;
    private OffsetManager offsetManager;

    public boolean write(Message message) {
        return this.putInCache(message);
    }

    private boolean putInCache(Message message) {
        try {
            if (message == null) {
                return true;
            }
            this.extractStreamFromMessage(message, this.fieldSplitter);
            if (message instanceof EndMessage) {
                this.sinkMetric.sinkFailCount.incrementAndGet();
                return true;
            }
            ProxyMessage proxyMessage = new ProxyMessage(message);
            boolean writerPermitSuc = MemoryManager.getInstance().tryAcquire("agent.global.writer.permit", message.getBody().length);
            if (!writerPermitSuc) {
                MemoryManager.getInstance().printDetail("agent.global.writer.permit", "proxy sink");
                return false;
            }
            boolean suc = this.cache.add(proxyMessage);
            if (suc) {
                this.addAckInfo(proxyMessage.getAckInfo());
            } else {
                MemoryManager.getInstance().release("agent.global.writer.permit", message.getBody().length);
                this.sinkMetric.sinkFailCount.incrementAndGet();
            }
            return suc;
        }
        catch (Exception e) {
            LOGGER.error("write message to Proxy sink error", (Throwable)e);
        }
        catch (Throwable t) {
            ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)t);
        }
        return false;
    }

    private void extractStreamFromMessage(Message message, byte[] fieldSplitter) {
        if (this.messageFilter != null) {
            message.getHeader().put("inlongStreamId", this.messageFilter.filterStreamId(message, fieldSplitter));
        }
    }

    private Runnable coreThread() {
        return () -> {
            AgentThreadFactory.nameThread((String)("flushCache-" + this.profile.getTaskId() + "-" + this.profile.getInstanceId()));
            LOGGER.info("start flush cache {}:{} flush interval {}", new Object[]{this.inlongGroupId, this.sourceName, this.batchFlushInterval});
            this.running = true;
            while (!this.shutdown) {
                try {
                    this.sendMessageFromCache();
                }
                catch (Throwable e) {
                    LOGGER.error("send message from cache error: ", e);
                }
                AgentUtils.silenceSleepInMs((long)this.batchFlushInterval);
            }
            LOGGER.info("stop flush cache {}:{}", (Object)this.inlongGroupId, (Object)this.sourceName);
            this.running = false;
        };
    }

    public void sendMessageFromCache() {
        ConcurrentHashMap messageQueueMap = this.cache.getMessageQueueMap();
        for (Map.Entry entry : messageQueueMap.entrySet()) {
            SenderMessage senderMessage = this.cache.fetchSenderMessage((String)entry.getKey(), (LinkedBlockingQueue)entry.getValue());
            if (senderMessage == null) continue;
            this.sender.sendBatch(senderMessage);
            if (AgentUtils.getCurrentTime() - this.lastPrintTime <= TimeUnit.SECONDS.toMillis(1L)) continue;
            this.lastPrintTime = AgentUtils.getCurrentTime();
            LOGGER.info("send groupId {}, streamId {}, message size {}, taskId {}, instanceId {} sendTime is {}", new Object[]{this.inlongGroupId, this.inlongStreamId, senderMessage.getDataList().size(), this.profile.getTaskId(), this.profile.getInstanceId(), senderMessage.getDataTime()});
        }
    }

    @Override
    public void init(InstanceProfile profile) {
        super.init(profile);
        this.fieldSplitter = profile.get("proxy.field.splitter", "|").getBytes(StandardCharsets.UTF_8);
        this.sourceName = profile.getInstanceId();
        this.offsetManager = OffsetManager.getInstance();
        this.sender = SenderManager.getInstance().getSender(profile.getTaskId(), profile);
        try {
            EXECUTOR_SERVICE.execute(this.coreThread());
            EXECUTOR_SERVICE.execute(this.flushOffset());
            this.inited = true;
        }
        catch (Throwable ex) {
            this.shutdown = true;
            LOGGER.error("error while init sender for group id {}", (Object)this.inlongGroupId);
            ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)ex);
            throw new IllegalStateException(ex);
        }
    }

    public void destroy() {
        LOGGER.info("destroy sink {}", (Object)this.sourceName);
        if (!this.inited) {
            return;
        }
        Long start = AgentUtils.getCurrentTime();
        this.shutdown = true;
        LOGGER.info("destroy proxySink, wait for sender close {} ms instance {}", (Object)(AgentUtils.getCurrentTime() - start), (Object)this.profile.getInstanceId());
        start = AgentUtils.getCurrentTime();
        while (this.running || this.offsetRunning) {
            AgentUtils.silenceSleepInMs((long)10L);
        }
        LOGGER.info("destroy proxySink, wait for run close {} ms instance {}", (Object)(AgentUtils.getCurrentTime() - start), (Object)this.profile.getInstanceId());
        start = AgentUtils.getCurrentTime();
        this.clearOffset();
        LOGGER.info("destroy proxySink, wait for offset clear {} ms instance {}", (Object)(AgentUtils.getCurrentTime() - start), (Object)this.profile.getInstanceId());
        LOGGER.info("destroy sink {} end", (Object)this.sourceName);
    }

    public boolean sinkFinish() {
        boolean finished = false;
        this.packageAckInfoLock.writeLock().lock();
        if (this.ackInfoList.isEmpty()) {
            finished = true;
        }
        this.packageAckInfoLock.writeLock().unlock();
        return finished;
    }

    private void addAckInfo(OffsetAckInfo info) {
        this.packageAckInfoLock.writeLock().lock();
        this.ackInfoList.add(info);
        this.packageAckInfoLock.writeLock().unlock();
    }

    private Runnable flushOffset() {
        return () -> {
            AgentThreadFactory.nameThread((String)("flushOffset-" + this.profile.getTaskId() + "-" + this.profile.getInstanceId()));
            LOGGER.info("start flush offset {}:{}", (Object)this.inlongGroupId, (Object)this.sourceName);
            this.offsetRunning = true;
            while (!this.shutdown) {
                if (AgentUtils.getCurrentTime() - this.lastFlushOffset > 1000L) {
                    this.doFlushOffset();
                    this.lastFlushOffset = AgentUtils.getCurrentTime();
                }
                AgentUtils.silenceSleepInMs((long)10L);
            }
            LOGGER.info("stop flush offset {}:{}", (Object)this.inlongGroupId, (Object)this.sourceName);
            this.offsetRunning = false;
        };
    }

    private void doFlushOffset() {
        this.packageAckInfoLock.writeLock().lock();
        OffsetAckInfo info = null;
        int lenToRelease = 0;
        int i = 0;
        while (i < this.ackInfoList.size() && this.ackInfoList.get(i).getHasAck().booleanValue()) {
            info = this.ackInfoList.remove(i);
            lenToRelease += info.getLen();
        }
        MemoryManager.getInstance().release("agent.global.writer.permit", lenToRelease);
        if (info != null) {
            LOGGER.info("save offset {} taskId {} instanceId {} ackInfoList {}", new Object[]{info.getOffset(), this.profile.getTaskId(), this.profile.getInstanceId(), this.ackInfoList.size()});
            OffsetProfile offsetProfile = new OffsetProfile(this.profile.getTaskId(), this.profile.getInstanceId(), info.getOffset(), this.profile.get("inodeInfo"));
            this.offsetManager.setOffset(offsetProfile);
        }
        this.packageAckInfoLock.writeLock().unlock();
    }

    private void clearOffset() {
        this.doFlushOffset();
        this.packageAckInfoLock.writeLock().lock();
        int i = 0;
        while (i < this.ackInfoList.size()) {
            MemoryManager.getInstance().release("agent.global.writer.permit", this.ackInfoList.remove(i).getLen());
        }
        this.packageAckInfoLock.writeLock().unlock();
    }
}

