/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sources;

import io.debezium.connector.postgresql.PostgresConnector;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.engine.ChangeEvent;
import io.debezium.engine.DebeziumEngine;
import io.debezium.engine.format.Json;
import io.debezium.engine.spi.OffsetCommitPolicy;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.agent.common.AgentThreadFactory;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.constant.AgentConstants;
import org.apache.inlong.agent.except.FileException;
import org.apache.inlong.agent.plugin.sources.extend.DefaultExtendedHandler;
import org.apache.inlong.agent.plugin.sources.file.AbstractSource;
import org.apache.kafka.connect.storage.FileOffsetBackingStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSQLSource
extends AbstractSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgreSQLSource.class);
    private static final Integer DEBEZIUM_QUEUE_SIZE = 100;
    private ExecutorService executor;
    public InstanceProfile profile;
    private BlockingQueue<AbstractSource.SourceData> debeziumQueue;
    private final Properties props = new Properties();
    private String snapshotMode;
    private String pluginName;
    private String dbName;
    private String tableName;
    private boolean isRestoreFromDB = false;

    @Override
    protected void initExtendClass() {
        this.extendClass = DefaultExtendedHandler.class.getCanonicalName();
    }

    @Override
    protected void initSource(InstanceProfile profile) {
        try {
            LOGGER.info("PostgreSQLSource init: {}", (Object)profile.toJsonStr());
            this.debeziumQueue = new LinkedBlockingQueue<AbstractSource.SourceData>(DEBEZIUM_QUEUE_SIZE);
            this.pluginName = profile.get("task.postgreSQLTask.pluginName");
            this.dbName = profile.get("task.postgreSQLTask.dbname");
            this.tableName = profile.get("task.postgreSQLTask.tableIncludeList");
            this.snapshotMode = profile.get("task.postgreSQLTask.snapshotMode", "initial");
            this.props.setProperty("name", "PostgreSQL-" + this.instanceId);
            this.props.setProperty("connector.class", PostgresConnector.class.getName());
            this.props.setProperty("offset.storage", FileOffsetBackingStore.class.getName());
            String agentPath = AgentConfiguration.getAgentConf().get("agent.home", AgentConstants.DEFAULT_AGENT_HOME);
            String offsetPath = agentPath + "/" + this.getThreadName() + "offset.dat";
            this.props.setProperty("offset.storage.file.filename", offsetPath);
            this.props.setProperty(String.valueOf(PostgresConnectorConfig.HOSTNAME), profile.get("task.postgreSQLTask.hostname"));
            this.props.setProperty(String.valueOf(PostgresConnectorConfig.PORT), profile.get("task.postgreSQLTask.port"));
            this.props.setProperty(String.valueOf(PostgresConnectorConfig.USER), profile.get("task.postgreSQLTask.user"));
            this.props.setProperty(String.valueOf(PostgresConnectorConfig.PASSWORD), profile.get("task.postgreSQLTask.password"));
            this.props.setProperty(String.valueOf(PostgresConnectorConfig.DATABASE_NAME), profile.get("task.postgreSQLTask.dbname"));
            this.props.setProperty(String.valueOf(PostgresConnectorConfig.SERVER_NAME), this.getThreadName());
            this.props.setProperty(String.valueOf(PostgresConnectorConfig.SCHEMA_INCLUDE_LIST), profile.get("task.postgreSQLTask.schemaIncludeList"));
            this.props.setProperty(String.valueOf(PostgresConnectorConfig.TABLE_INCLUDE_LIST), profile.get("task.postgreSQLTask.tableIncludeList"));
            this.props.setProperty(String.valueOf(PostgresConnectorConfig.PLUGIN_NAME), this.pluginName);
            this.props.setProperty(String.valueOf(PostgresConnectorConfig.SNAPSHOT_MODE), this.snapshotMode);
            this.executor = Executors.newSingleThreadExecutor();
            this.executor.execute(this.startDebeziumEngine());
        }
        catch (Exception ex) {
            this.stopRunning();
            throw new FileException("error init stream for " + this.instanceId, (Throwable)ex);
        }
    }

    private Runnable startDebeziumEngine() {
        return () -> {
            AgentThreadFactory.nameThread((String)(this.getThreadName() + "debezium"));
            try (DebeziumEngine debeziumEngine = DebeziumEngine.create(Json.class).using(this.props).using(OffsetCommitPolicy.always()).notifying(this::handleConsumerEvent).build();){
                debeziumEngine.run();
            }
            catch (Throwable e) {
                LOGGER.error("do run error in postgres debezium: ", e);
            }
        };
    }

    private void handleConsumerEvent(List<ChangeEvent<String, String>> records, DebeziumEngine.RecordCommitter<ChangeEvent<String, String>> committer) throws InterruptedException {
        boolean offerSuc = false;
        for (ChangeEvent<String, String> record : records) {
            AbstractSource.SourceData sourceData = new AbstractSource.SourceData(this, ((String)record.value()).getBytes(StandardCharsets.UTF_8), "0");
            while (this.isRunnable() && !offerSuc) {
                offerSuc = this.debeziumQueue.offer(sourceData, 1L, TimeUnit.SECONDS);
            }
            committer.markProcessed(record);
        }
        committer.markBatchFinished();
    }

    @Override
    protected String getThreadName() {
        return "postgres-source-" + this.taskId + "-" + this.instanceId;
    }

    @Override
    protected void printCurrentState() {
        LOGGER.info("postgres databases is {} and table is {}", (Object)this.dbName, (Object)this.tableName);
    }

    @Override
    protected boolean doPrepareToRead() {
        return true;
    }

    @Override
    protected List<AbstractSource.SourceData> readFromSource() {
        ArrayList<AbstractSource.SourceData> dataList = new ArrayList<AbstractSource.SourceData>();
        try {
            AbstractSource.SourceData sourceData;
            for (int size = 0; size < this.BATCH_READ_LINE_TOTAL_LEN && (sourceData = this.debeziumQueue.poll(1L, TimeUnit.SECONDS)) != null; size += sourceData.getData().length) {
                LOGGER.info("readFromSource: {}", (Object)sourceData.getData());
                dataList.add(sourceData);
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("poll {} data from debezium queue interrupted.", (Object)this.instanceId);
        }
        return dataList;
    }

    @Override
    protected boolean isRunnable() {
        return this.runnable;
    }

    @Override
    protected void releaseSource() {
        LOGGER.info("release postgres source");
        this.executor.shutdownNow();
    }

    public boolean sourceExist() {
        return true;
    }
}

