/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sources.reader;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.engine.ChangeEvent;
import io.debezium.engine.DebeziumEngine;
import io.debezium.engine.format.Json;
import io.debezium.relational.history.FileDatabaseHistory;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.constant.AgentConstants;
import org.apache.inlong.agent.constant.CommonConstants;
import org.apache.inlong.agent.message.DefaultMessage;
import org.apache.inlong.agent.metrics.audit.AuditUtils;
import org.apache.inlong.agent.plugin.Message;
import org.apache.inlong.agent.plugin.sources.reader.AbstractReader;
import org.apache.inlong.agent.plugin.sources.snapshot.BinlogSnapshotBase;
import org.apache.inlong.agent.plugin.utils.InLongDatabaseHistory;
import org.apache.inlong.agent.plugin.utils.InLongFileOffsetBackingStore;
import org.apache.inlong.agent.pojo.DebeziumFormat;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.kafka.connect.storage.FileOffsetBackingStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinlogReader
extends AbstractReader {
    public static final String JOB_DATABASE_USER = "job.binlogJob.user";
    public static final String JOB_DATABASE_PASSWORD = "job.binlogJob.password";
    public static final String JOB_DATABASE_HOSTNAME = "job.binlogJob.hostname";
    public static final String JOB_TABLE_WHITELIST = "job.binlogJob.tableWhiteList";
    public static final String JOB_DATABASE_WHITELIST = "job.binlogJob.databaseWhiteList";
    public static final String JOB_DATABASE_OFFSETS = "job.binlogJob.offsets";
    public static final String JOB_DATABASE_OFFSET_SPECIFIC_OFFSET_FILE = "job.binlogJob.offset.specificOffsetFile";
    public static final String JOB_DATABASE_OFFSET_SPECIFIC_OFFSET_POS = "job.binlogJob.offset.specificOffsetPos";
    public static final String JOB_DATABASE_SERVER_TIME_ZONE = "job.binlogJob.serverTimezone";
    public static final String JOB_DATABASE_STORE_OFFSET_INTERVAL_MS = "job.binlogJob.offset.intervalMs";
    public static final String JOB_DATABASE_STORE_HISTORY_FILENAME = "job.binlogJob.history.filename";
    public static final String JOB_DATABASE_INCLUDE_SCHEMA_CHANGES = "job.binlogJob.schema";
    public static final String JOB_DATABASE_SNAPSHOT_MODE = "job.binlogJob.snapshot.mode";
    public static final String JOB_DATABASE_HISTORY_MONITOR_DDL = "job.binlogJob.ddl";
    public static final String JOB_DATABASE_PORT = "job.binlogJob.port";
    public static final String JOB_DATABASE_QUEUE_SIZE = "job.binlogJob.queueSize";
    private static final Logger LOGGER = LoggerFactory.getLogger(BinlogReader.class);
    private static final Gson GSON = new Gson();
    private final AgentConfiguration agentConf = AgentConfiguration.getAgentConf();
    private LinkedBlockingQueue<Pair<String, String>> binlogMessagesQueue;
    private boolean finished = false;
    private String userName;
    private String password;
    private String hostName;
    private String port;
    private String tableWhiteList;
    private String databaseWhiteList;
    private String serverTimeZone;
    private String offsetStoreFileName;
    private String offsetFlushIntervalMs;
    private String databaseStoreHistoryName;
    private String includeSchemaChanges;
    private String snapshotMode;
    private String historyMonitorDdl;
    private String instanceId;
    private ExecutorService executor;
    private String specificOffsetFile;
    private String specificOffsetPos;
    private BinlogSnapshotBase binlogSnapshot;
    private JobProfile jobProfile;
    private boolean destroyed = false;

    public Message read() {
        if (!this.binlogMessagesQueue.isEmpty()) {
            return this.getBinlogMessage();
        }
        return null;
    }

    private DefaultMessage getBinlogMessage() {
        Pair<String, String> message = this.binlogMessagesQueue.poll();
        HashMap<String, Object> header = new HashMap<String, Object>(CommonConstants.DEFAULT_MAP_CAPACITY);
        header.put("dataKey", message.getKey());
        return new DefaultMessage(((String)message.getValue()).getBytes(StandardCharsets.UTF_8), header);
    }

    @Override
    public void init(JobProfile jobConf) {
        super.init(jobConf);
        this.jobProfile = jobConf;
        LOGGER.info("init binlog reader with jobConf {}", (Object)jobConf.toJsonStr());
        this.userName = jobConf.get(JOB_DATABASE_USER);
        this.password = jobConf.get(JOB_DATABASE_PASSWORD);
        this.hostName = jobConf.get(JOB_DATABASE_HOSTNAME);
        this.port = jobConf.get(JOB_DATABASE_PORT);
        this.tableWhiteList = jobConf.get(JOB_TABLE_WHITELIST, "[\\s\\S]*.*");
        this.databaseWhiteList = jobConf.get(JOB_DATABASE_WHITELIST, "");
        this.serverTimeZone = jobConf.get(JOB_DATABASE_SERVER_TIME_ZONE, "");
        this.offsetFlushIntervalMs = jobConf.get(JOB_DATABASE_STORE_OFFSET_INTERVAL_MS, "100000");
        this.databaseStoreHistoryName = jobConf.get(JOB_DATABASE_STORE_HISTORY_FILENAME, this.tryToInitAndGetHistoryPath()) + "/history.dat" + jobConf.getInstanceId();
        this.snapshotMode = jobConf.get(JOB_DATABASE_SNAPSHOT_MODE, "");
        this.includeSchemaChanges = jobConf.get(JOB_DATABASE_INCLUDE_SCHEMA_CHANGES, "false");
        this.historyMonitorDdl = jobConf.get(JOB_DATABASE_HISTORY_MONITOR_DDL, "false");
        this.binlogMessagesQueue = new LinkedBlockingQueue(jobConf.getInt(JOB_DATABASE_QUEUE_SIZE, 1000));
        this.instanceId = jobConf.getInstanceId();
        this.finished = false;
        this.specificOffsetFile = jobConf.get(JOB_DATABASE_OFFSET_SPECIFIC_OFFSET_FILE, "");
        this.specificOffsetPos = jobConf.get(JOB_DATABASE_OFFSET_SPECIFIC_OFFSET_POS, "-1");
        this.offsetStoreFileName = jobConf.get(JOB_DATABASE_STORE_HISTORY_FILENAME, this.tryToInitAndGetHistoryPath()) + "/offset.dat" + jobConf.getInstanceId();
        this.binlogSnapshot = new BinlogSnapshotBase(this.offsetStoreFileName);
        String offset = jobConf.get(JOB_DATABASE_OFFSETS, "");
        this.binlogSnapshot.save(offset, this.binlogSnapshot.getFile());
        Properties props = this.getEngineProps();
        DebeziumEngine engine = DebeziumEngine.create(Json.class).notifying((records, committer) -> {
            try {
                for (ChangeEvent record : records) {
                    DebeziumFormat debeziumFormat = (DebeziumFormat)GSON.fromJson((String)record.value(), DebeziumFormat.class);
                    this.binlogMessagesQueue.put((Pair<String, String>)Pair.of((Object)debeziumFormat.getSource().getTable(), (Object)record.value()));
                    committer.markProcessed((Object)record);
                }
                committer.markBatchFinished();
                long dataSize = records.stream().mapToLong(r -> ((String)r.value()).length()).sum();
                AuditUtils.add((int)AuditUtils.AUDIT_ID_AGENT_READ_SUCCESS, (String)this.inlongGroupId, (String)this.inlongStreamId, (long)System.currentTimeMillis(), (int)records.size(), (long)dataSize);
                this.readerMetric.pluginReadSuccessCount.addAndGet(records.size());
                this.readerMetric.pluginReadCount.addAndGet(records.size());
            }
            catch (Exception e) {
                this.readerMetric.pluginReadFailCount.addAndGet(records.size());
                this.readerMetric.pluginReadCount.addAndGet(records.size());
                LOGGER.error("parse binlog message error", (Throwable)e);
            }
        }).using(props).using((success, message, error) -> {
            if (!success) {
                LOGGER.error("error for binlog job: {}, msg: {}", new Object[]{jobConf.getInstanceId(), message, error});
            }
        }).build();
        this.executor = Executors.newSingleThreadExecutor();
        this.executor.execute((Runnable)engine);
        LOGGER.info("get initial snapshot of job {}, snapshot {}", (Object)jobConf.getInstanceId(), (Object)this.getSnapshot());
    }

    private Properties getEngineProps() {
        Properties props = new Properties();
        props.setProperty("name", "engine" + this.instanceId);
        props.setProperty("connector.class", MySqlConnector.class.getCanonicalName());
        props.setProperty("database.server.name", this.instanceId);
        props.setProperty("database.hostname", this.hostName);
        props.setProperty("database.port", this.port);
        props.setProperty("database.user", this.userName);
        props.setProperty("database.password", this.password);
        props.setProperty("database.serverTimezone", this.serverTimeZone);
        props.setProperty("table.whitelist", this.tableWhiteList);
        props.setProperty("database.whitelist", this.databaseWhiteList);
        props.setProperty("offset.flush.interval.ms", this.offsetFlushIntervalMs);
        props.setProperty("database.snapshot.mode", this.snapshotMode);
        props.setProperty("database.history.store.only.monitored.tables.ddl", this.historyMonitorDdl);
        props.setProperty("database.allowPublicKeyRetrieval", "true");
        props.setProperty("key.converter.schemas.enable", "false");
        props.setProperty("value.converter.schemas.enable", "false");
        props.setProperty("include.schema.changes", this.includeSchemaChanges);
        props.setProperty("snapshot.mode", this.snapshotMode);
        props.setProperty("offset.storage.file.filename", this.offsetStoreFileName);
        props.setProperty("database.history.file.filename", this.databaseStoreHistoryName);
        if ("schema_only_recovery".equals(this.snapshotMode)) {
            Preconditions.checkNotNull((Object)JOB_DATABASE_OFFSET_SPECIFIC_OFFSET_FILE, (Object)"job.binlogJob.offset.specificOffsetFileshouldn't be null");
            Preconditions.checkNotNull((Object)JOB_DATABASE_OFFSET_SPECIFIC_OFFSET_POS, (Object)"job.binlogJob.offset.specificOffsetPos shouldn't be null");
            props.setProperty("offset.storage", InLongFileOffsetBackingStore.class.getCanonicalName());
            props.setProperty("offset.storage.inlong.state.value", this.serializeOffset(this.instanceId, this.specificOffsetFile, this.specificOffsetPos));
            props.setProperty("database.history", InLongDatabaseHistory.class.getCanonicalName());
        } else {
            props.setProperty("offset.storage", FileOffsetBackingStore.class.getCanonicalName());
            props.setProperty("database.history", FileDatabaseHistory.class.getCanonicalName());
        }
        props.setProperty("tombstones.on.delete", "false");
        props.setProperty("converters", "datetime");
        props.setProperty("datetime.type", "org.apache.inlong.agent.plugin.utils.BinlogTimeConverter");
        props.setProperty("datetime.format.date", "yyyy-MM-dd");
        props.setProperty("datetime.format.time", "HH:mm:ss");
        props.setProperty("datetime.format.datetime", "yyyy-MM-dd HH:mm:ss");
        props.setProperty("datetime.format.timestamp", "yyyy-MM-dd HH:mm:ss");
        props.setProperty("datetime.format.timestamp.zone", this.serverTimeZone);
        LOGGER.info("binlog job {} start with props {}", (Object)this.jobProfile.getInstanceId(), (Object)props);
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        BinlogReader binlogReader = this;
        synchronized (binlogReader) {
            if (!this.destroyed) {
                this.executor.shutdownNow();
                this.binlogSnapshot.close();
                this.destroyed = true;
            }
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    public String getReadSource() {
        return this.instanceId;
    }

    public void setReadSource(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setReadTimeout(long mill) {
    }

    public void setWaitMillisecond(long millis) {
    }

    public String getSnapshot() {
        if (this.binlogSnapshot != null) {
            return this.binlogSnapshot.getSnapshot();
        }
        return "";
    }

    public void finishRead() {
        this.finished = true;
    }

    public boolean isSourceExist() {
        return true;
    }

    private String tryToInitAndGetHistoryPath() {
        String historyPath = this.agentConf.get("agent.history.path", ".history");
        String parentPath = this.agentConf.get("agent.home", AgentConstants.DEFAULT_AGENT_HOME);
        return AgentUtils.makeDirsIfNotExist((String)historyPath, (String)parentPath).getAbsolutePath();
    }
}

