/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import org.apache.iceberg.metrics.Timer;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Stopwatch;

public class DefaultTimer
implements Timer {
    private final TimeUnit timeUnit;
    private final LongAdder count = new LongAdder();
    private final LongAdder totalTime = new LongAdder();

    public DefaultTimer(TimeUnit timeUnit) {
        Preconditions.checkArgument((null != timeUnit ? 1 : 0) != 0, (Object)"Invalid time unit: null");
        this.timeUnit = timeUnit;
    }

    @Override
    public long count() {
        return this.count.longValue();
    }

    @Override
    public Duration totalDuration() {
        return Duration.ofNanos(this.totalTime.longValue());
    }

    @Override
    public Timer.Timed start() {
        return new DefaultTimed(this, this.timeUnit);
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        Preconditions.checkArgument((amount >= 0L ? 1 : 0) != 0, (String)"Cannot record %s %s: must be >= 0", (long)amount, (Object)((Object)unit));
        this.totalTime.add(TimeUnit.NANOSECONDS.convert(amount, unit));
        this.count.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T time(Supplier<T> supplier) {
        Timer.Timed timed = this.start();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            timed.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T timeCallable(Callable<T> callable) throws Exception {
        Timer.Timed timed = this.start();
        try {
            T t = callable.call();
            return t;
        }
        finally {
            timed.stop();
        }
    }

    @Override
    public void time(Runnable runnable) {
        Timer.Timed timed = this.start();
        try {
            runnable.run();
        }
        finally {
            timed.stop();
        }
    }

    @Override
    public TimeUnit unit() {
        return this.timeUnit;
    }

    public String toString() {
        return MoreObjects.toStringHelper(DefaultTimer.class).add("duration", (Object)this.totalDuration()).add("count", (Object)this.count).add("timeUnit", (Object)this.timeUnit).toString();
    }

    private static class DefaultTimed
    implements Timer.Timed {
        private final Timer timer;
        private final TimeUnit defaultTimeUnit;
        private final AtomicReference<Stopwatch> stopwatchRef = new AtomicReference();

        private DefaultTimed(Timer timer, TimeUnit defaultTimeUnit) {
            this.timer = timer;
            this.defaultTimeUnit = defaultTimeUnit;
            this.stopwatchRef.compareAndSet(null, Stopwatch.createStarted());
        }

        @Override
        public void stop() {
            Stopwatch stopwatch = this.stopwatchRef.getAndSet(null);
            Preconditions.checkState((null != stopwatch ? 1 : 0) != 0, (Object)"stop() called multiple times");
            this.timer.record(stopwatch.stop().elapsed(this.defaultTimeUnit), this.defaultTimeUnit);
        }
    }
}

