/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.stats;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.tubemq.corebase.metric.impl.ESTHistogram;
import org.apache.inlong.tubemq.corebase.metric.impl.LongOnlineCounter;
import org.apache.inlong.tubemq.corebase.metric.impl.LongStatsCounter;
import org.apache.inlong.tubemq.corebase.metric.impl.SinceTime;

public class MasterSrvStatsHolder {
    private static final LongOnlineCounter csmOnlineGroupCnt = new LongOnlineCounter("csm_online_group_cnt", null);
    private static final LongOnlineCounter csmCltBalanceGroupCnt = new LongOnlineCounter("csm_client_bal_group_cnt", null);
    private static final LongOnlineCounter consumerOnlineCnt = new LongOnlineCounter("consumer_online_cnt", null);
    private static final LongOnlineCounter consumerInConnectCount = new LongOnlineCounter("consumer_con_event_cnt", null);
    private static final LongOnlineCounter consumerInDisConnectCount = new LongOnlineCounter("consumer_discon_event_cnt", null);
    private static final LongOnlineCounter producerOnlineCnt = new LongOnlineCounter("producer_online_cnt", null);
    private static final LongOnlineCounter brokerConfiguredCnt = new LongOnlineCounter("broker_configured_cnt", null);
    private static final LongOnlineCounter brokerOnlineCnt = new LongOnlineCounter("broker_online_cnt", null);
    private static final LongOnlineCounter brokerAbnCurCnt = new LongOnlineCounter("broker_abnormal_cnt", null);
    private static final LongOnlineCounter brokerFbdCurCnt = new LongOnlineCounter("broker_forbidden_cnt", null);
    private static final ServiceStatsSet[] switchableSets = new ServiceStatsSet[2];
    private static final AtomicInteger writableIndex = new AtomicInteger(0);
    private static final AtomicLong lstSnapshotTime = new AtomicLong(0L);

    public static void getValue(Map<String, Long> statsMap) {
        MasterSrvStatsHolder.getStatsValue(switchableSets[MasterSrvStatsHolder.getIndex()], false, statsMap);
    }

    public static void getValue(StringBuilder strBuff) {
        MasterSrvStatsHolder.getStatsValue(switchableSets[MasterSrvStatsHolder.getIndex()], false, strBuff);
    }

    public static void snapShort(Map<String, Long> statsMap) {
        if (MasterSrvStatsHolder.switchWritingStatsUnit()) {
            MasterSrvStatsHolder.getStatsValue(switchableSets[MasterSrvStatsHolder.getIndex(writableIndex.get() - 1)], true, statsMap);
        } else {
            MasterSrvStatsHolder.getStatsValue(switchableSets[MasterSrvStatsHolder.getIndex()], false, statsMap);
        }
    }

    public static void snapShort(StringBuilder strBuff) {
        if (MasterSrvStatsHolder.switchWritingStatsUnit()) {
            MasterSrvStatsHolder.getStatsValue(switchableSets[MasterSrvStatsHolder.getIndex(writableIndex.get() - 1)], true, strBuff);
        } else {
            MasterSrvStatsHolder.getStatsValue(switchableSets[MasterSrvStatsHolder.getIndex()], false, strBuff);
        }
    }

    public static void incConsumerCnt(boolean isGroupEmpty, boolean isCltBal) {
        consumerOnlineCnt.incValue();
        if (isGroupEmpty) {
            csmOnlineGroupCnt.incValue();
            if (isCltBal) {
                csmCltBalanceGroupCnt.incValue();
            }
        }
    }

    public static void decConsumerCnt(boolean isTimeout, boolean isGroupEmpty, boolean isCltBal) {
        consumerOnlineCnt.decValue();
        if (isTimeout) {
            MasterSrvStatsHolder.switchableSets[MasterSrvStatsHolder.getIndex()].consumerTmoTotCnt.incValue();
        }
        if (isGroupEmpty) {
            MasterSrvStatsHolder.decConsumeGroupCnt(isTimeout, isCltBal);
        }
    }

    public static void decConsumeGroupCnt(boolean isTimeout, boolean isCltBal) {
        csmOnlineGroupCnt.decValue();
        if (isTimeout) {
            MasterSrvStatsHolder.switchableSets[MasterSrvStatsHolder.getIndex()].csmGroupTimeoutCnt.incValue();
        }
        if (isCltBal) {
            csmCltBalanceGroupCnt.decValue();
            if (isTimeout) {
                MasterSrvStatsHolder.switchableSets[MasterSrvStatsHolder.getIndex()].cltBalGroupTmototCnt.incValue();
            }
        }
    }

    public static void incProducerCnt() {
        producerOnlineCnt.incValue();
    }

    public static void decProducerCnt(boolean isTimeout) {
        producerOnlineCnt.decValue();
        if (isTimeout) {
            MasterSrvStatsHolder.switchableSets[MasterSrvStatsHolder.getIndex()].producerTmoTotCnt.incValue();
        }
    }

    public static void incSvrBalDisConConsumerCnt() {
        consumerInDisConnectCount.incValue();
    }

    public static void decSvrBalDisConConsumerCnt() {
        consumerInDisConnectCount.decValue();
    }

    public static void incSvrBalConEventConsumerCnt() {
        consumerInConnectCount.incValue();
    }

    public static void decSvrBalConEventConsumerCnt() {
        consumerInConnectCount.decValue();
    }

    public static void incBrokerConfigCnt() {
        brokerConfiguredCnt.incValue();
    }

    public static void decBrokerConfigCnt() {
        brokerConfiguredCnt.decValue();
    }

    public static void incBrokerOnlineCnt() {
        brokerOnlineCnt.incValue();
    }

    public static void decBrokerOnlineCnt(boolean isTimeout) {
        brokerOnlineCnt.decValue();
        if (isTimeout) {
            MasterSrvStatsHolder.switchableSets[MasterSrvStatsHolder.getIndex()].brokerTmoTotCnt.incValue();
        }
    }

    public static void incBrokerAbnormalCnt() {
        brokerAbnCurCnt.incValue();
    }

    public static void decBrokerAbnormalCnt() {
        brokerAbnCurCnt.decValue();
    }

    public static void incBrokerForbiddenCnt() {
        brokerFbdCurCnt.incValue();
    }

    public static void decBrokerForbiddenCnt() {
        brokerFbdCurCnt.decValue();
    }

    public static void updSvrBalanceDurations(long dltTime) {
        MasterSrvStatsHolder.switchableSets[MasterSrvStatsHolder.getIndex()].svrNormalBalanceStats.update(dltTime);
    }

    public static void updSvrBalResetDurations(long dltTime) {
        MasterSrvStatsHolder.switchableSets[MasterSrvStatsHolder.getIndex()].svrResetBalanceStats.update(dltTime);
    }

    private static boolean switchWritingStatsUnit() {
        long curSnapshotTime = lstSnapshotTime.get();
        if (System.currentTimeMillis() - curSnapshotTime >= 2000L && lstSnapshotTime.compareAndSet(curSnapshotTime, System.currentTimeMillis())) {
            switchableSets[MasterSrvStatsHolder.getIndex(writableIndex.incrementAndGet())].resetSinceTime();
            return true;
        }
        return false;
    }

    private static void getStatsValue(ServiceStatsSet statsSet, boolean resetValue, Map<String, Long> statsMap) {
        statsMap.put(statsSet.lstResetTime.getFullName(), statsSet.lstResetTime.getSinceTime());
        if (resetValue) {
            statsMap.put(csmOnlineGroupCnt.getFullName(), csmOnlineGroupCnt.getAndResetValue());
            statsMap.put(statsSet.csmGroupTimeoutCnt.getFullName(), statsSet.csmGroupTimeoutCnt.getAndResetValue());
            statsMap.put(csmCltBalanceGroupCnt.getFullName(), csmCltBalanceGroupCnt.getAndResetValue());
            statsMap.put(statsSet.cltBalGroupTmototCnt.getFullName(), statsSet.cltBalGroupTmototCnt.getAndResetValue());
            statsSet.svrNormalBalanceStats.snapShort(statsMap, false);
            statsSet.svrResetBalanceStats.snapShort(statsMap, false);
            statsMap.put(consumerOnlineCnt.getFullName(), consumerOnlineCnt.getAndResetValue());
            statsMap.put(statsSet.consumerTmoTotCnt.getFullName(), statsSet.consumerTmoTotCnt.getAndResetValue());
            statsMap.put(consumerInConnectCount.getFullName(), consumerInConnectCount.getAndResetValue());
            statsMap.put(consumerInDisConnectCount.getFullName(), consumerInDisConnectCount.getAndResetValue());
            statsMap.put(producerOnlineCnt.getFullName(), producerOnlineCnt.getAndResetValue());
            statsMap.put(statsSet.producerTmoTotCnt.getFullName(), statsSet.producerTmoTotCnt.getAndResetValue());
            statsMap.put(brokerConfiguredCnt.getFullName(), brokerConfiguredCnt.getAndResetValue());
            statsMap.put(brokerOnlineCnt.getFullName(), brokerOnlineCnt.getAndResetValue());
            statsMap.put(statsSet.brokerTmoTotCnt.getFullName(), statsSet.brokerTmoTotCnt.getAndResetValue());
            statsMap.put(brokerAbnCurCnt.getFullName(), brokerAbnCurCnt.getAndResetValue());
            statsMap.put(brokerFbdCurCnt.getFullName(), brokerFbdCurCnt.getAndResetValue());
        } else {
            statsMap.put(csmOnlineGroupCnt.getFullName(), csmOnlineGroupCnt.getValue());
            statsMap.put(statsSet.csmGroupTimeoutCnt.getFullName(), statsSet.csmGroupTimeoutCnt.getValue());
            statsMap.put(csmCltBalanceGroupCnt.getFullName(), csmCltBalanceGroupCnt.getValue());
            statsMap.put(statsSet.cltBalGroupTmototCnt.getFullName(), statsSet.cltBalGroupTmototCnt.getValue());
            statsSet.svrNormalBalanceStats.getValue(statsMap, false);
            statsSet.svrResetBalanceStats.getValue(statsMap, false);
            statsMap.put(consumerOnlineCnt.getFullName(), consumerOnlineCnt.getValue());
            statsMap.put(statsSet.consumerTmoTotCnt.getFullName(), statsSet.consumerTmoTotCnt.getValue());
            statsMap.put(consumerInConnectCount.getFullName(), consumerInConnectCount.getValue());
            statsMap.put(consumerInDisConnectCount.getFullName(), consumerInDisConnectCount.getValue());
            statsMap.put(producerOnlineCnt.getFullName(), producerOnlineCnt.getValue());
            statsMap.put(statsSet.producerTmoTotCnt.getFullName(), statsSet.producerTmoTotCnt.getValue());
            statsMap.put(brokerConfiguredCnt.getFullName(), brokerConfiguredCnt.getValue());
            statsMap.put(brokerOnlineCnt.getFullName(), brokerOnlineCnt.getValue());
            statsMap.put(statsSet.brokerTmoTotCnt.getFullName(), statsSet.brokerTmoTotCnt.getValue());
            statsMap.put(brokerAbnCurCnt.getFullName(), brokerAbnCurCnt.getValue());
            statsMap.put(brokerFbdCurCnt.getFullName(), brokerFbdCurCnt.getValue());
        }
    }

    private static void getStatsValue(ServiceStatsSet statsSet, boolean resetValue, StringBuilder strBuff) {
        strBuff.append("{\"").append(statsSet.lstResetTime.getFullName()).append("\":\"").append(statsSet.lstResetTime.getStrSinceTime()).append("\"");
        if (resetValue) {
            strBuff.append(",\"").append(csmOnlineGroupCnt.getFullName()).append("\":").append(csmOnlineGroupCnt.getAndResetValue()).append(",\"").append(statsSet.csmGroupTimeoutCnt.getFullName()).append("\":").append(statsSet.csmGroupTimeoutCnt.getAndResetValue()).append(",\"").append(csmCltBalanceGroupCnt.getFullName()).append("\":").append(csmCltBalanceGroupCnt.getAndResetValue()).append(",\"").append(statsSet.cltBalGroupTmototCnt.getFullName()).append("\":").append(statsSet.cltBalGroupTmototCnt.getAndResetValue()).append(",");
            statsSet.svrNormalBalanceStats.snapShort(strBuff, false);
            strBuff.append(",");
            statsSet.svrResetBalanceStats.snapShort(strBuff, false);
            strBuff.append(",\"").append(consumerOnlineCnt.getFullName()).append("\":").append(consumerOnlineCnt.getAndResetValue()).append(",\"").append(statsSet.consumerTmoTotCnt.getFullName()).append("\":").append(statsSet.consumerTmoTotCnt.getAndResetValue()).append(",\"").append(consumerInConnectCount.getFullName()).append("\":").append(consumerInConnectCount.getAndResetValue()).append(",\"").append(consumerInDisConnectCount.getFullName()).append("\":").append(consumerInDisConnectCount.getAndResetValue()).append(",\"").append(producerOnlineCnt.getFullName()).append("\":").append(producerOnlineCnt.getAndResetValue()).append(",\"").append(statsSet.producerTmoTotCnt.getFullName()).append("\":").append(statsSet.producerTmoTotCnt.getAndResetValue()).append(",\"").append(brokerConfiguredCnt.getFullName()).append("\":").append(brokerConfiguredCnt.getAndResetValue()).append(",\"").append(brokerOnlineCnt.getFullName()).append("\":").append(brokerOnlineCnt.getAndResetValue()).append(",\"").append(statsSet.brokerTmoTotCnt.getFullName()).append("\":").append(statsSet.brokerTmoTotCnt.getAndResetValue()).append(",\"").append(brokerAbnCurCnt.getFullName()).append("\":").append(brokerAbnCurCnt.getAndResetValue()).append(",\"").append(brokerFbdCurCnt.getFullName()).append("\":").append(brokerFbdCurCnt.getAndResetValue()).append("}");
        } else {
            strBuff.append(",\"").append(csmOnlineGroupCnt.getFullName()).append("\":").append(csmOnlineGroupCnt.getValue()).append(",\"").append(statsSet.csmGroupTimeoutCnt.getFullName()).append("\":").append(statsSet.csmGroupTimeoutCnt.getValue()).append(",\"").append(csmCltBalanceGroupCnt.getFullName()).append("\":").append(csmCltBalanceGroupCnt.getValue()).append(",\"").append(statsSet.cltBalGroupTmototCnt.getFullName()).append("\":").append(statsSet.cltBalGroupTmototCnt.getValue()).append(",");
            statsSet.svrNormalBalanceStats.getValue(strBuff, false);
            strBuff.append(",");
            statsSet.svrResetBalanceStats.getValue(strBuff, false);
            strBuff.append(",\"").append(consumerOnlineCnt.getFullName()).append("\":").append(consumerOnlineCnt.getValue()).append(",\"").append(statsSet.consumerTmoTotCnt.getFullName()).append("\":").append(statsSet.consumerTmoTotCnt.getValue()).append(",\"").append(consumerInConnectCount.getFullName()).append("\":").append(consumerInConnectCount.getValue()).append(",\"").append(consumerInDisConnectCount.getFullName()).append("\":").append(consumerInDisConnectCount.getValue()).append(",\"").append(producerOnlineCnt.getFullName()).append("\":").append(producerOnlineCnt.getValue()).append(",\"").append(statsSet.producerTmoTotCnt.getFullName()).append("\":").append(statsSet.producerTmoTotCnt.getValue()).append(",\"").append(brokerConfiguredCnt.getFullName()).append("\":").append(brokerConfiguredCnt.getValue()).append(",\"").append(brokerOnlineCnt.getFullName()).append("\":").append(brokerOnlineCnt.getValue()).append(",\"").append(statsSet.brokerTmoTotCnt.getFullName()).append("\":").append(statsSet.brokerTmoTotCnt.getValue()).append(",\"").append(brokerAbnCurCnt.getFullName()).append("\":").append(brokerAbnCurCnt.getValue()).append(",\"").append(brokerFbdCurCnt.getFullName()).append("\":").append(brokerFbdCurCnt.getValue()).append("}");
        }
    }

    private static int getIndex() {
        return MasterSrvStatsHolder.getIndex(writableIndex.get());
    }

    private static int getIndex(int origIndex) {
        return Math.abs(origIndex % 2);
    }

    static {
        MasterSrvStatsHolder.switchableSets[0] = new ServiceStatsSet();
        MasterSrvStatsHolder.switchableSets[1] = new ServiceStatsSet();
    }

    private static class ServiceStatsSet {
        protected final SinceTime lstResetTime = new SinceTime("reset_time", null);
        protected final LongStatsCounter csmGroupTimeoutCnt = new LongStatsCounter("csm_group_timeout_cnt", null);
        protected final LongStatsCounter cltBalGroupTmototCnt = new LongStatsCounter("client_balance_timeout_cnt", null);
        protected final LongStatsCounter consumerTmoTotCnt = new LongStatsCounter("consumer_timeout_cnt", null);
        protected final LongStatsCounter producerTmoTotCnt = new LongStatsCounter("producer_timeout_cnt", null);
        protected final LongStatsCounter brokerTmoTotCnt = new LongStatsCounter("broker_timeout_cnt", null);
        protected final ESTHistogram svrNormalBalanceStats = new ESTHistogram("server_balance_normal", null);
        protected final ESTHistogram svrResetBalanceStats = new ESTHistogram("server_balance_reset", null);

        public ServiceStatsSet() {
            this.resetSinceTime();
        }

        public void resetSinceTime() {
            this.lstResetTime.reset();
        }
    }
}

