/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.sender.http;

import java.util.Collections;
import java.util.List;
import org.apache.inlong.dataproxy.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.dataproxy.common.EventInfo;
import org.apache.inlong.sdk.dataproxy.exception.ProxyEventException;

public class HttpEventInfo
extends EventInfo<String> {
    public HttpEventInfo(String groupId, String streamId, long dtMs, String body) throws ProxyEventException {
        super(groupId, streamId, dtMs, null, null, null, true, Collections.singletonList(body));
    }

    public HttpEventInfo(String groupId, String streamId, long dtMs, long auditId, String body) throws ProxyEventException {
        super(groupId, streamId, dtMs, auditId, null, null, true, Collections.singletonList(body));
    }

    public HttpEventInfo(String groupId, String streamId, long dtMs, List<String> bodyList) throws ProxyEventException {
        super(groupId, streamId, dtMs, null, null, null, false, bodyList);
    }

    public HttpEventInfo(String groupId, String streamId, long dtMs, long auditId, List<String> bodyList) throws ProxyEventException {
        super(groupId, streamId, dtMs, auditId, null, null, false, bodyList);
    }

    public List<String> getBodyList() {
        return this.bodyList;
    }

    @Override
    protected void setBodyList(boolean isSingle, List<String> bodyList) throws ProxyEventException {
        if (isSingle) {
            if (StringUtils.isBlank(bodyList.get(0))) {
                throw new ProxyEventException("body is null or empty!");
            }
            String tmpValue = bodyList.get(0).trim();
            this.bodyList.add(tmpValue);
            this.bodySize = tmpValue.length();
            this.msgCnt = 1;
        } else {
            if (bodyList == null || bodyList.isEmpty()) {
                throw new ProxyEventException("bodyList is null or empty!");
            }
            for (String body : bodyList) {
                if (StringUtils.isBlank(body)) continue;
                String tmpValue = body.trim();
                this.bodyList.add(tmpValue.trim());
                this.bodySize += tmpValue.length();
                ++this.msgCnt;
            }
            if (this.bodyList.isEmpty()) {
                throw new ProxyEventException("bodyList no valid content!");
            }
        }
    }
}

