/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.sink;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.RateLimiter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.flume.Channel;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.FlumeException;
import org.apache.flume.Sink;
import org.apache.flume.Transaction;
import org.apache.flume.conf.Configurable;
import org.apache.flume.instrumentation.SinkCounter;
import org.apache.flume.sink.AbstractSink;
import org.apache.inlong.audit.base.HighPriorityThreadFactory;
import org.apache.inlong.audit.file.ConfigManager;
import org.apache.inlong.audit.metric.MetricsManager;
import org.apache.inlong.audit.sink.EventStat;
import org.apache.inlong.audit.utils.FailoverChannelProcessorHolder;
import org.apache.inlong.common.util.NetworkUtils;
import org.apache.inlong.tubemq.client.config.TubeClientConfig;
import org.apache.inlong.tubemq.client.exception.TubeClientException;
import org.apache.inlong.tubemq.client.factory.TubeMultiSessionFactory;
import org.apache.inlong.tubemq.client.producer.MessageProducer;
import org.apache.inlong.tubemq.client.producer.MessageSentCallback;
import org.apache.inlong.tubemq.client.producer.MessageSentResult;
import org.apache.inlong.tubemq.corebase.Message;
import org.apache.inlong.tubemq.corerpc.exception.OverflowException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TubeSink
extends AbstractSink
implements Configurable {
    private static final Logger logger = LoggerFactory.getLogger(TubeSink.class);
    private static final String SINK_THREAD_NUM = "thread-num";
    private static final int defaultRetryCnt = -1;
    private static final int defaultLogEveryNEvents = 100000;
    private static final int defaultSendTimeout = 20000;
    private static final Long PRINT_INTERVAL = 30L;
    private static final TubePerformanceTask tubePerformanceTask = new TubePerformanceTask();
    private static final int BAD_EVENT_QUEUE_SIZE = 10000;
    private static final int EVENT_QUEUE_SIZE = 1000;
    private static final String MASTER_HOST_PORT_LIST = "master-host-port-list";
    private static final String TOPIC = "topic";
    private static final String SEND_TIMEOUT = "send_timeout";
    private static final String LOG_EVERY_N_EVENTS = "log-every-n-events";
    private static final String RETRY_CNT = "retry-currentSuccSendedCnt";
    private static int retryCnt = -1;
    private static AtomicLong totalTubeSuccSendCnt = new AtomicLong(0L);
    private static AtomicLong totalTubeSuccSendSize = new AtomicLong(0L);
    private static ConcurrentHashMap<String, Long> illegalTopicMap = new ConcurrentHashMap();
    private static ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, new HighPriorityThreadFactory("tubePerformance-Printer-thread"));
    public MessageProducer producer;
    public Map<String, MessageProducer> producerMap;
    public TubeMultiSessionFactory sessionFactory;
    private SinkCounter sinkCounter;
    private String topic;
    private volatile boolean canTake = false;
    private volatile boolean canSend = false;
    private LinkedBlockingQueue<EventStat> resendQueue;
    private LinkedBlockingQueue<Event> eventQueue;
    private long diskIORatePerSec;
    private RateLimiter diskRateLimiter;
    private String masterHostAndPortList;
    private Integer logEveryNEvents;
    private Integer sendTimeout;
    private int threadNum;
    private Thread[] sinkThreadPool;
    private long linkMaxAllowedDelayedMsgCount;
    private long sessionWarnDelayedMsgCount;
    private long sessionMaxAllowedDelayedMsgCount;
    private long nettyWriteBufferHighWaterMark;
    private int recoverthreadcount;
    private boolean overflow = false;
    private AtomicLong currentSuccessSendCnt = new AtomicLong(0L);
    private AtomicLong lastSuccessSendCnt = new AtomicLong(0L);
    private long t1 = System.currentTimeMillis();
    private long t2 = 0L;
    private String localIp = "127.0.0.1";

    public TubeSink() {
        logger.debug("new instance of TubeSink!");
    }

    public synchronized void start() {
        logger.info("tube sink starting");
        try {
            this.createConnection();
        }
        catch (FlumeException e) {
            logger.error("Unable to create tube client. Exception follows.", (Throwable)e);
            this.stop();
            return;
        }
        this.sinkCounter.start();
        super.start();
        this.canSend = true;
        this.canTake = true;
        try {
            this.initTopicProducer(this.topic);
        }
        catch (Exception e) {
            logger.error("tubesink start publish topic fail.", (Throwable)e);
        }
        for (int i = 0; i < this.sinkThreadPool.length; ++i) {
            this.sinkThreadPool[i] = new Thread((Runnable)new SinkTask(), this.getName() + "_tube_sink_sender-" + i);
            this.sinkThreadPool[i].start();
        }
        logger.debug("tubesink started");
    }

    public synchronized void stop() {
        logger.info("tube sink stopping");
        this.destroyConnection();
        this.canTake = false;
        int waitCount = 0;
        while (this.eventQueue.size() != 0 && waitCount++ < 10) {
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.info("Stop thread has been interrupt!");
                break;
            }
        }
        this.canSend = false;
        if (this.sinkThreadPool != null) {
            for (Thread thread : this.sinkThreadPool) {
                if (thread == null) continue;
                thread.interrupt();
            }
            this.sinkThreadPool = null;
        }
        super.stop();
        if (!scheduledExecutorService.isShutdown()) {
            scheduledExecutorService.shutdown();
        }
        this.sinkCounter.stop();
        logger.debug("tubesink stopped. Metrics:{}", (Object)this.sinkCounter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sink.Status process() throws EventDeliveryException {
        logger.info("tube sink processing");
        if (!this.canTake) {
            return Sink.Status.BACKOFF;
        }
        Sink.Status status = Sink.Status.READY;
        Channel channel = this.getChannel();
        tx.begin();
        try (Transaction tx = channel.getTransaction();){
            Event event = channel.take();
            if (event != null) {
                if (this.diskRateLimiter != null) {
                    this.diskRateLimiter.acquire(event.getBody().length);
                }
                if (!this.eventQueue.offer(event, 3000L, TimeUnit.MILLISECONDS)) {
                    logger.info("[{}] Channel --> Queue(has no enough space,current code point) --> Tube,Check if Tube server or network is ok.(if this situation last long time it will cause memoryChannel full and fileChannel write.)", (Object)this.getName());
                    tx.rollback();
                } else {
                    tx.commit();
                }
            } else {
                status = Sink.Status.BACKOFF;
                tx.commit();
            }
        }
        return status;
    }

    public void configure(Context context) {
        logger.info("Tubesink started and context = {}", (Object)context.toString());
        this.topic = context.getString(TOPIC);
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)this.topic), (Object)"No topic specified");
        Preconditions.checkState((this.masterHostAndPortList != null ? 1 : 0) != 0, (Object)"No master and port list specified");
        this.producerMap = new HashMap<String, MessageProducer>();
        this.logEveryNEvents = context.getInteger(LOG_EVERY_N_EVENTS, Integer.valueOf(100000));
        logger.debug(this.getName() + " " + LOG_EVERY_N_EVENTS + " " + this.logEveryNEvents);
        Preconditions.checkArgument((this.logEveryNEvents > 0 ? 1 : 0) != 0, (Object)"logEveryNEvents must be > 0");
        this.sendTimeout = context.getInteger(SEND_TIMEOUT, Integer.valueOf(20000));
        logger.debug(this.getName() + " " + SEND_TIMEOUT + " " + this.sendTimeout);
        Preconditions.checkArgument((this.sendTimeout > 0 ? 1 : 0) != 0, (Object)"sendTimeout must be > 0");
        retryCnt = context.getInteger(RETRY_CNT, Integer.valueOf(-1));
        logger.debug(this.getName() + " " + RETRY_CNT + " " + retryCnt);
        this.localIp = NetworkUtils.getLocalIp();
        if (this.sinkCounter == null) {
            this.sinkCounter = new SinkCounter(this.getName());
        }
        this.resendQueue = new LinkedBlockingQueue(10000);
        String sinkThreadNum = context.getString(SINK_THREAD_NUM, "4");
        this.threadNum = Integer.parseInt(sinkThreadNum);
        Preconditions.checkArgument((this.threadNum > 0 ? 1 : 0) != 0, (Object)"threadNum must be > 0");
        this.sinkThreadPool = new Thread[this.threadNum];
        this.eventQueue = new LinkedBlockingQueue(1000);
        this.diskIORatePerSec = context.getLong("disk-io-rate-per-sec", Long.valueOf(0L));
        if (this.diskIORatePerSec != 0L) {
            this.diskRateLimiter = RateLimiter.create((double)this.diskIORatePerSec);
        }
        this.linkMaxAllowedDelayedMsgCount = context.getLong("link_max_allowed_delayed_msg_count", Long.valueOf(80000L));
        this.sessionWarnDelayedMsgCount = context.getLong("session_warn_delayed_msg_count", Long.valueOf(2000000L));
        this.sessionMaxAllowedDelayedMsgCount = context.getLong("session_max_allowed_delayed_msg_count", Long.valueOf(4000000L));
        this.nettyWriteBufferHighWaterMark = context.getLong("netty_write_buffer_high_water_mark", Long.valueOf(0xF00000L));
        this.recoverthreadcount = context.getInteger("recover_thread_count", Integer.valueOf(Runtime.getRuntime().availableProcessors() + 1));
    }

    public void handleMessageSendSuccess(EventStat es) {
        MetricsManager.getInstance().addSendSuccess(1L);
        totalTubeSuccSendCnt.incrementAndGet();
        totalTubeSuccSendSize.addAndGet(es.getEvent().getBody().length);
        this.sinkCounter.incrementEventDrainSuccessCount();
        this.currentSuccessSendCnt.incrementAndGet();
        long nowCnt = this.currentSuccessSendCnt.get();
        long oldCnt = this.lastSuccessSendCnt.get();
        if (nowCnt % (long)this.logEveryNEvents.intValue() == 0L && nowCnt != this.lastSuccessSendCnt.get()) {
            this.lastSuccessSendCnt.set(nowCnt);
            this.t2 = System.currentTimeMillis();
            logger.info("tubesink {}, succ put {} events to tube, in the past {} millsec", new Object[]{this.getName(), nowCnt - oldCnt, this.t2 - this.t1});
            this.t1 = this.t2;
        }
    }

    private void resendEvent(EventStat es, boolean isDecrement) {
        try {
            if (es == null || es.getEvent() == null) {
                return;
            }
            if (!this.resendQueue.offer(es)) {
                FailoverChannelProcessorHolder.getChannelProcessor().processEvent(es.getEvent());
            }
        }
        catch (Throwable throwable) {
            logger.error("resendEvent e = {}", throwable);
        }
    }

    private void createConnection() throws FlumeException {
        if (this.sessionFactory != null) {
            return;
        }
        try {
            TubeClientConfig conf = this.initTubeConfig();
            this.sessionFactory = new TubeMultiSessionFactory(conf);
            logger.info("create tube connection successfully");
        }
        catch (TubeClientException e) {
            logger.error("create connnection error in tubesink, maybe tube master set error, please re-check. ex1 {}", (Object)e.getMessage());
            throw new FlumeException("connect to Tube error1, maybe zkstr/zkroot set error, please re-check");
        }
        catch (Throwable e) {
            logger.error("create connnection error in tubesink, maybe tube master set error/shutdown in progress, please re-check. ex2 {}", e);
            throw new FlumeException("connect to meta error2, maybe tube master set error/shutdown in progress, please re-check");
        }
        if (this.producerMap == null) {
            this.producerMap = new HashMap<String, MessageProducer>();
        }
    }

    private TubeClientConfig initTubeConfig() throws Exception {
        ConfigManager configManager = ConfigManager.getInstance();
        List mqInfoList = configManager.getMqInfoList();
        mqInfoList.forEach(mqClusterInfo -> {
            if ("TUBEMQ".equals(mqClusterInfo.getMqType())) {
                this.masterHostAndPortList = mqClusterInfo.getUrl();
            }
        });
        TubeClientConfig tubeClientConfig = new TubeClientConfig(this.masterHostAndPortList);
        tubeClientConfig.setLinkMaxAllowedDelayedMsgCount(this.linkMaxAllowedDelayedMsgCount);
        tubeClientConfig.setSessionWarnDelayedMsgCount(this.sessionWarnDelayedMsgCount);
        tubeClientConfig.setSessionMaxAllowedDelayedMsgCount(this.sessionMaxAllowedDelayedMsgCount);
        tubeClientConfig.setNettyWriteBufferHighWaterMark(this.nettyWriteBufferHighWaterMark);
        tubeClientConfig.setHeartbeatPeriodMs(15000L);
        tubeClientConfig.setRpcTimeoutMs(20000L);
        return tubeClientConfig;
    }

    private void destroyConnection() {
        for (Map.Entry<String, MessageProducer> entry : this.producerMap.entrySet()) {
            MessageProducer producer = entry.getValue();
            try {
                producer.shutdown();
            }
            catch (TubeClientException e) {
                logger.error("destroy producer error in tubesink, MetaClientException {}", (Object)e.getMessage());
            }
            catch (Throwable e) {
                logger.error("destroy producer error in tubesink, ex {}", (Object)e.getMessage());
            }
        }
        this.producerMap.clear();
        if (this.sessionFactory != null) {
            try {
                this.sessionFactory.shutdown();
            }
            catch (Exception e) {
                logger.error("destroy sessionFactory error in tubesink, ex {}", (Object)e.getMessage());
            }
        }
        this.sessionFactory = null;
        logger.debug("closed meta producer");
    }

    private void initTopicProducer(String topic) throws TubeClientException {
        if (StringUtils.isEmpty((CharSequence)topic)) {
            logger.error("topic is empty");
            return;
        }
        if (this.sessionFactory == null) {
            throw new TubeClientException("sessionFactory is null, can't create producer");
        }
        if (this.producer == null) {
            this.producer = this.sessionFactory.createProducer();
        }
        this.producer.publish(topic);
        this.producerMap.put(topic, this.producer);
        logger.info(this.getName() + " success publish topic: " + topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageProducer getProducer(String topic) throws TubeClientException {
        if (this.producerMap.containsKey(topic)) {
            return this.producerMap.get(topic);
        }
        TubeSink tubeSink = this;
        synchronized (tubeSink) {
            if (!this.producerMap.containsKey(topic)) {
                if (this.producer == null) {
                    this.producer = this.sessionFactory.createProducer();
                }
                this.producer.publish(topic);
                this.producerMap.put(topic, this.producer);
            }
        }
        return this.producerMap.get(topic);
    }

    static {
        logger.info("init tubePerformanceTask");
        scheduledExecutorService.scheduleWithFixedDelay(tubePerformanceTask, 0L, PRINT_INTERVAL, TimeUnit.SECONDS);
    }

    public class MyCallback
    implements MessageSentCallback {
        private EventStat myEventStat;
        private long sendTime;

        public MyCallback(EventStat eventStat) {
            this.myEventStat = eventStat;
            this.sendTime = System.currentTimeMillis();
        }

        public void onMessageSent(MessageSentResult result) {
            if (result.isSuccess()) {
                TubeSink.this.handleMessageSendSuccess(this.myEventStat);
                return;
            }
            MetricsManager.getInstance().addSendFailed(1L);
            if (result.getErrCode() == 403) {
                logger.warn("Send message failed, error message: {}, resendQueue size: {}, event:{}", new Object[]{result.getErrMsg(), TubeSink.this.resendQueue.size(), this.myEventStat.getEvent().hashCode()});
                return;
            }
            if (result.getErrCode() != 419) {
                logger.warn("Send message failed, error message: {}, resendQueue size: {}, event:{}", new Object[]{result.getErrMsg(), TubeSink.this.resendQueue.size(), this.myEventStat.getEvent().hashCode()});
            }
            this.myEventStat.incRetryCnt();
            TubeSink.this.resendEvent(this.myEventStat, true);
        }

        public void onException(Throwable e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            if (t instanceof OverflowException) {
                TubeSink.this.overflow = true;
            }
            this.myEventStat.incRetryCnt();
            TubeSink.this.resendEvent(this.myEventStat, true);
        }
    }

    class SinkTask
    implements Runnable {
        SinkTask() {
        }

        @Override
        public void run() {
            logger.info("Sink task {} started.", (Object)Thread.currentThread().getName());
            while (TubeSink.this.canSend) {
                boolean decrementFlag = false;
                Event event = null;
                EventStat es = null;
                String topic = null;
                try {
                    EventStat eventStat;
                    boolean sendResult;
                    if (TubeSink.this.overflow) {
                        TubeSink.this.overflow = false;
                        Thread.sleep(10L);
                    }
                    if (!TubeSink.this.resendQueue.isEmpty()) {
                        es = (EventStat)TubeSink.this.resendQueue.poll();
                        if (es != null && (event = es.getEvent()).getHeaders().containsKey(TubeSink.TOPIC)) {
                            topic = (String)event.getHeaders().get(TubeSink.TOPIC);
                        }
                    } else {
                        event = (Event)TubeSink.this.eventQueue.take();
                        es = new EventStat(event);
                        if (event.getHeaders().containsKey(TubeSink.TOPIC)) {
                            topic = (String)event.getHeaders().get(TubeSink.TOPIC);
                        }
                    }
                    if (event == null) continue;
                    if (topic == null || topic.equals("")) {
                        logger.warn("no topic specified in event header, just skip this event");
                        continue;
                    }
                    Long expireTime = (Long)illegalTopicMap.get(topic);
                    if (expireTime != null) {
                        long currentTime = System.currentTimeMillis();
                        if (expireTime > currentTime) continue;
                        illegalTopicMap.remove(topic);
                    }
                    if (!(sendResult = this.sendMessage(event, topic, eventStat = es))) continue;
                    decrementFlag = true;
                }
                catch (InterruptedException e) {
                    logger.info("Thread {} has been interrupted!", (Object)Thread.currentThread().getName());
                    return;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof TubeClientException) {
                        String message = throwable.getMessage();
                        if (message != null && (message.contains("No available queue for topic") || message.contains("The brokers of topic are all forbidden"))) {
                            illegalTopicMap.put(topic, System.currentTimeMillis() + 60000L);
                            logger.info("IllegalTopicMap.put " + topic);
                            continue;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    TubeSink.this.resendEvent(es, decrementFlag);
                }
            }
        }

        private boolean sendMessage(Event event, String topic, EventStat es) throws TubeClientException, InterruptedException {
            MessageProducer producer = TubeSink.this.getProducer(topic);
            if (producer == null) {
                illegalTopicMap.put(topic, System.currentTimeMillis() + 30000L);
                logger.error("Get producer is null, topic:{}", (Object)topic);
                return false;
            }
            Message message = new Message(topic, event.getBody());
            message.setAttrKeyVal("auditIp", TubeSink.this.localIp);
            String streamId = "";
            String groupId = "";
            if (event.getHeaders().containsKey("inlongStreamId")) {
                streamId = (String)event.getHeaders().get("inlongStreamId");
                message.setAttrKeyVal("inlongStreamId", streamId);
            }
            if (event.getHeaders().containsKey("inlongGroupId")) {
                groupId = (String)event.getHeaders().get("inlongGroupId");
                message.setAttrKeyVal("inlongGroupId", groupId);
            }
            logger.debug("producer start to send msg...");
            producer.sendMessage(message, (MessageSentCallback)new MyCallback(es));
            illegalTopicMap.remove(topic);
            return true;
        }
    }

    static class TubePerformanceTask
    implements Runnable {
        TubePerformanceTask() {
        }

        @Override
        public void run() {
            try {
                if (totalTubeSuccSendSize.get() != 0L) {
                    logger.info("Total tube performance tps :" + totalTubeSuccSendCnt.get() / PRINT_INTERVAL + "/s, avg msg size:" + totalTubeSuccSendSize.get() / totalTubeSuccSendCnt.get() + ",print every " + PRINT_INTERVAL + " seconds");
                    totalTubeSuccSendSize.set(0L);
                    totalTubeSuccSendCnt.set(0L);
                }
            }
            catch (Exception e) {
                logger.info("tubePerformanceTask error", (Throwable)e);
            }
        }
    }
}

