/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.format;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.node.format.Format;

@JsonTypeName(value="csvFormat")
public class CsvFormat
implements Format {
    private static final long serialVersionUID = 1L;
    private static final String IDENTIFIER = "csv";
    @JsonProperty(value="fieldDelimiter", defaultValue=",")
    private String fieldDelimiter;
    @JsonProperty(value="disableQuoteCharacter", defaultValue="true")
    private Boolean disableQuoteCharacter;
    @JsonProperty(value="quoteCharacter", defaultValue="\"")
    private String quoteCharacter;
    @JsonProperty(value="allowComments", defaultValue="false")
    private Boolean allowComments;
    @JsonProperty(value="ignoreParseErrors", defaultValue="false")
    private Boolean ignoreParseErrors;
    @JsonProperty(value="arrayElementDelimiter", defaultValue=";")
    private String arrayElementDelimiter;
    @JsonProperty(value="escapeCharacter")
    private String escapeCharacter;
    @JsonProperty(value="nullLiteral")
    private String nullLiteral;

    @JsonCreator
    public CsvFormat(@JsonProperty(value="fieldDelimiter", defaultValue=",") String fieldDelimiter, @JsonProperty(value="disableQuoteCharacter", defaultValue="false") Boolean disableQuoteCharacter, @JsonProperty(value="quoteCharacter", defaultValue="\"") String quoteCharacter, @JsonProperty(value="allowComments", defaultValue="false") Boolean allowComments, @JsonProperty(value="ignoreParseErrors", defaultValue="true") Boolean ignoreParseErrors, @JsonProperty(value="arrayElementDelimiter", defaultValue=";") String arrayElementDelimiter, @JsonProperty(value="escapeCharacter") String escapeCharacter, @JsonProperty(value="nullLiteral") String nullLiteral) {
        this.fieldDelimiter = fieldDelimiter;
        this.disableQuoteCharacter = disableQuoteCharacter;
        this.quoteCharacter = quoteCharacter;
        this.allowComments = allowComments;
        this.ignoreParseErrors = ignoreParseErrors;
        this.arrayElementDelimiter = arrayElementDelimiter;
        this.escapeCharacter = escapeCharacter;
        this.nullLiteral = nullLiteral;
    }

    @JsonCreator
    public CsvFormat() {
        this(",", true, null, false, true, ";", null, null);
    }

    @JsonCreator
    public CsvFormat(String fieldDelimiter) {
        this(fieldDelimiter, true, null, false, true, ";", null, null);
    }

    @Override
    @JsonIgnore
    public String getFormat() {
        return IDENTIFIER;
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Map<String, String> generateOptions() {
        HashMap<String, String> options = new HashMap<String, String>(16);
        options.put("format", this.getFormat());
        options.put("csv.field-delimiter", this.fieldDelimiter);
        options.put("csv.disable-quote-character", this.disableQuoteCharacter.toString());
        if (!this.disableQuoteCharacter.booleanValue()) {
            options.put("csv.quote-character", this.quoteCharacter);
        }
        if (this.allowComments != null) {
            options.put("csv.allow-comments", this.allowComments.toString());
        }
        if (this.ignoreParseErrors != null) {
            options.put("csv.ignore-parse-errors", this.ignoreParseErrors.toString());
        }
        options.put("csv.array-element-delimiter", this.arrayElementDelimiter);
        if (this.escapeCharacter != null) {
            options.put("csv.escape-character", this.escapeCharacter);
        }
        if (this.nullLiteral != null) {
            options.put("csv.null-literal", this.nullLiteral);
        }
        return options;
    }

    public String getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public Boolean getDisableQuoteCharacter() {
        return this.disableQuoteCharacter;
    }

    public String getQuoteCharacter() {
        return this.quoteCharacter;
    }

    public Boolean getAllowComments() {
        return this.allowComments;
    }

    public Boolean getIgnoreParseErrors() {
        return this.ignoreParseErrors;
    }

    public String getArrayElementDelimiter() {
        return this.arrayElementDelimiter;
    }

    public String getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public String getNullLiteral() {
        return this.nullLiteral;
    }

    public void setFieldDelimiter(String fieldDelimiter) {
        this.fieldDelimiter = fieldDelimiter;
    }

    public void setDisableQuoteCharacter(Boolean disableQuoteCharacter) {
        this.disableQuoteCharacter = disableQuoteCharacter;
    }

    public void setQuoteCharacter(String quoteCharacter) {
        this.quoteCharacter = quoteCharacter;
    }

    public void setAllowComments(Boolean allowComments) {
        this.allowComments = allowComments;
    }

    public void setIgnoreParseErrors(Boolean ignoreParseErrors) {
        this.ignoreParseErrors = ignoreParseErrors;
    }

    public void setArrayElementDelimiter(String arrayElementDelimiter) {
        this.arrayElementDelimiter = arrayElementDelimiter;
    }

    public void setEscapeCharacter(String escapeCharacter) {
        this.escapeCharacter = escapeCharacter;
    }

    public void setNullLiteral(String nullLiteral) {
        this.nullLiteral = nullLiteral;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CsvFormat)) {
            return false;
        }
        CsvFormat other = (CsvFormat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$disableQuoteCharacter = this.getDisableQuoteCharacter();
        Boolean other$disableQuoteCharacter = other.getDisableQuoteCharacter();
        if (this$disableQuoteCharacter == null ? other$disableQuoteCharacter != null : !((Object)this$disableQuoteCharacter).equals(other$disableQuoteCharacter)) {
            return false;
        }
        Boolean this$allowComments = this.getAllowComments();
        Boolean other$allowComments = other.getAllowComments();
        if (this$allowComments == null ? other$allowComments != null : !((Object)this$allowComments).equals(other$allowComments)) {
            return false;
        }
        Boolean this$ignoreParseErrors = this.getIgnoreParseErrors();
        Boolean other$ignoreParseErrors = other.getIgnoreParseErrors();
        if (this$ignoreParseErrors == null ? other$ignoreParseErrors != null : !((Object)this$ignoreParseErrors).equals(other$ignoreParseErrors)) {
            return false;
        }
        String this$fieldDelimiter = this.getFieldDelimiter();
        String other$fieldDelimiter = other.getFieldDelimiter();
        if (this$fieldDelimiter == null ? other$fieldDelimiter != null : !this$fieldDelimiter.equals(other$fieldDelimiter)) {
            return false;
        }
        String this$quoteCharacter = this.getQuoteCharacter();
        String other$quoteCharacter = other.getQuoteCharacter();
        if (this$quoteCharacter == null ? other$quoteCharacter != null : !this$quoteCharacter.equals(other$quoteCharacter)) {
            return false;
        }
        String this$arrayElementDelimiter = this.getArrayElementDelimiter();
        String other$arrayElementDelimiter = other.getArrayElementDelimiter();
        if (this$arrayElementDelimiter == null ? other$arrayElementDelimiter != null : !this$arrayElementDelimiter.equals(other$arrayElementDelimiter)) {
            return false;
        }
        String this$escapeCharacter = this.getEscapeCharacter();
        String other$escapeCharacter = other.getEscapeCharacter();
        if (this$escapeCharacter == null ? other$escapeCharacter != null : !this$escapeCharacter.equals(other$escapeCharacter)) {
            return false;
        }
        String this$nullLiteral = this.getNullLiteral();
        String other$nullLiteral = other.getNullLiteral();
        return !(this$nullLiteral == null ? other$nullLiteral != null : !this$nullLiteral.equals(other$nullLiteral));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CsvFormat;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $disableQuoteCharacter = this.getDisableQuoteCharacter();
        result = result * 59 + ($disableQuoteCharacter == null ? 43 : ((Object)$disableQuoteCharacter).hashCode());
        Boolean $allowComments = this.getAllowComments();
        result = result * 59 + ($allowComments == null ? 43 : ((Object)$allowComments).hashCode());
        Boolean $ignoreParseErrors = this.getIgnoreParseErrors();
        result = result * 59 + ($ignoreParseErrors == null ? 43 : ((Object)$ignoreParseErrors).hashCode());
        String $fieldDelimiter = this.getFieldDelimiter();
        result = result * 59 + ($fieldDelimiter == null ? 43 : $fieldDelimiter.hashCode());
        String $quoteCharacter = this.getQuoteCharacter();
        result = result * 59 + ($quoteCharacter == null ? 43 : $quoteCharacter.hashCode());
        String $arrayElementDelimiter = this.getArrayElementDelimiter();
        result = result * 59 + ($arrayElementDelimiter == null ? 43 : $arrayElementDelimiter.hashCode());
        String $escapeCharacter = this.getEscapeCharacter();
        result = result * 59 + ($escapeCharacter == null ? 43 : $escapeCharacter.hashCode());
        String $nullLiteral = this.getNullLiteral();
        result = result * 59 + ($nullLiteral == null ? 43 : $nullLiteral.hashCode());
        return result;
    }

    public String toString() {
        return "CsvFormat(fieldDelimiter=" + this.getFieldDelimiter() + ", disableQuoteCharacter=" + this.getDisableQuoteCharacter() + ", quoteCharacter=" + this.getQuoteCharacter() + ", allowComments=" + this.getAllowComments() + ", ignoreParseErrors=" + this.getIgnoreParseErrors() + ", arrayElementDelimiter=" + this.getArrayElementDelimiter() + ", escapeCharacter=" + this.getEscapeCharacter() + ", nullLiteral=" + this.getNullLiteral() + ")";
    }
}

