/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.response.parser;

import java.sql.Date;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.TimeZone;
import ru.yandex.clickhouse.response.ClickHouseColumnInfo;
import ru.yandex.clickhouse.response.parser.ClickHouseDateValueParser;

final class ClickHouseSQLDateParser
extends ClickHouseDateValueParser<Date> {
    private static ClickHouseSQLDateParser instance;

    static ClickHouseSQLDateParser getInstance() {
        if (instance == null) {
            instance = new ClickHouseSQLDateParser();
        }
        return instance;
    }

    private ClickHouseSQLDateParser() {
        super(Date.class);
    }

    @Override
    Date parseDate(String value, ClickHouseColumnInfo columnInfo, TimeZone timeZone) {
        return new Date(this.dateToZonedDateTime(value, columnInfo, timeZone).truncatedTo(ChronoUnit.DAYS).toInstant().toEpochMilli());
    }

    @Override
    Date parseDateTime(String value, ClickHouseColumnInfo columnInfo, TimeZone timeZone) {
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        return new Date(this.dateTimeToZonedDateTime(value, columnInfo, timeZone).truncatedTo(ChronoUnit.DAYS).toInstant().toEpochMilli());
    }

    @Override
    Date parseNumber(long value, ClickHouseColumnInfo columnInfo, TimeZone timeZone) {
        return new Date(this.parseAsInstant(value).atZone(ClickHouseSQLDateParser.getResultTimeZone(timeZone)).truncatedTo(ChronoUnit.DAYS).toInstant().toEpochMilli());
    }

    @Override
    Date parseOther(String value, ClickHouseColumnInfo columnInfo, TimeZone timeZone) {
        try {
            return new Date(this.parseAsInstant(value).atZone(ClickHouseSQLDateParser.getResultTimeZone(timeZone)).truncatedTo(ChronoUnit.DAYS).toInstant().toEpochMilli());
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                return new Date(this.parseAsOffsetDateTime(value).toInstant().atZone(ClickHouseSQLDateParser.getResultTimeZone(timeZone)).truncatedTo(ChronoUnit.DAYS).toInstant().toEpochMilli());
            }
            catch (DateTimeParseException dateTimeParseException2) {
                try {
                    return new Date(this.parseAsLocalDateTime(value).atZone(ClickHouseSQLDateParser.getParsingTimeZone(columnInfo, timeZone)).withZoneSameInstant(ClickHouseSQLDateParser.getResultTimeZone(timeZone)).truncatedTo(ChronoUnit.DAYS).toInstant().toEpochMilli());
                }
                catch (DateTimeParseException dateTimeParseException3) {
                    return new Date(LocalDateTime.of(this.parseAsLocalDate(value), LocalTime.MIDNIGHT).atZone(ClickHouseSQLDateParser.getResultTimeZone(timeZone)).toInstant().toEpochMilli());
                }
            }
        }
    }

    private static ZoneId getParsingTimeZone(ClickHouseColumnInfo columnInfo, TimeZone timeZone) {
        return columnInfo.getTimeZone() != null ? columnInfo.getTimeZone().toZoneId() : (timeZone != null ? timeZone.toZoneId() : ZoneId.systemDefault());
    }

    private static ZoneId getResultTimeZone(TimeZone timeZone) {
        return timeZone != null ? timeZone.toZoneId() : ZoneId.systemDefault();
    }
}

