/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.decode;

import java.io.ByteArrayInputStream;
import org.apache.parquet.io.DelegatingSeekableInputStream;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;

public class ParquetInputByteArray
implements InputFile {
    private final byte[] data;

    public ParquetInputByteArray(byte[] data) {
        this.data = data;
    }

    public long getLength() {
        return this.data.length;
    }

    public SeekableInputStream newStream() {
        return new DelegatingSeekableInputStream(new SeekableByteArrayInputStream(this.data)){

            public void seek(long newPos) {
                ((SeekableByteArrayInputStream)this.getStream()).setPos((int)newPos);
            }

            public long getPos() {
                return ((SeekableByteArrayInputStream)this.getStream()).getPos();
            }
        };
    }

    private class SeekableByteArrayInputStream
    extends ByteArrayInputStream {
        public SeekableByteArrayInputStream(byte[] buf) {
            super(buf);
        }

        public void setPos(int pos) {
            this.pos = pos;
        }

        public int getPos() {
            return this.pos;
        }
    }
}

