/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.decode;

import com.google.protobuf.Descriptors;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;

public class PbNode {
    private String name;
    private Descriptors.FieldDescriptor fieldDesc;
    private Descriptors.Descriptor messageType;
    private boolean isArray = false;
    private int arrayIndex = -1;
    private boolean isLastNode = false;

    public PbNode(Descriptors.Descriptor messageDesc, String nodeString, boolean isLastNode) {
        int beginIndex = nodeString.indexOf(40);
        if (beginIndex < 0) {
            this.name = nodeString;
            this.fieldDesc = messageDesc.findFieldByName(this.name);
            if (this.fieldDesc.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                this.messageType = this.fieldDesc.getMessageType();
            }
        } else {
            int endIndex;
            this.name = StringUtils.trim((String)nodeString.substring(0, beginIndex));
            this.fieldDesc = messageDesc.findFieldByName(this.name);
            if (this.fieldDesc.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                this.messageType = this.fieldDesc.getMessageType();
            }
            if ((endIndex = nodeString.lastIndexOf(41)) >= 0) {
                this.isArray = true;
                this.arrayIndex = NumberUtils.toInt((String)nodeString.substring(beginIndex + 1, endIndex), (int)-1);
                if (this.arrayIndex < 0) {
                    this.arrayIndex = 0;
                }
            }
        }
        this.isLastNode = isLastNode;
    }

    public static List<PbNode> parseNodePath(Descriptors.Descriptor rootDesc, String nodePath) {
        if (StringUtils.isBlank((CharSequence)nodePath)) {
            return null;
        }
        ArrayList<PbNode> nodes = new ArrayList<PbNode>();
        String[] nodeStrings = nodePath.split("\\.");
        int lastIndex = nodeStrings.length - 1;
        Descriptors.Descriptor current = rootDesc;
        for (int i = 0; i <= lastIndex; ++i) {
            if (current == null) {
                return null;
            }
            String nodeString = nodeStrings[i];
            PbNode pbNode = new PbNode(current, nodeString, i == lastIndex);
            current = pbNode.getMessageType();
            nodes.add(pbNode);
        }
        return nodes;
    }

    public String getName() {
        return this.name;
    }

    public Descriptors.FieldDescriptor getFieldDesc() {
        return this.fieldDesc;
    }

    public Descriptors.Descriptor getMessageType() {
        return this.messageType;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public int getArrayIndex() {
        return this.arrayIndex;
    }

    public boolean isLastNode() {
        return this.isLastNode;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFieldDesc(Descriptors.FieldDescriptor fieldDesc) {
        this.fieldDesc = fieldDesc;
    }

    public void setMessageType(Descriptors.Descriptor messageType) {
        this.messageType = messageType;
    }

    public void setArray(boolean isArray) {
        this.isArray = isArray;
    }

    public void setArrayIndex(int arrayIndex) {
        this.arrayIndex = arrayIndex;
    }

    public void setLastNode(boolean isLastNode) {
        this.isLastNode = isLastNode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PbNode)) {
            return false;
        }
        PbNode other = (PbNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isArray() != other.isArray()) {
            return false;
        }
        if (this.getArrayIndex() != other.getArrayIndex()) {
            return false;
        }
        if (this.isLastNode() != other.isLastNode()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Descriptors.FieldDescriptor this$fieldDesc = this.getFieldDesc();
        Descriptors.FieldDescriptor other$fieldDesc = other.getFieldDesc();
        if (this$fieldDesc == null ? other$fieldDesc != null : !this$fieldDesc.equals(other$fieldDesc)) {
            return false;
        }
        Descriptors.Descriptor this$messageType = this.getMessageType();
        Descriptors.Descriptor other$messageType = other.getMessageType();
        return !(this$messageType == null ? other$messageType != null : !this$messageType.equals(other$messageType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PbNode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isArray() ? 79 : 97);
        result = result * 59 + this.getArrayIndex();
        result = result * 59 + (this.isLastNode() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Descriptors.FieldDescriptor $fieldDesc = this.getFieldDesc();
        result = result * 59 + ($fieldDesc == null ? 43 : $fieldDesc.hashCode());
        Descriptors.Descriptor $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : $messageType.hashCode());
        return result;
    }

    public String toString() {
        return "PbNode(name=" + this.getName() + ", fieldDesc=" + this.getFieldDesc() + ", messageType=" + this.getMessageType() + ", isArray=" + this.isArray() + ", arrayIndex=" + this.getArrayIndex() + ", isLastNode=" + this.isLastNode() + ")";
    }
}

