/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.arithmetic;

import java.math.BigDecimal;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="arithmetic", names={"log"}, parameter="(Numeric numeric1 [, Numeric numeric2])", descriptions={"- Return the natural logarithm of 'numeric1' when called with one argument;", "- Return the logarithm of 'numeric2' to the base 'numeric1' when called with two arguments."}, examples={"log(1) = 0.0", "log(2,8) = 3.0"})
public class LogFunction
implements ValueParser {
    private ValueParser baseParser;
    private final ValueParser numberParser;

    public LogFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        if (expressions.size() == 1) {
            this.numberParser = OperatorTools.buildParser((Expression)expressions.get(0));
        } else {
            this.baseParser = OperatorTools.buildParser((Expression)expressions.get(0));
            this.numberParser = OperatorTools.buildParser((Expression)expressions.get(1));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object numberObj = this.numberParser.parse(sourceData, rowIndex, context);
        BigDecimal numberValue = OperatorTools.parseBigDecimal(numberObj);
        if (this.baseParser != null) {
            Object baseObj = this.baseParser.parse(sourceData, rowIndex, context);
            BigDecimal baseValue = OperatorTools.parseBigDecimal(baseObj);
            return Math.log(numberValue.doubleValue()) / Math.log(baseValue.doubleValue());
        }
        return Math.log(numberValue.doubleValue());
    }
}

