/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.encryption;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="encryption", names={"to_base64"}, parameter="(String str)", descriptions={"- Return \"\" if 'str' is NULL;", "- Return the base64-encoded result from 'str'."}, examples={"to_base64('app-fun') = \"YXBwLWZ1bg==\""})
public class ToBase64Function
implements ValueParser {
    private final ValueParser stringParser;

    public ToBase64Function(Function expr) {
        this.stringParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object stringObj = this.stringParser.parse(sourceData, rowIndex, context);
        if (stringObj == null) {
            return null;
        }
        String string = OperatorTools.parseString(stringObj);
        return Base64.getEncoder().encodeToString(string.getBytes(StandardCharsets.UTF_8));
    }
}

